/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.action;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import org.exbin.framework.editor.xbup.gui.XBDocTreeTransferHandler;
import org.exbin.framework.editor.xbup.viewer.XbupEditorProvider;
import org.exbin.framework.editor.xbup.viewer.XbupFileHandler;
import org.exbin.framework.utils.ClipboardUtils;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.block.XBTEditableBlock;
import org.exbin.xbup.core.block.XBTEditableDocument;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.operation.Command;
import org.exbin.xbup.operation.basic.command.XBTAddBlockCommand;
import org.exbin.xbup.operation.undo.XBUndoHandler;
import org.exbin.xbup.parser_tree.XBTTreeDocument;
import org.exbin.xbup.parser_tree.XBTTreeNode;

@ParametersAreNonnullByDefault
public class PasteItemAction
extends AbstractAction {
    public static final String ACTION_ID = "pasteItemAction";
    private XbupEditorProvider editorProvider;

    public void setup(XbupEditorProvider editorProvider) {
        this.editorProvider = editorProvider;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Clipboard clipboard = ClipboardUtils.getClipboard();
        if (clipboard.isDataFlavorAvailable(XBDocTreeTransferHandler.XB_DATA_FLAVOR)) {
            XbupFileHandler xbupFile = (XbupFileHandler)this.editorProvider.getActiveFile().get();
            XBUndoHandler undoHandler = xbupFile.getUndoHandler();
            XBTTreeDocument mainDoc = xbupFile.getDocument();
            try {
                ByteArrayOutputStream stream = (ByteArrayOutputStream)clipboard.getData(XBDocTreeTransferHandler.XB_DATA_FLAVOR);
                XBTBlock block = xbupFile.getSelectedItem().get();
                if (!(block instanceof XBTTreeNode)) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
                XBTTreeNode node = (XBTTreeNode)block;
                XBTTreeNode newNode = new XBTTreeNode(node);
                try {
                    newNode.fromStreamUB((InputStream)new ByteArrayInputStream(stream.toByteArray()));
                    try {
                        long parentPosition = node == null ? -1L : (long)node.getBlockIndex();
                        int childIndex = node == null ? 0 : node.getChildCount();
                        XBTAddBlockCommand step = new XBTAddBlockCommand((XBTEditableDocument)mainDoc, parentPosition, childIndex, (XBTEditableBlock)newNode);
                        undoHandler.execute((Command)step);
                        xbupFile.notifyFileChanged();
                    }
                    catch (Exception ex) {
                        Logger.getLogger(PasteItemAction.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                catch (IOException | XBProcessingException ex) {
                    Logger.getLogger(PasteItemAction.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (UnsupportedFlavorException | IOException ex) {
                Logger.getLogger(PasteItemAction.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

