/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.action;

import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import org.exbin.framework.editor.xbup.viewer.XbupEditorProvider;
import org.exbin.framework.editor.xbup.viewer.XbupFileHandler;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.block.XBTEditableDocument;
import org.exbin.xbup.operation.Command;
import org.exbin.xbup.operation.basic.command.XBTDeleteBlockCommand;
import org.exbin.xbup.operation.undo.XBUndoHandler;
import org.exbin.xbup.parser_tree.XBTTreeDocument;
import org.exbin.xbup.parser_tree.XBTTreeNode;

@ParametersAreNonnullByDefault
public class DeleteItemAction
extends AbstractAction {
    public static final String ACTION_ID = "deleteItemAction";
    private XbupEditorProvider editorProvider;

    public void setup(XbupEditorProvider editorProvider) {
        this.editorProvider = editorProvider;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DeleteItemAction.performDelete(this.editorProvider);
    }

    static void performDelete(XbupEditorProvider viewerProvider) {
        XbupFileHandler xbupFile = (XbupFileHandler)viewerProvider.getActiveFile().get();
        XBTBlock block = xbupFile.getSelectedItem().get();
        if (!(block instanceof XBTTreeNode)) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        XBTTreeNode node = (XBTTreeNode)block;
        XBTTreeDocument mainDoc = xbupFile.getDocument();
        XBUndoHandler undoHandler = xbupFile.getUndoHandler();
        XBTTreeNode parent = node.getParent();
        try {
            XBTDeleteBlockCommand command = new XBTDeleteBlockCommand((XBTEditableDocument)mainDoc, node);
            undoHandler.execute((Command)command);
        }
        catch (Exception ex) {
            Logger.getLogger(DeleteItemAction.class.getName()).log(Level.SEVERE, null, ex);
        }
        mainDoc.setModified(true);
    }
}

