/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.basic;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.bined.CaretOverlapMode;
import org.exbin.bined.CodeAreaCaret;
import org.exbin.bined.CodeAreaCaretPosition;
import org.exbin.bined.CodeAreaSection;
import org.exbin.bined.CodeAreaSelection;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.CodeCharactersCase;
import org.exbin.bined.CodeType;
import org.exbin.bined.DataChangedListener;
import org.exbin.bined.DataProvider;
import org.exbin.bined.DefaultCodeAreaCaretPosition;
import org.exbin.bined.EditOperation;
import org.exbin.bined.PositionCodeType;
import org.exbin.bined.basic.BasicBackgroundPaintMode;
import org.exbin.bined.basic.BasicCodeAreaLayout;
import org.exbin.bined.basic.BasicCodeAreaScrolling;
import org.exbin.bined.basic.BasicCodeAreaSection;
import org.exbin.bined.basic.BasicCodeAreaStructure;
import org.exbin.bined.basic.BasicCodeAreaZone;
import org.exbin.bined.basic.CodeAreaScrollPosition;
import org.exbin.bined.basic.CodeAreaViewMode;
import org.exbin.bined.basic.MovementDirection;
import org.exbin.bined.basic.PositionScrollVisibility;
import org.exbin.bined.basic.ScrollViewDimension;
import org.exbin.bined.basic.ScrollingDirection;
import org.exbin.bined.capability.BackgroundPaintCapable;
import org.exbin.bined.capability.CaretCapable;
import org.exbin.bined.capability.CharsetCapable;
import org.exbin.bined.capability.CodeCharactersCaseCapable;
import org.exbin.bined.capability.EditModeCapable;
import org.exbin.bined.capability.RowWrappingCapable;
import org.exbin.bined.capability.ScrollingCapable;
import org.exbin.bined.capability.SelectionCapable;
import org.exbin.bined.swing.CodeAreaCore;
import org.exbin.bined.swing.CodeAreaPainter;
import org.exbin.bined.swing.CodeAreaSwingControl;
import org.exbin.bined.swing.CodeAreaSwingUtils;
import org.exbin.bined.swing.basic.AntialiasingMode;
import org.exbin.bined.swing.basic.BasicCodeAreaDimensions;
import org.exbin.bined.swing.basic.BasicCodeAreaMetrics;
import org.exbin.bined.swing.basic.BasicCodeAreaVisibility;
import org.exbin.bined.swing.basic.DefaultCodeAreaCaret;
import org.exbin.bined.swing.basic.DefaultCodeAreaMouseListener;
import org.exbin.bined.swing.basic.DefaultCodeAreaScrollPane;
import org.exbin.bined.swing.basic.color.BasicCodeAreaColorsProfile;
import org.exbin.bined.swing.basic.color.BasicColorsCapableCodeAreaPainter;
import org.exbin.bined.swing.capability.AntialiasingCapable;
import org.exbin.bined.swing.capability.FontCapable;

@ParametersAreNonnullByDefault
public class DefaultCodeAreaPainter
implements CodeAreaPainter,
BasicColorsCapableCodeAreaPainter {
    @Nonnull
    protected final CodeAreaCore codeArea;
    private volatile boolean initialized = false;
    private volatile boolean fontChanged = false;
    private volatile boolean layoutChanged = true;
    private volatile boolean resetColors = true;
    private volatile boolean caretChanged = true;
    @Nonnull
    private final JComponent dataView;
    @Nonnull
    private final DefaultCodeAreaScrollPane scrollPanel;
    @Nonnull
    private final DefaultCodeAreaMouseListener codeAreaMouseListener;
    @Nonnull
    private final ComponentListener codeAreaComponentListener;
    @Nonnull
    private final DataChangedListener codeAreaDataChangeListener;
    @Nonnull
    private final BasicCodeAreaMetrics metrics = new BasicCodeAreaMetrics();
    @Nonnull
    private final BasicCodeAreaStructure structure = new BasicCodeAreaStructure();
    @Nonnull
    private final BasicCodeAreaScrolling scrolling = new BasicCodeAreaScrolling();
    @Nonnull
    private final BasicCodeAreaDimensions dimensions = new BasicCodeAreaDimensions();
    @Nonnull
    private final BasicCodeAreaVisibility visibility = new BasicCodeAreaVisibility();
    @Nonnull
    private final BasicCodeAreaLayout layout = new BasicCodeAreaLayout();
    @Nonnull
    private BasicCodeAreaColorsProfile colorsProfile = new BasicCodeAreaColorsProfile();
    @Nullable
    private CodeCharactersCase codeCharactersCase;
    @Nullable
    private EditOperation editOperation;
    @Nullable
    private BasicBackgroundPaintMode backgroundPaintMode;
    @Nullable
    private ScrollViewDimension viewDimension;
    private boolean showMirrorCursor;
    @Nonnull
    private AntialiasingMode antialiasingMode = AntialiasingMode.AUTO;
    private int rowPositionLength;
    private int minRowPositionLength;
    private int maxRowPositionLength;
    @Nullable
    private Font font;
    @Nullable
    private Charset charset;
    @Nullable
    private RowDataCache rowDataCache = null;
    @Nullable
    private CursorDataCache cursorDataCache = null;
    @Nullable
    private Charset charMappingCharset = null;
    @Nonnull
    private final char[] charMapping = new char[256];

    public DefaultCodeAreaPainter(CodeAreaCore codeArea) {
        this.codeArea = codeArea;
        this.dataView = new JComponent(){};
        this.dataView.setBorder(null);
        this.dataView.setVisible(false);
        this.dataView.setLayout(null);
        this.dataView.setOpaque(false);
        this.dataView.setInheritsPopupMenu(true);
        this.dataView.setPreferredSize(new Dimension(0, 0));
        this.scrollPanel = new DefaultCodeAreaScrollPane((CodeAreaSwingControl)((Object)codeArea), this.metrics, this.structure, this.dimensions, this.scrolling);
        this.scrollPanel.setViewportView(this.dataView);
        JViewport viewport = this.scrollPanel.getViewport();
        viewport.setOpaque(false);
        this.scrolling.setHorizontalExtentChangeListener(this::horizontalExtentChanged);
        this.scrolling.setVerticalExtentChangeListener(this::verticalExtentChanged);
        this.codeAreaMouseListener = new DefaultCodeAreaMouseListener(codeArea, this.scrollPanel);
        viewport.addMouseListener(this.codeAreaMouseListener);
        viewport.addMouseMotionListener(this.codeAreaMouseListener);
        viewport.addMouseWheelListener(this.codeAreaMouseListener);
        viewport.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int verticalScrollBarSize = DefaultCodeAreaPainter.this.getVerticalScrollBarSize();
                int horizontalScrollBarSize = DefaultCodeAreaPainter.this.getHorizontalScrollBarSize();
                if (DefaultCodeAreaPainter.this.dimensions.getVerticalScrollBarSize() != verticalScrollBarSize || DefaultCodeAreaPainter.this.dimensions.getHorizontalScrollBarSize() != horizontalScrollBarSize) {
                    DefaultCodeAreaPainter.this.recomputeDimensions();
                    DefaultCodeAreaPainter.this.recomputeScrollState();
                }
                JViewport viewport = DefaultCodeAreaPainter.this.scrollPanel.getViewport();
                if (DefaultCodeAreaPainter.this.viewDimension != null && (DefaultCodeAreaPainter.this.viewDimension.getDataViewWidth() != viewport.getWidth() || DefaultCodeAreaPainter.this.viewDimension.getDataViewHeight() != viewport.getHeight())) {
                    DefaultCodeAreaPainter.this.updateScrollBars();
                }
            }
        });
        this.codeAreaComponentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                DefaultCodeAreaPainter.this.recomputeLayout();
            }
        };
        this.codeAreaDataChangeListener = this::dataChanged;
        this.rebuildColors();
    }

    @Override
    public void attach() {
        this.codeArea.add(this.scrollPanel);
        this.codeArea.addMouseListener(this.codeAreaMouseListener);
        this.codeArea.addMouseMotionListener(this.codeAreaMouseListener);
        this.codeArea.addMouseWheelListener(this.codeAreaMouseListener);
        this.codeArea.addComponentListener(this.codeAreaComponentListener);
        this.codeArea.addDataChangedListener(this.codeAreaDataChangeListener);
    }

    @Override
    public void detach() {
        this.codeArea.remove(this.scrollPanel);
        this.codeArea.removeMouseListener(this.codeAreaMouseListener);
        this.codeArea.removeMouseMotionListener(this.codeAreaMouseListener);
        this.codeArea.removeMouseWheelListener(this.codeAreaMouseListener);
        this.codeArea.removeComponentListener(this.codeAreaComponentListener);
        this.codeArea.removeDataChangedListener(this.codeAreaDataChangeListener);
    }

    @Override
    public void reset() {
        this.resetColors();
        this.resetFont();
        this.resetLayout();
        this.resetCaret();
    }

    @Override
    public void resetColors() {
        this.resetColors = true;
    }

    @Override
    public void resetFont() {
        this.fontChanged = true;
        this.resetLayout();
    }

    @Override
    public void resetLayout() {
        this.layoutChanged = true;
    }

    @Override
    public void resetCaret() {
        this.caretChanged = true;
    }

    @Override
    public void rebuildColors() {
        this.colorsProfile.reinitialize();
    }

    private void recomputeLayout() {
        this.rowPositionLength = this.getRowPositionLength();
        this.recomputeDimensions();
        int charactersPerPage = this.dimensions.getCharactersPerPage();
        this.structure.updateCache((DataProvider)this.codeArea, charactersPerPage);
        this.codeCharactersCase = ((CodeCharactersCaseCapable)this.codeArea).getCodeCharactersCase();
        this.backgroundPaintMode = ((BackgroundPaintCapable)this.codeArea).getBackgroundPaintMode();
        this.showMirrorCursor = ((CaretCapable)this.codeArea).isShowMirrorCursor();
        this.antialiasingMode = ((AntialiasingCapable)((Object)this.codeArea)).getAntialiasingMode();
        this.minRowPositionLength = ((RowWrappingCapable)this.codeArea).getMinRowPositionLength();
        this.maxRowPositionLength = ((RowWrappingCapable)this.codeArea).getMaxRowPositionLength();
        int rowsPerPage = this.dimensions.getRowsPerPage();
        long rowsPerDocument = this.structure.getRowsPerDocument();
        int charactersPerRow = this.structure.getCharactersPerRow();
        if (this.metrics.isInitialized()) {
            this.scrolling.updateMaximumScrollPosition(rowsPerDocument, rowsPerPage, charactersPerRow, charactersPerPage, this.dimensions.getLastCharOffset(), this.dimensions.getLastRowOffset());
        }
        this.updateScrollBars();
        this.layoutChanged = false;
    }

    private void updateCaret() {
        this.editOperation = ((EditModeCapable)this.codeArea).getActiveOperation();
        this.caretChanged = false;
    }

    private void validateCaret() {
        CodeAreaCaret caret = ((CaretCapable)this.codeArea).getCaret();
        CodeAreaCaretPosition caretPosition = caret.getCaretPosition();
        if (caretPosition.getDataPosition() > this.codeArea.getDataSize()) {
            caret.setCaretPosition(null);
        }
    }

    private void validateSelection() {
        CodeAreaSelection selectionHandler = ((SelectionCapable)this.codeArea).getSelectionHandler();
        if (!selectionHandler.isEmpty()) {
            long dataSize = this.codeArea.getDataSize();
            if (dataSize == 0L) {
                ((SelectionCapable)this.codeArea).clearSelection();
            } else {
                boolean selectionChanged = false;
                long start = selectionHandler.getStart();
                long end = selectionHandler.getEnd();
                if (start >= dataSize) {
                    start = dataSize;
                    selectionChanged = true;
                }
                if (end >= dataSize) {
                    end = dataSize;
                    selectionChanged = true;
                }
                if (selectionChanged) {
                    ((SelectionCapable)this.codeArea).setSelection(start, end);
                }
            }
        }
    }

    private void recomputeDimensions() {
        int verticalScrollBarSize = this.getVerticalScrollBarSize();
        int horizontalScrollBarSize = this.getHorizontalScrollBarSize();
        Insets insets = this.codeArea.getInsets();
        int componentWidth = this.codeArea.getWidth() - insets.left - insets.right;
        int componentHeight = this.codeArea.getHeight() - insets.top - insets.bottom;
        this.dimensions.recomputeSizes(this.metrics, insets.right, insets.top, componentWidth, componentHeight, this.rowPositionLength, verticalScrollBarSize, horizontalScrollBarSize);
    }

    public void recomputeCharPositions() {
        this.visibility.recomputeCharPositions(this.metrics, this.structure, this.dimensions, this.layout, this.scrolling);
        this.updateRowDataCache();
    }

    private void updateRowDataCache() {
        if (this.rowDataCache == null) {
            this.rowDataCache = new RowDataCache();
        }
        this.rowDataCache.headerChars = new char[this.visibility.getCharactersPerCodeSection()];
        this.rowDataCache.rowData = new byte[this.structure.getBytesPerRow() + this.metrics.getMaxBytesPerChar() - 1];
        this.rowDataCache.rowPositionCode = new char[this.rowPositionLength];
        this.rowDataCache.rowCharacters = new char[this.structure.getCharactersPerRow()];
    }

    public void fontChanged(Graphics g) {
        if (this.font == null) {
            this.reset();
        }
        this.charset = ((CharsetCapable)this.codeArea).getCharset();
        this.font = ((FontCapable)((Object)this.codeArea)).getCodeFont();
        this.metrics.recomputeMetrics(g.getFontMetrics(this.font), this.charset);
        this.recomputeDimensions();
        this.recomputeCharPositions();
        this.initialized = true;
    }

    private void recomputeScrollState() {
        this.scrolling.setScrollPosition(((ScrollingCapable)this.codeArea).getScrollPosition());
        int characterWidth = this.metrics.getCharacterWidth();
        if (characterWidth > 0) {
            this.scrolling.updateCache((DataProvider)this.codeArea, this.getHorizontalScrollBarSize(), this.getVerticalScrollBarSize());
            this.recomputeCharPositions();
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.initialized) {
            this.reset();
        }
        this.updateCache();
        if (this.font == null) {
            this.fontChanged(g);
        }
        if (this.rowDataCache == null) {
            return;
        }
        if (this.antialiasingMode != AntialiasingMode.OFF && g instanceof Graphics2D) {
            Object antialiasingHint = this.antialiasingMode.getAntialiasingHint((Graphics2D)g);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, antialiasingHint);
        }
        if (this.layoutChanged) {
            this.recomputeLayout();
            this.recomputeCharPositions();
        }
        this.paintOutsideArea(g);
        this.paintHeader(g);
        this.paintRowPosition(g);
        this.paintMainArea(g);
    }

    protected synchronized void updateCache() {
        if (this.resetColors) {
            this.resetColors = false;
            this.rebuildColors();
        }
    }

    public void paintOutsideArea(Graphics g) {
        int headerAreaHeight = this.dimensions.getHeaderAreaHeight();
        int rowPositionAreaWidth = this.dimensions.getRowPositionAreaWidth();
        Rectangle componentRect = this.dimensions.getComponentRectangle();
        int characterWidth = this.metrics.getCharacterWidth();
        g.setColor(this.colorsProfile.getTextBackground());
        g.fillRect(componentRect.x, componentRect.y, componentRect.width, headerAreaHeight);
        g.setColor(this.colorsProfile.getDecorationLine());
        g.drawLine(componentRect.x, componentRect.y + headerAreaHeight - 1, componentRect.x + rowPositionAreaWidth, componentRect.y + headerAreaHeight - 1);
        int lineX = componentRect.x + rowPositionAreaWidth - characterWidth / 2;
        if (lineX >= componentRect.x) {
            g.drawLine(lineX, componentRect.y, lineX, componentRect.y + headerAreaHeight);
        }
    }

    public void paintHeader(Graphics g) {
        int charactersPerCodeSection = this.visibility.getCharactersPerCodeSection();
        Rectangle headerArea = this.dimensions.getHeaderAreaRectangle();
        CodeAreaScrollPosition scrollPosition = this.scrolling.getScrollPosition();
        Rectangle clipBounds = g.getClipBounds();
        g.setClip(clipBounds != null ? clipBounds.intersection(headerArea) : headerArea);
        int characterWidth = this.metrics.getCharacterWidth();
        int rowHeight = this.metrics.getRowHeight();
        int dataViewX = this.dimensions.getScrollPanelX();
        g.setFont(this.font);
        g.setColor(this.colorsProfile.getTextBackground());
        g.fillRect(headerArea.x, headerArea.y, headerArea.width, headerArea.height);
        CodeAreaViewMode viewMode = this.structure.getViewMode();
        if (viewMode == CodeAreaViewMode.DUAL || viewMode == CodeAreaViewMode.CODE_MATRIX) {
            int headerX = dataViewX - scrollPosition.getCharPosition() * characterWidth - scrollPosition.getCharOffset();
            int headerY = headerArea.y + rowHeight - this.metrics.getSubFontSpace();
            g.setColor(this.colorsProfile.getTextColor());
            Arrays.fill(this.rowDataCache.headerChars, ' ');
            boolean interleaving = false;
            int lastPos = 0;
            int skipToCode = this.visibility.getSkipToCode();
            int skipRestFromCode = this.visibility.getSkipRestFromCode();
            for (int index = skipToCode; index < skipRestFromCode; ++index) {
                int codePos = this.structure.computeFirstCodeCharacterPos(index);
                if (codePos == lastPos + 2 && !interleaving) {
                    interleaving = true;
                    continue;
                }
                CodeAreaUtils.longToBaseCode((char[])this.rowDataCache.headerChars, (int)codePos, (long)index, (int)CodeType.HEXADECIMAL.getBase(), (int)2, (boolean)true, (CodeCharactersCase)this.codeCharactersCase);
                lastPos = codePos;
                interleaving = false;
            }
            int skipToChar = this.visibility.getSkipToChar();
            int skipRestFromChar = this.visibility.getSkipRestFromChar();
            int codeCharEnd = Math.min(skipRestFromChar, this.visibility.getCharactersPerCodeSection());
            int renderOffset = skipToChar;
            Color renderColor = null;
            for (int characterOnRow = skipToChar; characterOnRow < codeCharEnd; ++characterOnRow) {
                boolean sequenceBreak = false;
                char currentChar = this.rowDataCache.headerChars[characterOnRow];
                if (currentChar == ' ' && renderOffset == characterOnRow) {
                    ++renderOffset;
                    continue;
                }
                Color color = this.colorsProfile.getTextColor();
                if (!CodeAreaSwingUtils.areSameColors(color, renderColor)) {
                    sequenceBreak = true;
                }
                if (!sequenceBreak) continue;
                if (renderOffset < characterOnRow) {
                    this.drawCenteredChars(g, this.rowDataCache.headerChars, renderOffset, characterOnRow - renderOffset, characterWidth, headerX + renderOffset * characterWidth, headerY);
                }
                if (!CodeAreaSwingUtils.areSameColors(color, renderColor)) {
                    renderColor = color;
                    g.setColor(color);
                }
                renderOffset = characterOnRow;
            }
            if (renderOffset < charactersPerCodeSection) {
                this.drawCenteredChars(g, this.rowDataCache.headerChars, renderOffset, charactersPerCodeSection - renderOffset, characterWidth, headerX + renderOffset * characterWidth, headerY);
            }
        }
        g.setColor(this.colorsProfile.getDecorationLine());
        g.drawLine(headerArea.x, headerArea.y + headerArea.height - 1, headerArea.x + headerArea.width, headerArea.y + headerArea.height - 1);
        int lineX = dataViewX + this.visibility.getPreviewRelativeX() - scrollPosition.getCharPosition() * characterWidth - scrollPosition.getCharOffset() - characterWidth / 2 - 1;
        if (lineX >= dataViewX) {
            g.drawLine(lineX, headerArea.y, lineX, headerArea.y + headerArea.height);
        }
        g.setClip(clipBounds);
    }

    public void paintRowPosition(Graphics g) {
        int row;
        long dataPosition;
        int bytesPerRow = this.structure.getBytesPerRow();
        long dataSize = this.codeArea.getDataSize();
        int rowHeight = this.metrics.getRowHeight();
        int characterWidth = this.metrics.getCharacterWidth();
        int subFontSpace = this.metrics.getSubFontSpace();
        int rowsPerRect = this.dimensions.getRowsPerRect();
        Rectangle rowPosRectangle = this.dimensions.getRowPositionAreaRectangle();
        Rectangle dataViewRectangle = this.dimensions.getDataViewRectangle();
        Rectangle clipBounds = g.getClipBounds();
        g.setClip(clipBounds != null ? clipBounds.intersection(rowPosRectangle) : rowPosRectangle);
        g.setFont(this.font);
        g.setColor(this.colorsProfile.getTextBackground());
        g.fillRect(rowPosRectangle.x, rowPosRectangle.y, rowPosRectangle.width, rowPosRectangle.height);
        CodeAreaScrollPosition scrollPosition = this.scrolling.getScrollPosition();
        if (this.backgroundPaintMode == BasicBackgroundPaintMode.STRIPED) {
            dataPosition = scrollPosition.getRowPosition() * (long)bytesPerRow + (long)((scrollPosition.getRowPosition() & 1L) > 0L ? 0 : bytesPerRow);
            int stripePositionY = rowPosRectangle.y - scrollPosition.getRowOffset() + ((scrollPosition.getRowPosition() & 1L) > 0L ? 0 : rowHeight);
            g.setColor(this.colorsProfile.getAlternateBackground());
            for (row = 0; row <= rowsPerRect / 2 && dataPosition <= dataSize; dataPosition += (long)(bytesPerRow * 2), ++row) {
                g.fillRect(rowPosRectangle.x, stripePositionY, rowPosRectangle.width, rowHeight);
                stripePositionY += rowHeight * 2;
            }
        }
        dataPosition = (long)bytesPerRow * scrollPosition.getRowPosition();
        int positionY = rowPosRectangle.y + rowHeight - subFontSpace - scrollPosition.getRowOffset();
        g.setColor(this.colorsProfile.getTextColor());
        for (row = 0; row <= rowsPerRect && dataPosition <= dataSize; ++row) {
            CodeAreaUtils.longToBaseCode((char[])this.rowDataCache.rowPositionCode, (int)0, (long)(dataPosition < 0L ? 0L : dataPosition), (int)CodeType.HEXADECIMAL.getBase(), (int)this.rowPositionLength, (boolean)true, (CodeCharactersCase)this.codeCharactersCase);
            this.drawCenteredChars(g, this.rowDataCache.rowPositionCode, 0, this.rowPositionLength, characterWidth, rowPosRectangle.x, positionY);
            positionY += rowHeight;
            if ((dataPosition += (long)bytesPerRow) < 0L) break;
        }
        g.setColor(this.colorsProfile.getDecorationLine());
        int lineX = rowPosRectangle.x + rowPosRectangle.width - characterWidth / 2;
        if (lineX >= rowPosRectangle.x) {
            g.drawLine(lineX, dataViewRectangle.y, lineX, dataViewRectangle.y + dataViewRectangle.height);
        }
        g.drawLine(dataViewRectangle.x, dataViewRectangle.y - 1, dataViewRectangle.x + dataViewRectangle.width, dataViewRectangle.y - 1);
        g.setClip(clipBounds);
    }

    @Override
    public void paintMainArea(Graphics g) {
        if (!this.initialized) {
            this.reset();
        }
        if (this.fontChanged) {
            this.fontChanged(g);
            this.fontChanged = false;
        }
        Rectangle mainAreaRect = this.dimensions.getMainAreaRectangle();
        Rectangle dataViewRectangle = this.dimensions.getDataViewRectangle();
        CodeAreaScrollPosition scrollPosition = this.scrolling.getScrollPosition();
        int characterWidth = this.metrics.getCharacterWidth();
        int previewRelativeX = this.visibility.getPreviewRelativeX();
        Rectangle clipBounds = g.getClipBounds();
        g.setClip(clipBounds != null ? clipBounds.intersection(mainAreaRect) : mainAreaRect);
        this.paintBackground(g);
        g.setColor(this.colorsProfile.getDecorationLine());
        int lineX = dataViewRectangle.x + previewRelativeX - scrollPosition.getCharPosition() * characterWidth - scrollPosition.getCharOffset() - characterWidth / 2 - 1;
        if (lineX >= dataViewRectangle.x) {
            g.drawLine(lineX, dataViewRectangle.y, lineX, dataViewRectangle.y + dataViewRectangle.height);
        }
        this.paintRows(g);
        g.setClip(clipBounds);
        this.paintCursor(g);
    }

    public void paintBackground(Graphics g) {
        int bytesPerRow = this.structure.getBytesPerRow();
        long dataSize = this.codeArea.getDataSize();
        int rowHeight = this.metrics.getRowHeight();
        int rowsPerRect = this.dimensions.getRowsPerRect();
        Rectangle dataViewRect = this.dimensions.getDataViewRectangle();
        CodeAreaScrollPosition scrollPosition = this.scrolling.getScrollPosition();
        g.setColor(this.colorsProfile.getTextBackground());
        if (this.backgroundPaintMode != BasicBackgroundPaintMode.TRANSPARENT) {
            g.fillRect(dataViewRect.x, dataViewRect.y, dataViewRect.width, dataViewRect.height);
        }
        if (this.backgroundPaintMode == BasicBackgroundPaintMode.STRIPED) {
            long dataPosition = scrollPosition.getRowPosition() * (long)bytesPerRow + (long)((scrollPosition.getRowPosition() & 1L) > 0L ? 0 : bytesPerRow);
            int stripePositionY = dataViewRect.y - scrollPosition.getRowOffset() + ((scrollPosition.getRowPosition() & 1L) > 0L ? 0 : rowHeight);
            g.setColor(this.colorsProfile.getAlternateBackground());
            for (int row = 0; row <= rowsPerRect / 2 && dataPosition <= dataSize; dataPosition += (long)(bytesPerRow * 2), ++row) {
                g.fillRect(dataViewRect.x, stripePositionY, dataViewRect.width, rowHeight);
                stripePositionY += rowHeight * 2;
            }
        }
    }

    public void paintRows(Graphics g) {
        int bytesPerRow = this.structure.getBytesPerRow();
        int rowHeight = this.metrics.getRowHeight();
        int dataViewX = this.dimensions.getScrollPanelX();
        int dataViewY = this.dimensions.getScrollPanelY();
        int rowsPerRect = this.dimensions.getRowsPerRect();
        long dataSize = this.codeArea.getDataSize();
        CodeAreaScrollPosition scrollPosition = this.scrolling.getScrollPosition();
        long dataPosition = scrollPosition.getRowPosition() * (long)bytesPerRow;
        int characterWidth = this.metrics.getCharacterWidth();
        int rowPositionX = dataViewX - scrollPosition.getCharPosition() * characterWidth - scrollPosition.getCharOffset();
        int rowPositionY = dataViewY - scrollPosition.getRowOffset();
        g.setColor(this.colorsProfile.getTextColor());
        for (int row = 0; row <= rowsPerRect && dataPosition <= dataSize; ++row) {
            this.prepareRowData(dataPosition);
            this.paintRowBackground(g, dataPosition, rowPositionX, rowPositionY);
            this.paintRowText(g, dataPosition, rowPositionX, rowPositionY);
            rowPositionY += rowHeight;
            if (Long.MAX_VALUE - dataPosition < (long)bytesPerRow) {
                dataPosition = Long.MAX_VALUE;
                continue;
            }
            dataPosition += (long)bytesPerRow;
        }
    }

    private void prepareRowData(long dataPosition) {
        byte dataByte;
        int byteOnRow;
        int maxBytesPerChar = this.metrics.getMaxBytesPerChar();
        int bytesPerRow = this.structure.getBytesPerRow();
        long dataSize = this.codeArea.getDataSize();
        int previewCharPos = this.visibility.getPreviewCharPos();
        CodeType codeType = this.structure.getCodeType();
        CodeAreaViewMode viewMode = this.structure.getViewMode();
        int rowBytesLimit = bytesPerRow;
        int rowStart = 0;
        if (dataPosition < dataSize) {
            int rowDataSize = bytesPerRow + maxBytesPerChar - 1;
            if (dataSize - dataPosition < (long)rowDataSize) {
                rowDataSize = (int)(dataSize - dataPosition);
            }
            if (dataPosition < 0L) {
                rowStart = (int)(-dataPosition);
            }
            BinaryData data = this.codeArea.getContentData();
            data.copyToArray(dataPosition + (long)rowStart, this.rowDataCache.rowData, rowStart, rowDataSize - rowStart);
            if (dataSize - dataPosition < (long)rowBytesLimit) {
                rowBytesLimit = (int)(dataSize - dataPosition);
            }
        } else {
            rowBytesLimit = 0;
        }
        if (viewMode != CodeAreaViewMode.TEXT_PREVIEW) {
            int skipToCode = this.visibility.getSkipToCode();
            int skipRestFromCode = this.visibility.getSkipRestFromCode();
            int endCode = Math.min(skipRestFromCode, rowBytesLimit);
            for (byteOnRow = Math.max(skipToCode, rowStart); byteOnRow < endCode; ++byteOnRow) {
                dataByte = this.rowDataCache.rowData[byteOnRow];
                int byteRowPos = this.structure.computeFirstCodeCharacterPos(byteOnRow);
                if (byteRowPos > 0) {
                    this.rowDataCache.rowCharacters[byteRowPos - 1] = 32;
                }
                CodeAreaUtils.byteToCharsCode((byte)dataByte, (CodeType)codeType, (char[])this.rowDataCache.rowCharacters, (int)byteRowPos, (CodeCharactersCase)this.codeCharactersCase);
            }
            if (bytesPerRow > rowBytesLimit) {
                Arrays.fill(this.rowDataCache.rowCharacters, this.structure.computeFirstCodeCharacterPos(rowBytesLimit), this.rowDataCache.rowCharacters.length, ' ');
            }
        }
        if (previewCharPos > 0) {
            this.rowDataCache.rowCharacters[previewCharPos - 1] = 32;
        }
        if (viewMode != CodeAreaViewMode.CODE_MATRIX) {
            int skipToPreview = this.visibility.getSkipToPreview();
            int skipRestFromPreview = this.visibility.getSkipRestFromPreview();
            int endPreview = Math.min(skipRestFromPreview, rowBytesLimit);
            for (byteOnRow = skipToPreview; byteOnRow < endPreview; ++byteOnRow) {
                dataByte = this.rowDataCache.rowData[byteOnRow];
                if (maxBytesPerChar > 1) {
                    String displayString;
                    int charDataLength;
                    if (dataPosition + (long)maxBytesPerChar > dataSize) {
                        maxBytesPerChar = (int)(dataSize - dataPosition);
                    }
                    if (byteOnRow + (charDataLength = maxBytesPerChar) > this.rowDataCache.rowData.length) {
                        charDataLength = this.rowDataCache.rowData.length - byteOnRow;
                    }
                    if ((displayString = new String(this.rowDataCache.rowData, byteOnRow, charDataLength, this.charset)).isEmpty()) continue;
                    this.rowDataCache.rowCharacters[previewCharPos + byteOnRow] = displayString.charAt(0);
                    continue;
                }
                if (this.charMappingCharset == null || this.charMappingCharset != this.charset) {
                    this.buildCharMapping(this.charset);
                }
                this.rowDataCache.rowCharacters[previewCharPos + byteOnRow] = this.charMapping[dataByte & 0xFF];
            }
            if (bytesPerRow > rowBytesLimit) {
                Arrays.fill(this.rowDataCache.rowCharacters, previewCharPos + rowBytesLimit, previewCharPos + bytesPerRow, ' ');
            }
        }
    }

    public void paintRowBackground(Graphics g, long rowDataPosition, int rowPositionX, int rowPositionY) {
        int previewCharPos = this.visibility.getPreviewCharPos();
        CodeAreaViewMode viewMode = this.structure.getViewMode();
        int charactersPerRow = this.structure.getCharactersPerRow();
        int skipToChar = this.visibility.getSkipToChar();
        int skipRestFromChar = this.visibility.getSkipRestFromChar();
        int renderOffset = skipToChar;
        Color renderColor = null;
        for (int charOnRow = skipToChar; charOnRow < skipRestFromChar; ++charOnRow) {
            BasicCodeAreaSection section;
            int byteOnRow;
            if (charOnRow >= previewCharPos && viewMode != CodeAreaViewMode.CODE_MATRIX) {
                byteOnRow = charOnRow - previewCharPos;
                section = BasicCodeAreaSection.TEXT_PREVIEW;
            } else {
                byteOnRow = this.structure.computePositionByte(charOnRow);
                section = BasicCodeAreaSection.CODE_MATRIX;
            }
            boolean sequenceBreak = false;
            Color color = this.getPositionBackgroundColor(rowDataPosition, byteOnRow, charOnRow, (CodeAreaSection)section);
            if (!CodeAreaSwingUtils.areSameColors(color, renderColor)) {
                sequenceBreak = true;
            }
            if (!sequenceBreak) continue;
            if (renderOffset < charOnRow && renderColor != null) {
                this.renderBackgroundSequence(g, renderOffset, charOnRow, rowPositionX, rowPositionY);
            }
            if (!CodeAreaSwingUtils.areSameColors(color, renderColor)) {
                renderColor = color;
                if (color != null) {
                    g.setColor(color);
                }
            }
            renderOffset = charOnRow;
        }
        if (renderOffset < charactersPerRow && renderColor != null) {
            this.renderBackgroundSequence(g, renderOffset, charactersPerRow, rowPositionX, rowPositionY);
        }
    }

    @Nullable
    public Color getPositionBackgroundColor(long rowDataPosition, int byteOnRow, int charOnRow, CodeAreaSection section) {
        CodeAreaSelection selectionHandler = ((SelectionCapable)this.codeArea).getSelectionHandler();
        int codeLastCharPos = this.visibility.getCodeLastCharPos();
        boolean inSelection = selectionHandler.isInSelection(rowDataPosition + (long)byteOnRow);
        if (inSelection && section == BasicCodeAreaSection.CODE_MATRIX && charOnRow == codeLastCharPos) {
            inSelection = false;
        }
        if (inSelection) {
            return section == ((CaretCapable)this.codeArea).getActiveSection() ? this.colorsProfile.getSelectionBackground() : this.colorsProfile.getSelectionMirrorBackground();
        }
        return null;
    }

    @Override
    @Nonnull
    public PositionScrollVisibility computePositionScrollVisibility(CodeAreaCaretPosition caretPosition) {
        int bytesPerRow = this.structure.getBytesPerRow();
        int previewCharPos = this.visibility.getPreviewCharPos();
        int characterWidth = this.metrics.getCharacterWidth();
        int rowHeight = this.metrics.getRowHeight();
        int dataViewWidth = this.dimensions.getDataViewWidth();
        int dataViewHeight = this.dimensions.getDataViewHeight();
        int rowsPerPage = this.dimensions.getRowsPerPage();
        int charactersPerPage = this.dimensions.getCharactersPerPage();
        long shiftedPosition = caretPosition.getDataPosition();
        long rowPosition = shiftedPosition / (long)bytesPerRow;
        int byteOffset = (int)(shiftedPosition % (long)bytesPerRow);
        CodeAreaSection section = (CodeAreaSection)caretPosition.getSection().orElse(BasicCodeAreaSection.CODE_MATRIX);
        int charPosition = section == BasicCodeAreaSection.TEXT_PREVIEW ? previewCharPos + byteOffset : this.structure.computeFirstCodeCharacterPos(byteOffset) + caretPosition.getCodeOffset();
        return this.scrolling.computePositionScrollVisibility(rowPosition, charPosition, bytesPerRow, rowsPerPage, charactersPerPage, dataViewWidth, dataViewHeight, characterWidth, rowHeight);
    }

    @Override
    @Nonnull
    public Optional<CodeAreaScrollPosition> computeRevealScrollPosition(CodeAreaCaretPosition caretPosition) {
        int bytesPerRow = this.structure.getBytesPerRow();
        int previewCharPos = this.visibility.getPreviewCharPos();
        int characterWidth = this.metrics.getCharacterWidth();
        int rowHeight = this.metrics.getRowHeight();
        int dataViewWidth = this.dimensions.getDataViewWidth();
        int dataViewHeight = this.dimensions.getDataViewHeight();
        int rowsPerPage = this.dimensions.getRowsPerPage();
        int charactersPerPage = this.dimensions.getCharactersPerPage();
        long shiftedPosition = caretPosition.getDataPosition();
        long rowPosition = shiftedPosition / (long)bytesPerRow;
        int byteOffset = (int)(shiftedPosition % (long)bytesPerRow);
        CodeAreaSection section = (CodeAreaSection)caretPosition.getSection().orElse(BasicCodeAreaSection.CODE_MATRIX);
        int charPosition = section == BasicCodeAreaSection.TEXT_PREVIEW ? previewCharPos + byteOffset : this.structure.computeFirstCodeCharacterPos(byteOffset) + caretPosition.getCodeOffset();
        return this.scrolling.computeRevealScrollPosition(rowPosition, charPosition, bytesPerRow, rowsPerPage, charactersPerPage, dataViewWidth % characterWidth, dataViewHeight % rowHeight, characterWidth, rowHeight);
    }

    @Override
    @Nonnull
    public Optional<CodeAreaScrollPosition> computeCenterOnScrollPosition(CodeAreaCaretPosition caretPosition) {
        int bytesPerRow = this.structure.getBytesPerRow();
        int previewCharPos = this.visibility.getPreviewCharPos();
        int characterWidth = this.metrics.getCharacterWidth();
        int rowHeight = this.metrics.getRowHeight();
        int dataViewWidth = this.dimensions.getDataViewWidth();
        int dataViewHeight = this.dimensions.getDataViewHeight();
        int rowsPerRect = this.dimensions.getRowsPerRect();
        int charactersPerRect = this.dimensions.getCharactersPerRect();
        long shiftedPosition = caretPosition.getDataPosition();
        long rowPosition = shiftedPosition / (long)bytesPerRow;
        int byteOffset = (int)(shiftedPosition % (long)bytesPerRow);
        CodeAreaSection section = (CodeAreaSection)caretPosition.getSection().orElse(BasicCodeAreaSection.CODE_MATRIX);
        int charPosition = section == BasicCodeAreaSection.TEXT_PREVIEW ? previewCharPos + byteOffset : this.structure.computeFirstCodeCharacterPos(byteOffset) + caretPosition.getCodeOffset();
        return this.scrolling.computeCenterOnScrollPosition(rowPosition, charPosition, bytesPerRow, rowsPerRect, charactersPerRect, dataViewWidth, dataViewHeight, characterWidth, rowHeight);
    }

    public void paintRowText(Graphics g, long rowDataPosition, int rowPositionX, int rowPositionY) {
        int previewCharPos = this.visibility.getPreviewCharPos();
        int charactersPerRow = this.structure.getCharactersPerRow();
        int rowHeight = this.metrics.getRowHeight();
        int characterWidth = this.metrics.getCharacterWidth();
        int subFontSpace = this.metrics.getSubFontSpace();
        g.setFont(this.font);
        int positionY = rowPositionY + rowHeight - subFontSpace;
        Color lastColor = null;
        Color renderColor = null;
        int skipToChar = this.visibility.getSkipToChar();
        int skipRestFromChar = this.visibility.getSkipRestFromChar();
        int renderOffset = skipToChar;
        for (int charOnRow = skipToChar; charOnRow < skipRestFromChar; ++charOnRow) {
            BasicCodeAreaSection section;
            int byteOnRow;
            if (charOnRow >= previewCharPos) {
                byteOnRow = charOnRow - previewCharPos;
                section = BasicCodeAreaSection.TEXT_PREVIEW;
            } else {
                byteOnRow = this.structure.computePositionByte(charOnRow);
                section = BasicCodeAreaSection.CODE_MATRIX;
            }
            char currentChar = this.rowDataCache.rowCharacters[charOnRow];
            if (currentChar == ' ' && renderOffset == charOnRow) {
                ++renderOffset;
                continue;
            }
            Color color = this.getPositionTextColor(rowDataPosition, byteOnRow, charOnRow, (CodeAreaSection)section);
            if (color == null) {
                color = this.colorsProfile.getTextColor();
            }
            boolean sequenceBreak = false;
            if (!CodeAreaSwingUtils.areSameColors(color, renderColor)) {
                if (renderColor == null) {
                    renderColor = color;
                }
                sequenceBreak = true;
            }
            if (!sequenceBreak) continue;
            if (!CodeAreaSwingUtils.areSameColors(lastColor, renderColor)) {
                g.setColor(renderColor);
                lastColor = renderColor;
            }
            if (charOnRow > renderOffset) {
                this.drawCenteredChars(g, this.rowDataCache.rowCharacters, renderOffset, charOnRow - renderOffset, characterWidth, rowPositionX + renderOffset * characterWidth, positionY);
            }
            if (!CodeAreaSwingUtils.areSameColors(lastColor, renderColor = color)) {
                g.setColor(renderColor);
                lastColor = renderColor;
            }
            renderOffset = charOnRow;
        }
        if (renderOffset < charactersPerRow) {
            if (!CodeAreaSwingUtils.areSameColors(lastColor, renderColor)) {
                g.setColor(renderColor);
            }
            this.drawCenteredChars(g, this.rowDataCache.rowCharacters, renderOffset, charactersPerRow - renderOffset, characterWidth, rowPositionX + renderOffset * characterWidth, positionY);
        }
    }

    @Nullable
    public Color getPositionTextColor(long rowDataPosition, int byteOnRow, int charOnRow, CodeAreaSection section) {
        CodeAreaSelection selectionHandler = ((SelectionCapable)this.codeArea).getSelectionHandler();
        boolean inSelection = selectionHandler.isInSelection(rowDataPosition + (long)byteOnRow);
        if (inSelection) {
            return section == ((CaretCapable)this.codeArea).getActiveSection() ? this.colorsProfile.getSelectionColor() : this.colorsProfile.getSelectionMirrorColor();
        }
        return null;
    }

    @Override
    public void paintCursor(Graphics g) {
        boolean cursorVisible;
        DefaultCodeAreaCaret caret;
        Rectangle cursorRect;
        int cursorDataLength;
        int cursorCharsLength;
        if (!this.codeArea.hasFocus()) {
            return;
        }
        if (this.caretChanged) {
            this.updateCaret();
        }
        int maxBytesPerChar = this.metrics.getMaxBytesPerChar();
        Rectangle mainAreaRect = this.dimensions.getMainAreaRectangle();
        CodeType codeType = this.structure.getCodeType();
        CodeAreaViewMode viewMode = this.structure.getViewMode();
        if (this.cursorDataCache == null) {
            this.cursorDataCache = new CursorDataCache();
        }
        if (this.cursorDataCache.cursorCharsLength != (cursorCharsLength = codeType.getMaxDigitsForByte())) {
            this.cursorDataCache.cursorCharsLength = cursorCharsLength;
            this.cursorDataCache.cursorChars = new char[cursorCharsLength];
        }
        if (this.cursorDataCache.cursorDataLength != (cursorDataLength = maxBytesPerChar)) {
            this.cursorDataCache.cursorDataLength = cursorDataLength;
            this.cursorDataCache.cursorData = new byte[cursorDataLength];
        }
        if ((cursorRect = this.getCursorPositionRect((caret = (DefaultCodeAreaCaret)((CaretCapable)this.codeArea).getCaret()).getDataPosition(), caret.getCodeOffset(), caret.getSection())).isEmpty()) {
            return;
        }
        Rectangle scrolledCursorRect = new Rectangle(cursorRect.x, cursorRect.y, cursorRect.width, cursorRect.height);
        Rectangle clipBounds = g.getClipBounds();
        Rectangle intersection = scrolledCursorRect.intersection(mainAreaRect);
        boolean bl = cursorVisible = caret.isCursorVisible() && !intersection.isEmpty();
        if (cursorVisible) {
            g.setClip(intersection);
            DefaultCodeAreaCaret.CursorRenderingMode renderingMode = caret.getRenderingMode();
            g.setColor(this.colorsProfile.getCursorColor());
            this.paintCursorRect(g, intersection.x, intersection.y, intersection.width, intersection.height, renderingMode, caret);
        }
        if (viewMode == CodeAreaViewMode.DUAL && this.showMirrorCursor) {
            this.updateMirrorCursorRect(caret.getDataPosition(), caret.getSection());
            Rectangle mirrorCursorRect = this.cursorDataCache.mirrorCursorRect;
            if (!mirrorCursorRect.isEmpty()) {
                boolean mirrorCursorVisible;
                intersection = mainAreaRect.intersection(mirrorCursorRect);
                boolean bl2 = mirrorCursorVisible = !intersection.isEmpty();
                if (mirrorCursorVisible) {
                    g.setClip(intersection);
                    g.setColor(this.colorsProfile.getCursorColor());
                    Graphics2D g2d = (Graphics2D)g.create();
                    g2d.setStroke(this.cursorDataCache.dashedStroke);
                    g2d.drawRect(mirrorCursorRect.x, mirrorCursorRect.y, mirrorCursorRect.width - 1, mirrorCursorRect.height - 1);
                    g2d.dispose();
                }
            }
        }
        g.setClip(clipBounds);
    }

    private void paintCursorRect(Graphics g, int cursorX, int cursorY, int width, int height, DefaultCodeAreaCaret.CursorRenderingMode renderingMode, DefaultCodeAreaCaret caret) {
        switch (renderingMode) {
            case PAINT: {
                g.fillRect(cursorX, cursorY, width, height);
                break;
            }
            case XOR: {
                g.setXORMode(this.colorsProfile.getTextBackground());
                g.fillRect(cursorX, cursorY, width, height);
                g.setPaintMode();
                break;
            }
            case NEGATIVE: {
                int characterWidth = this.metrics.getCharacterWidth();
                int rowHeight = this.metrics.getRowHeight();
                int maxBytesPerChar = this.metrics.getMaxBytesPerChar();
                int subFontSpace = this.metrics.getSubFontSpace();
                int dataViewX = this.dimensions.getScrollPanelX();
                int dataViewY = this.dimensions.getScrollPanelY();
                int previewRelativeX = this.visibility.getPreviewRelativeX();
                CodeAreaViewMode viewMode = this.structure.getViewMode();
                CodeAreaScrollPosition scrollPosition = this.scrolling.getScrollPosition();
                long dataSize = this.codeArea.getDataSize();
                CodeType codeType = this.structure.getCodeType();
                g.fillRect(cursorX, cursorY, width, height);
                g.setColor(this.colorsProfile.getCursorNegativeColor());
                BinaryData contentData = this.codeArea.getContentData();
                int row = (cursorY + scrollPosition.getRowOffset() - dataViewY) / rowHeight;
                int scrolledX = cursorX + scrollPosition.getCharPosition() * characterWidth + scrollPosition.getCharOffset();
                int posY = dataViewY + (row + 1) * rowHeight - subFontSpace - scrollPosition.getRowOffset();
                long dataPosition = caret.getDataPosition();
                if (viewMode != CodeAreaViewMode.CODE_MATRIX && caret.getSection() == BasicCodeAreaSection.TEXT_PREVIEW) {
                    int charPos = (scrolledX - previewRelativeX) / characterWidth;
                    if (dataPosition >= dataSize) break;
                    if (maxBytesPerChar > 1) {
                        int charDataLength = maxBytesPerChar;
                        if (dataPosition + (long)maxBytesPerChar > dataSize) {
                            charDataLength = (int)(dataSize - dataPosition);
                        }
                        if (contentData == null) {
                            this.cursorDataCache.cursorChars[0] = 32;
                        } else {
                            contentData.copyToArray(dataPosition, this.cursorDataCache.cursorData, 0, charDataLength);
                            String displayString = new String(this.cursorDataCache.cursorData, 0, charDataLength, this.charset);
                            if (!displayString.isEmpty()) {
                                this.cursorDataCache.cursorChars[0] = displayString.charAt(0);
                            }
                        }
                    } else {
                        if (this.charMappingCharset == null || this.charMappingCharset != this.charset) {
                            this.buildCharMapping(this.charset);
                        }
                        this.cursorDataCache.cursorChars[0] = contentData == null ? 32 : this.charMapping[contentData.getByte(dataPosition) & 0xFF];
                    }
                    int posX = previewRelativeX + charPos * characterWidth - scrollPosition.getCharPosition() * characterWidth - scrollPosition.getCharOffset();
                    this.drawCenteredChars(g, this.cursorDataCache.cursorChars, 0, 1, characterWidth, posX, posY);
                    break;
                }
                int charPos = (scrolledX - dataViewX) / characterWidth;
                int byteOffset = this.structure.computePositionByte(charPos);
                int codeCharPos = this.structure.computeFirstCodeCharacterPos(byteOffset);
                if (contentData != null && dataPosition < dataSize) {
                    byte dataByte = contentData.getByte(dataPosition);
                    CodeAreaUtils.byteToCharsCode((byte)dataByte, (CodeType)codeType, (char[])this.cursorDataCache.cursorChars, (int)0, (CodeCharactersCase)this.codeCharactersCase);
                } else {
                    Arrays.fill(this.cursorDataCache.cursorChars, ' ');
                }
                int posX = dataViewX + codeCharPos * characterWidth - scrollPosition.getCharPosition() * characterWidth - scrollPosition.getCharOffset();
                int charsOffset = charPos - codeCharPos;
                this.drawCenteredChars(g, this.cursorDataCache.cursorChars, charsOffset, 1, characterWidth, posX + charsOffset * characterWidth, posY);
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException((Enum)renderingMode);
            }
        }
    }

    @Override
    @Nonnull
    public CodeAreaCaretPosition mousePositionToClosestCaretPosition(int positionX, int positionY, CaretOverlapMode overflowMode) {
        long dataPosition;
        int byteOnRow;
        long cursorRowY;
        int cursorCharX;
        DefaultCodeAreaCaretPosition caret = new DefaultCodeAreaCaretPosition();
        CodeAreaScrollPosition scrollPosition = this.scrolling.getScrollPosition();
        int characterWidth = this.metrics.getCharacterWidth();
        int rowHeight = this.metrics.getRowHeight();
        int rowPositionAreaWidth = this.dimensions.getRowPositionAreaWidth();
        int headerAreaHeight = this.dimensions.getHeaderAreaHeight();
        int diffX = 0;
        if (positionX < rowPositionAreaWidth) {
            if (overflowMode == CaretOverlapMode.PARTIAL_OVERLAP) {
                diffX = 1;
            }
            positionX = rowPositionAreaWidth;
        }
        if ((cursorCharX = (positionX - rowPositionAreaWidth + scrollPosition.getCharOffset()) / characterWidth + scrollPosition.getCharPosition() - diffX) < 0) {
            cursorCharX = 0;
        }
        int diffY = 0;
        if (positionY < headerAreaHeight) {
            if (overflowMode == CaretOverlapMode.PARTIAL_OVERLAP) {
                diffY = 1;
            }
            positionY = headerAreaHeight;
        }
        if ((cursorRowY = (long)((positionY - headerAreaHeight + scrollPosition.getRowOffset()) / rowHeight) + scrollPosition.getRowPosition() - (long)diffY) < 0L) {
            cursorRowY = 0L;
        }
        CodeAreaViewMode viewMode = this.structure.getViewMode();
        int previewCharPos = this.visibility.getPreviewCharPos();
        int bytesPerRow = this.structure.getBytesPerRow();
        CodeType codeType = this.structure.getCodeType();
        long dataSize = this.codeArea.getDataSize();
        int codeOffset = 0;
        if (viewMode == CodeAreaViewMode.DUAL && cursorCharX < previewCharPos || viewMode == CodeAreaViewMode.CODE_MATRIX) {
            caret.setSection((CodeAreaSection)BasicCodeAreaSection.CODE_MATRIX);
            byteOnRow = this.structure.computePositionByte(cursorCharX);
            if (byteOnRow >= bytesPerRow) {
                codeOffset = 0;
            } else {
                codeOffset = cursorCharX - this.structure.computeFirstCodeCharacterPos(byteOnRow);
                if (codeOffset >= codeType.getMaxDigitsForByte()) {
                    codeOffset = codeType.getMaxDigitsForByte() - 1;
                }
            }
        } else {
            caret.setSection((CodeAreaSection)BasicCodeAreaSection.TEXT_PREVIEW);
            byteOnRow = cursorCharX;
            if (viewMode == CodeAreaViewMode.DUAL) {
                byteOnRow -= previewCharPos;
            }
        }
        if (byteOnRow >= bytesPerRow) {
            byteOnRow = bytesPerRow - 1;
        }
        if ((dataPosition = (long)byteOnRow + cursorRowY * (long)bytesPerRow) < 0L) {
            dataPosition = 0L;
            codeOffset = 0;
        }
        if (dataPosition >= dataSize) {
            dataPosition = dataSize;
            codeOffset = 0;
        }
        caret.setDataPosition(dataPosition);
        caret.setCodeOffset(codeOffset);
        return caret;
    }

    @Override
    @Nonnull
    public CodeAreaCaretPosition computeMovePosition(CodeAreaCaretPosition position, MovementDirection direction) {
        return this.structure.computeMovePosition(position, direction, this.dimensions.getRowsPerPage());
    }

    @Override
    @Nonnull
    public CodeAreaScrollPosition computeScrolling(CodeAreaScrollPosition startPosition, ScrollingDirection direction) {
        int rowsPerPage = this.dimensions.getRowsPerPage();
        long rowsPerDocument = this.structure.getRowsPerDocument();
        return this.scrolling.computeScrolling(startPosition, direction, rowsPerPage, rowsPerDocument);
    }

    @Nullable
    public Point getPositionPoint(long dataPosition, int codeOffset, CodeAreaSection section) {
        int bytesPerRow = this.structure.getBytesPerRow();
        int rowsPerRect = this.dimensions.getRowsPerRect();
        int characterWidth = this.metrics.getCharacterWidth();
        int rowHeight = this.metrics.getRowHeight();
        CodeAreaScrollPosition scrollPosition = this.scrolling.getScrollPosition();
        long row = dataPosition / (long)bytesPerRow - scrollPosition.getRowPosition();
        if (row < -1L || row > (long)rowsPerRect) {
            return null;
        }
        int byteOffset = (int)(dataPosition % (long)bytesPerRow);
        Rectangle dataViewRect = this.dimensions.getDataViewRectangle();
        int caretY = (int)((long)dataViewRect.y + row * (long)rowHeight) - scrollPosition.getRowOffset();
        int caretX = section == BasicCodeAreaSection.TEXT_PREVIEW ? dataViewRect.x + this.visibility.getPreviewRelativeX() + characterWidth * byteOffset : dataViewRect.x + characterWidth * (this.structure.computeFirstCodeCharacterPos(byteOffset) + codeOffset);
        return new Point(caretX -= scrollPosition.getCharPosition() * characterWidth + scrollPosition.getCharOffset(), caretY);
    }

    private void updateMirrorCursorRect(long dataPosition, CodeAreaSection section) {
        CodeType codeType = this.structure.getCodeType();
        Point mirrorCursorPoint = this.getPositionPoint(dataPosition, 0, (CodeAreaSection)(section == BasicCodeAreaSection.CODE_MATRIX ? BasicCodeAreaSection.TEXT_PREVIEW : BasicCodeAreaSection.CODE_MATRIX));
        if (mirrorCursorPoint == null) {
            this.cursorDataCache.mirrorCursorRect.setSize(0, 0);
        } else {
            this.cursorDataCache.mirrorCursorRect.setBounds(mirrorCursorPoint.x, mirrorCursorPoint.y, this.metrics.getCharacterWidth() * (section == BasicCodeAreaSection.TEXT_PREVIEW ? codeType.getMaxDigitsForByte() : 1), this.metrics.getRowHeight());
        }
    }

    @Override
    public int getMouseCursorShape(int positionX, int positionY) {
        int dataViewX = this.dimensions.getScrollPanelX();
        int dataViewY = this.dimensions.getScrollPanelY();
        int scrollPanelWidth = this.dimensions.getScrollPanelWidth();
        int scrollPanelHeight = this.dimensions.getScrollPanelHeight();
        if (positionX >= dataViewX && positionX < dataViewX + scrollPanelWidth && positionY >= dataViewY && positionY < dataViewY + scrollPanelHeight) {
            return 2;
        }
        return 0;
    }

    @Override
    @Nonnull
    public BasicCodeAreaZone getPositionZone(int positionX, int positionY) {
        return this.dimensions.getPositionZone(positionX, positionY);
    }

    @Override
    @Nonnull
    public BasicCodeAreaColorsProfile getBasicColors() {
        return this.colorsProfile;
    }

    @Override
    public void setBasicColors(BasicCodeAreaColorsProfile colorsProfile) {
        this.colorsProfile = colorsProfile;
    }

    protected void drawCenteredChars(Graphics g, char[] drawnChars, int charOffset, int length, int cellWidth, int positionX, int positionY) {
        int pos;
        int group = 0;
        for (pos = 0; pos < length; ++pos) {
            int charsWidth;
            char drawnChar = drawnChars[charOffset + pos];
            int charWidth = this.metrics.getCharWidth(drawnChar);
            boolean groupable = this.metrics.hasUniformLineMetrics() ? charWidth == cellWidth : (charsWidth = this.metrics.getCharsWidth(drawnChars, charOffset + pos - group, group + 1)) == cellWidth * (group + 1);
            switch (Character.getDirectionality(drawnChar)) {
                case -1: 
                case 1: 
                case 2: 
                case 9: 
                case 13: 
                case 16: 
                case 17: 
                case 18: {
                    groupable = false;
                }
            }
            if (groupable) {
                ++group;
                continue;
            }
            if (group > 0) {
                this.drawShiftedChars(g, drawnChars, charOffset + pos - group, group, positionX + (pos - group) * cellWidth, positionY);
                group = 0;
            }
            this.drawShiftedChars(g, drawnChars, charOffset + pos, 1, positionX + pos * cellWidth + (cellWidth - charWidth) / 2, positionY);
        }
        if (group > 0) {
            this.drawShiftedChars(g, drawnChars, charOffset + pos - group, group, positionX + (pos - group) * cellWidth, positionY);
        }
    }

    protected void drawShiftedChars(Graphics g, char[] drawnChars, int charOffset, int length, int positionX, int positionY) {
        g.drawChars(drawnChars, charOffset, length, positionX, positionY);
    }

    private void buildCharMapping(Charset charset) {
        for (int i = 0; i < 256; ++i) {
            this.charMapping[i] = new String(new byte[]{(byte)i}, charset).charAt(0);
        }
        this.charMappingCharset = charset;
    }

    private int getRowPositionLength() {
        if (this.minRowPositionLength > 0 && this.minRowPositionLength == this.maxRowPositionLength) {
            return this.minRowPositionLength;
        }
        long dataSize = this.codeArea.getDataSize();
        if (dataSize == 0L) {
            return 1;
        }
        double natLog = Math.log(dataSize == Long.MAX_VALUE ? (double)dataSize : (double)(dataSize + 1L));
        int positionLength = (int)Math.ceil(natLog / PositionCodeType.HEXADECIMAL.getBaseLog());
        if (this.minRowPositionLength > 0 && positionLength < this.minRowPositionLength) {
            positionLength = this.minRowPositionLength;
        }
        if (this.maxRowPositionLength > 0 && positionLength > this.maxRowPositionLength) {
            positionLength = this.maxRowPositionLength;
        }
        return positionLength == 0 ? 1 : positionLength;
    }

    @Nonnull
    public Rectangle getCursorPositionRect(long dataPosition, int codeOffset, CodeAreaSection section) {
        Rectangle rect = new Rectangle();
        this.updateRectToCursorPosition(rect, dataPosition, codeOffset, section);
        return rect;
    }

    protected void updateRectToCursorPosition(Rectangle rect, long dataPosition, int codeOffset, CodeAreaSection section) {
        int characterWidth = this.metrics.getCharacterWidth();
        int rowHeight = this.metrics.getRowHeight();
        Point cursorPoint = this.getPositionPoint(dataPosition, codeOffset, section);
        if (cursorPoint == null) {
            rect.setBounds(0, 0, 0, 0);
        } else {
            DefaultCodeAreaCaret.CursorShape cursorShape = this.editOperation == EditOperation.INSERT ? DefaultCodeAreaCaret.CursorShape.INSERT : DefaultCodeAreaCaret.CursorShape.OVERWRITE;
            int cursorThickness = DefaultCodeAreaCaret.getCursorThickness(cursorShape, characterWidth, rowHeight);
            rect.setBounds(cursorPoint.x, cursorPoint.y, cursorThickness, rowHeight);
        }
    }

    private void renderBackgroundSequence(Graphics g, int startOffset, int endOffset, int rowPositionX, int positionY) {
        int characterWidth = this.metrics.getCharacterWidth();
        int rowHeight = this.metrics.getRowHeight();
        g.fillRect(rowPositionX + startOffset * characterWidth, positionY, (endOffset - startOffset) * characterWidth, rowHeight);
    }

    @Override
    public void updateScrollBars() {
        int verticalScrollBarPolicy = CodeAreaSwingUtils.getVerticalScrollBarPolicy(this.scrolling.getVerticalScrollBarVisibility());
        if (this.scrollPanel.getVerticalScrollBarPolicy() != verticalScrollBarPolicy) {
            this.scrollPanel.setVerticalScrollBarPolicy(verticalScrollBarPolicy);
        }
        int horizontalScrollBarPolicy = CodeAreaSwingUtils.getHorizontalScrollBarPolicy(this.scrolling.getHorizontalScrollBarVisibility());
        if (this.scrollPanel.getHorizontalScrollBarPolicy() != horizontalScrollBarPolicy) {
            this.scrollPanel.setHorizontalScrollBarPolicy(horizontalScrollBarPolicy);
        }
        int characterWidth = this.metrics.getCharacterWidth();
        int rowHeight = this.metrics.getRowHeight();
        long rowsPerDocument = this.structure.getRowsPerDocument();
        this.recomputeScrollState();
        boolean revalidate = false;
        Rectangle scrollPanelRectangle = this.dimensions.getScrollPanelRectangle();
        Rectangle oldRect = this.scrollPanel.getBounds();
        if (!oldRect.equals(scrollPanelRectangle)) {
            this.scrollPanel.setBounds(scrollPanelRectangle);
            revalidate = true;
        }
        JViewport viewport = this.scrollPanel.getViewport();
        if (rowHeight > 0 && characterWidth > 0) {
            this.viewDimension = this.scrolling.computeViewDimension(viewport.getWidth(), viewport.getHeight(), this.layout, this.structure, characterWidth, rowHeight);
            if (this.dataView.getWidth() != this.viewDimension.getWidth() || this.dataView.getHeight() != this.viewDimension.getHeight()) {
                Dimension dataViewSize = new Dimension(this.viewDimension.getWidth(), this.viewDimension.getHeight());
                this.dataView.setPreferredSize(dataViewSize);
                this.dataView.setSize(dataViewSize);
                this.recomputeDimensions();
                scrollPanelRectangle = this.dimensions.getScrollPanelRectangle();
                if (!oldRect.equals(scrollPanelRectangle)) {
                    this.scrollPanel.setBounds(scrollPanelRectangle);
                }
                revalidate = true;
            }
            int verticalScrollValue = this.scrolling.getVerticalScrollValue(rowHeight, rowsPerDocument);
            int horizontalScrollValue = this.scrolling.getHorizontalScrollValue(characterWidth);
            this.scrollPanel.updateScrollBars(verticalScrollValue, horizontalScrollValue);
        }
        if (revalidate) {
            this.horizontalExtentChanged();
            this.verticalExtentChanged();
            this.codeArea.revalidate();
        }
    }

    @Override
    public void scrollPositionModified() {
        this.scrolling.clearLastVerticalScrollingValue();
        this.recomputeScrollState();
    }

    @Override
    public void scrollPositionChanged() {
        this.recomputeScrollState();
        this.updateScrollBars();
    }

    private void horizontalExtentChanged() {
        this.scrollPanel.horizontalExtentChanged();
    }

    private void verticalExtentChanged() {
        this.scrollPanel.verticalExtentChanged();
    }

    private void dataChanged() {
        this.validateCaret();
        this.validateSelection();
        this.recomputeLayout();
    }

    protected int getCharactersPerRow() {
        return this.structure.getCharactersPerRow();
    }

    public int getBytesPerRow() {
        return this.structure.getBytesPerRow();
    }

    public int getRowHeight() {
        return this.metrics.getRowHeight();
    }

    private int getHorizontalScrollBarSize() {
        JScrollBar horizontalScrollBar = this.scrollPanel.getHorizontalScrollBar();
        return horizontalScrollBar.isVisible() ? horizontalScrollBar.getHeight() : 0;
    }

    private int getVerticalScrollBarSize() {
        JScrollBar verticalScrollBar = this.scrollPanel.getVerticalScrollBar();
        return verticalScrollBar.isVisible() ? verticalScrollBar.getWidth() : 0;
    }

    private static class CursorDataCache {
        Rectangle caretRect = new Rectangle();
        Rectangle mirrorCursorRect = new Rectangle();
        final Stroke dashedStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{2.0f}, 0.0f);
        int cursorCharsLength;
        char[] cursorChars;
        int cursorDataLength;
        byte[] cursorData;

        private CursorDataCache() {
        }
    }

    private static class RowDataCache {
        char[] headerChars;
        byte[] rowData;
        char[] rowPositionCode;
        char[] rowCharacters;

        private RowDataCache() {
        }
    }
}

