/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.operation.undo.api.UndoFileHandler;
import org.exbin.xbup.operation.Command;
import org.exbin.xbup.operation.undo.XBUndoHandler;
import org.exbin.xbup.operation.undo.XBUndoUpdateListener;

@ParametersAreNonnullByDefault
public class MultiEditorUndoHandler
implements XBUndoHandler {
    private List<XBUndoUpdateListener> updateListeners = new ArrayList<XBUndoUpdateListener>();
    @Nullable
    private UndoFileHandler fileHandler;

    public void setActiveFile(@Nullable FileHandler fileHandler) {
        if (this.fileHandler != fileHandler) {
            this.fileHandler = fileHandler instanceof UndoFileHandler ? (UndoFileHandler)fileHandler : null;
            this.notifyUndoUpdate();
        }
    }

    public void notifyUndoUpdate() {
        for (XBUndoUpdateListener listener : this.updateListeners) {
            listener.undoCommandPositionChanged();
        }
    }

    public void notifyUndoCommandAdded(Command command) {
        for (XBUndoUpdateListener listener : this.updateListeners) {
            listener.undoCommandAdded(command);
        }
    }

    public boolean canRedo() {
        if (this.fileHandler != null) {
            return this.fileHandler.getUndoHandler().canRedo();
        }
        return false;
    }

    public boolean canUndo() {
        if (this.fileHandler != null) {
            return this.fileHandler.getUndoHandler().canUndo();
        }
        return false;
    }

    public void clear() {
        if (this.fileHandler != null) {
            this.fileHandler.getUndoHandler().clear();
        }
    }

    public void doSync() throws Exception {
        if (this.fileHandler != null) {
            this.fileHandler.getUndoHandler().doSync();
        }
    }

    public void execute(Command command) throws Exception {
        if (this.fileHandler != null) {
            this.fileHandler.getUndoHandler().execute(command);
        }
    }

    public void addCommand(Command cmnd) {
        if (this.fileHandler != null) {
            this.fileHandler.getUndoHandler().addCommand(cmnd);
        }
    }

    @Nullable
    public List<Command> getCommandList() {
        if (this.fileHandler != null) {
            return this.fileHandler.getUndoHandler().getCommandList();
        }
        return new ArrayList<Command>();
    }

    public long getCommandPosition() {
        if (this.fileHandler != null) {
            return this.fileHandler.getUndoHandler().getCommandPosition();
        }
        return 0L;
    }

    public long getMaximumUndo() {
        if (this.fileHandler != null) {
            return this.fileHandler.getUndoHandler().getMaximumUndo();
        }
        return 0L;
    }

    public long getSyncPoint() {
        if (this.fileHandler != null) {
            return this.fileHandler.getUndoHandler().getSyncPoint();
        }
        return 0L;
    }

    public long getUndoMaximumSize() {
        if (this.fileHandler != null) {
            return this.fileHandler.getUndoHandler().getUndoMaximumSize();
        }
        return 0L;
    }

    public long getUsedSize() {
        if (this.fileHandler != null) {
            return this.fileHandler.getUndoHandler().getUsedSize();
        }
        return 0L;
    }

    public void performRedo() throws Exception {
        if (this.fileHandler != null) {
            this.fileHandler.getUndoHandler().performRedo();
        }
    }

    public void performRedo(int count) throws Exception {
        if (this.fileHandler != null) {
            this.fileHandler.getUndoHandler().performRedo(count);
        }
    }

    public void performUndo() throws Exception {
        if (this.fileHandler != null) {
            this.fileHandler.getUndoHandler().performUndo();
        }
    }

    public void performUndo(int count) throws Exception {
        if (this.fileHandler != null) {
            this.fileHandler.getUndoHandler().performUndo();
        }
    }

    public void setCommandPosition(long targetPosition) throws Exception {
        if (this.fileHandler != null) {
            this.fileHandler.getUndoHandler().setCommandPosition(targetPosition);
        }
    }

    public void setSyncPoint(long syncPoint) {
        if (this.fileHandler != null) {
            this.fileHandler.getUndoHandler().setSyncPoint(syncPoint);
        }
    }

    public void setSyncPoint() {
        if (this.fileHandler != null) {
            this.fileHandler.getUndoHandler().setSyncPoint();
        }
    }

    public void addUndoUpdateListener(XBUndoUpdateListener listener) {
        this.updateListeners.add(listener);
    }

    public void removeUndoUpdateListener(XBUndoUpdateListener listener) {
        this.updateListeners.remove(listener);
    }
}

