/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.viewer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.ByteArrayEditableData;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.xbup.def.BinaryDataEditor;
import org.exbin.framework.editor.xbup.def.gui.BlockPanel;
import org.exbin.framework.editor.xbup.gui.BlockComponentEditorPanel;
import org.exbin.framework.editor.xbup.gui.BlockComponentViewerPanel;
import org.exbin.framework.editor.xbup.gui.BlockDefinitionPanel;
import org.exbin.framework.editor.xbup.gui.BlockRowEditorPanel;
import org.exbin.framework.editor.xbup.gui.SimpleMessagePanel;
import org.exbin.framework.editor.xbup.viewer.BlockViewer;
import org.exbin.framework.editor.xbup.viewer.gui.DocumentViewerPanel;
import org.exbin.xbup.core.block.XBBlockDataMode;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.block.declaration.XBBlockDecl;
import org.exbin.xbup.core.block.declaration.catalog.XBCBlockDecl;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.XBPlugUiType;
import org.exbin.xbup.core.catalog.base.XBCBlockRev;
import org.exbin.xbup.core.catalog.base.XBCXBlockUi;
import org.exbin.xbup.core.catalog.base.XBCXPlugUi;
import org.exbin.xbup.core.catalog.base.service.XBCXUiService;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.basic.XBTProvider;
import org.exbin.xbup.core.parser.token.pull.XBTPullProvider;
import org.exbin.xbup.core.parser.token.pull.convert.XBTProviderToPullProvider;
import org.exbin.xbup.core.serial.XBPSerialReader;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.util.StreamUtils;
import org.exbin.xbup.parser_tree.XBTTreeNode;
import org.exbin.xbup.parser_tree.XBTTreeWriter;
import org.exbin.xbup.plugin.XBCatalogPlugin;
import org.exbin.xbup.plugin.XBPanelEditor;
import org.exbin.xbup.plugin.XBPanelEditorCatalogPlugin;
import org.exbin.xbup.plugin.XBPanelViewer;
import org.exbin.xbup.plugin.XBPanelViewerCatalogPlugin;
import org.exbin.xbup.plugin.XBPluginRepository;

@ParametersAreNonnullByDefault
public class DocumentViewer
implements BlockViewer {
    private XBPluginRepository pluginRepository;
    private DocumentViewerPanel viewerPanel = new DocumentViewerPanel();
    private final BlockDefinitionPanel definitionPanel = new BlockDefinitionPanel();
    private final BlockPanel blockPanel = new BlockPanel();
    private final BinaryDataEditor binaryDataEditor = new BinaryDataEditor();
    private final BlockRowEditorPanel rowEditorPanel = new BlockRowEditorPanel();
    private XBTBlock selectedItem = null;
    private XBACatalog catalog;

    public DocumentViewer() {
        SimpleMessagePanel messagePanel = new SimpleMessagePanel();
        this.viewerPanel.setBorderComponent(messagePanel);
    }

    @Override
    @Nonnull
    public String getName() {
        return "Viewer";
    }

    @Override
    @Nonnull
    public Optional<ImageIcon> getIcon() {
        return Optional.of(new ImageIcon(this.getClass().getResource("/org/exbin/framework/editor/xbup/resources/icons/open_icon_library-standard/icons/png/16x16/actions/zoom-4.png")));
    }

    @Override
    @Nonnull
    public JComponent getComponent() {
        return this.viewerPanel;
    }

    @Override
    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
        this.definitionPanel.setCatalog(catalog);
        this.blockPanel.setCatalog(catalog);
    }

    @Override
    public void setPluginRepository(XBPluginRepository pluginRepository) {
        this.pluginRepository = pluginRepository;
        this.definitionPanel.setPluginRepository(pluginRepository);
        this.blockPanel.setPluginRepository(pluginRepository);
    }

    @Override
    public void setApplication(XBApplication application) {
        this.definitionPanel.setApplication(application);
        this.blockPanel.setApplication(application);
        this.binaryDataEditor.setApplication(application);
    }

    @Override
    public void setBlock(@Nullable XBTBlock block) {
        this.viewerPanel.removeAllViews();
        if (block != null) {
            XBBlockDecl decl;
            XBCXUiService uiService = (XBCXUiService)this.catalog.getCatalogService(XBCXUiService.class);
            XBBlockDecl xBBlockDecl = decl = block instanceof XBTTreeNode ? ((XBTTreeNode)block).getBlockDecl() : null;
            if (decl instanceof XBCBlockDecl) {
                XBCXBlockUi rowEditorUi;
                XBCXBlockUi componentEditorUi;
                XBCXBlockUi componentViewerUi;
                XBCatalogPlugin pluginHandler;
                XBCXBlockUi panelEditorUi;
                XBCBlockRev blockSpecRev = ((XBCBlockDecl)decl).getBlockSpecRev();
                XBCXBlockUi panelViewerUi = uiService.findUiByPR(blockSpecRev, XBPlugUiType.PANEL_VIEWER, 0L);
                if (panelViewerUi != null) {
                    XBCXPlugUi plugUi = panelViewerUi.getUi();
                    Long methodIndex = plugUi.getMethodIndex();
                    try {
                        XBCatalogPlugin pluginHandler2 = this.pluginRepository.getPluginHandler(plugUi.getPlugin());
                        if (pluginHandler2 != null) {
                            XBPanelViewer panelViewer = ((XBPanelViewerCatalogPlugin)pluginHandler2).getPanelViewer(methodIndex.longValue());
                            this.reloadCustomViewer(panelViewer, block);
                            this.viewerPanel.addView("Viewer", panelViewer.getViewer());
                        }
                    }
                    catch (Exception ex) {
                        Logger.getLogger(DocumentViewer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                if ((panelEditorUi = uiService.findUiByPR(blockSpecRev, XBPlugUiType.PANEL_EDITOR, 0L)) != null) {
                    XBCXPlugUi plugUi = panelEditorUi.getUi();
                    Long methodIndex = plugUi.getMethodIndex();
                    try {
                        pluginHandler = this.pluginRepository.getPluginHandler(plugUi.getPlugin());
                        if (pluginHandler != null) {
                            XBPanelEditor panelEditor = ((XBPanelEditorCatalogPlugin)pluginHandler).getPanelEditor(methodIndex.longValue());
                            this.reloadCustomEditor(panelEditor, block);
                            this.viewerPanel.addView("Editor", panelEditor.getEditor());
                        }
                    }
                    catch (Exception ex) {
                        Logger.getLogger(DocumentViewer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                if ((componentViewerUi = uiService.findUiByPR(blockSpecRev, XBPlugUiType.COMPONENT_VIEWER, 0L)) != null) {
                    XBCXPlugUi plugUi = componentViewerUi.getUi();
                    try {
                        pluginHandler = this.pluginRepository.getPluginHandler(plugUi.getPlugin());
                        if (pluginHandler != null) {
                            BlockComponentViewerPanel componentViewerPanel = new BlockComponentViewerPanel();
                            componentViewerPanel.setBlock(block, plugUi, pluginHandler);
                            this.viewerPanel.addView("Component Viewer", componentViewerPanel);
                        }
                    }
                    catch (Exception ex) {
                        Logger.getLogger(DocumentViewer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                if ((componentEditorUi = uiService.findUiByPR(blockSpecRev, XBPlugUiType.COMPONENT_EDITOR, 0L)) != null) {
                    XBCXPlugUi plugUi = componentEditorUi.getUi();
                    try {
                        XBCatalogPlugin pluginHandler3 = this.pluginRepository.getPluginHandler(plugUi.getPlugin());
                        if (pluginHandler3 != null) {
                            BlockComponentEditorPanel componentEditorPanel = new BlockComponentEditorPanel();
                            componentEditorPanel.setBlock(block, plugUi, pluginHandler3);
                            this.viewerPanel.addView("Component Editor", componentEditorPanel);
                        }
                    }
                    catch (Exception ex) {
                        Logger.getLogger(DocumentViewer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                if ((rowEditorUi = uiService.findUiByPR(blockSpecRev, XBPlugUiType.ROW_EDITOR, 0L)) != null) {
                    XBCXPlugUi plugUi = rowEditorUi.getUi();
                    try {
                        XBCatalogPlugin pluginHandler4 = this.pluginRepository.getPluginHandler(plugUi.getPlugin());
                        if (pluginHandler4 != null) {
                            this.rowEditorPanel.setBlock(block, plugUi, pluginHandler4);
                            this.viewerPanel.addView("Row Viewer", this.rowEditorPanel);
                        }
                    }
                    catch (Exception ex) {
                        Logger.getLogger(DocumentViewer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
            this.blockPanel.setBlock((XBTTreeNode)block);
            if (block.getDataMode() == XBBlockDataMode.DATA_BLOCK) {
                ByteArrayEditableData byteArrayData = new ByteArrayEditableData();
                try (OutputStream dataOutputStream = byteArrayData.getDataOutputStream();){
                    StreamUtils.copyInputStreamToOutputStream((InputStream)block.getData(), (OutputStream)dataOutputStream);
                }
                catch (IOException ex) {
                    Logger.getLogger(DocumentViewer.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.binaryDataEditor.setContentData((BinaryData)byteArrayData);
                this.binaryDataEditor.attachExtraBars();
                this.viewerPanel.addView("Data", this.binaryDataEditor.getEditorPanel());
            } else {
                this.definitionPanel.setBlock(block);
                this.viewerPanel.addView("Definition", this.definitionPanel);
            }
            this.viewerPanel.addView("Block", this.blockPanel);
        }
        this.viewerPanel.viewsAdded();
        this.selectedItem = block;
        this.viewerPanel.revalidate();
        this.viewerPanel.repaint();
    }

    private void reloadCustomViewer(XBPanelViewer panelViewer, XBTBlock block) {
        XBPSerialReader serialReader = new XBPSerialReader((XBTPullProvider)new XBTProviderToPullProvider((XBTProvider)new XBTTreeWriter(block)));
        try {
            serialReader.read((XBSerializable)panelViewer);
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(DocumentViewer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void reloadCustomEditor(XBPanelEditor panelEditor, XBTBlock block) {
        XBPSerialReader serialReader = new XBPSerialReader((XBTPullProvider)new XBTProviderToPullProvider((XBTProvider)new XBTTreeWriter(block)));
        try {
            serialReader.read((XBSerializable)panelEditor);
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(DocumentViewer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

