/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.gui;

import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.BoxLayout;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.xbup.gui.XBDocTreeCellRenderer;
import org.exbin.framework.editor.xbup.gui.XBDocTreeModel;
import org.exbin.framework.editor.xbup.gui.XBDocTreeTransferHandler;
import org.exbin.framework.editor.xbup.viewer.DocumentItemSelectionListener;
import org.exbin.framework.editor.xbup.viewer.XbupTreeDocument;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.operation.undo.XBUndoHandler;
import org.exbin.xbup.parser_tree.XBTTreeNode;

@ParametersAreNonnullByDefault
public class XBDocTreePanel
extends JPanel {
    private XBApplication application;
    private XbupTreeDocument treeDocument;
    private final XBDocTreeModel mainDocModel;
    private XBDocTreeCellRenderer cellRenderer;
    private XBACatalog catalog;
    private XBUndoHandler undoHandler;
    private final List<ActionListener> updateListeners;
    private final List<DocumentItemSelectionListener> itemSelectionListeners = new ArrayList<DocumentItemSelectionListener>();
    private JScrollPane mainScrollPane;
    private JTree mainTree;

    public XBDocTreePanel() {
        this.mainDocModel = new XBDocTreeModel();
        this.cellRenderer = new XBDocTreeCellRenderer();
        this.initComponents();
        this.mainTree.setCellRenderer(this.cellRenderer);
        this.mainTree.addTreeSelectionListener(e -> {
            XBTTreeNode selectedItem = this.getSelectedItem();
            this.itemSelectionListeners.forEach(listener -> listener.itemSelected((XBTBlock)selectedItem));
            this.notifyUpdate();
        });
        this.updateListeners = new ArrayList<ActionListener>();
        this.mainTree.setDragEnabled(true);
        this.mainTree.setDropMode(DropMode.USE_SELECTION);
        this.mainTree.setTransferHandler(new XBDocTreeTransferHandler(this));
    }

    private void notifyUpdate() {
        this.updateListeners.forEach(updateListener -> updateListener.actionPerformed(null));
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    public void setTreeDocument(XbupTreeDocument treeDocument) {
        this.treeDocument = treeDocument;
        this.mainDocModel.setTreeDocument(treeDocument);
        this.cellRenderer.setTreeDocument(treeDocument);
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
        if (this.treeDocument != null) {
            this.treeDocument.setCatalog(catalog);
        }
    }

    public void setUndoHandler(XBUndoHandler undoHandler) {
        this.undoHandler = undoHandler;
    }

    public void addTreeSelectionListener(TreeSelectionListener listener) {
        this.mainTree.getSelectionModel().addTreeSelectionListener(listener);
    }

    private void initComponents() {
        this.mainScrollPane = new JScrollPane();
        this.mainTree = new JTree();
        this.setLayout(new BoxLayout(this, 2));
        this.mainScrollPane.setBorder(null);
        this.mainTree.setModel(this.mainDocModel);
        this.mainTree.setAutoscrolls(true);
        this.mainTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                XBDocTreePanel.this.mainTreeMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                XBDocTreePanel.this.mainTreeMouseReleased(evt);
            }
        });
        this.mainScrollPane.setViewportView(this.mainTree);
        this.add(this.mainScrollPane);
    }

    private void mainTreeMouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.mainTree.setSelectionPath(this.mainTree.getPathForLocation(evt.getX(), evt.getY()));
        }
    }

    private void mainTreeMousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.mainTree.setSelectionPath(this.mainTree.getPathForLocation(evt.getX(), evt.getY()));
        }
    }

    @Nullable
    public XBTTreeNode getSelectedItem() {
        return (XBTTreeNode)this.mainTree.getLastSelectedPathComponent();
    }

    public void reportStructureChange(XBTBlock block) {
        if (block == null) {
            this.mainDocModel.fireTreeChanged();
        } else {
            this.mainDocModel.fireTreeStructureChanged(block);
        }
    }

    public void addUpdateListener(ActionListener listener) {
        this.updateListeners.add(listener);
    }

    public void removeUpdateListener(ActionListener listener) {
        this.updateListeners.remove(listener);
    }

    public XBACatalog getCatalog() {
        return this.catalog;
    }

    public void performSelectAll() {
        this.mainTree.setSelectionRow(0);
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new XBDocTreePanel());
    }

    public XBUndoHandler getUndoHandler() {
        return this.undoHandler;
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.mainTree.setComponentPopupMenu(popupMenu);
    }

    public void addItemSelectionListener(DocumentItemSelectionListener listener) {
        this.itemSelectionListeners.add(listener);
    }

    public void removeItemSelectionListener(DocumentItemSelectionListener listener) {
        this.itemSelectionListeners.remove(listener);
    }

    public boolean hasSelection() {
        return !this.mainTree.isSelectionEmpty();
    }

    public void addTreeFocusListener(FocusListener focusListener) {
        this.mainTree.addFocusListener(focusListener);
    }

    public void removeTreeFocusListener(FocusListener focusListener) {
        this.mainTree.removeFocusListener(focusListener);
    }
}

