/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.gui;

import java.awt.Component;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.xbup.def.model.ParametersTableModel;
import org.exbin.framework.editor.xbup.gui.ParametersTableItem;
import org.exbin.framework.editor.xbup.gui.XBPropertyTableCellPanel;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.parser_tree.XBTTreeNode;
import org.exbin.xbup.plugin.XBPluginRepository;
import org.exbin.xbup.plugin.XBRowEditor;

@ParametersAreNonnullByDefault
public class ParametersTableCellEditor
extends DefaultCellEditor {
    private XBApplication application;
    private XBACatalog catalog;
    private final XBPluginRepository pluginRepository;
    private XBTTreeNode node;
    private XBRowEditor lineEditor = null;
    private JComponent lineEditorComponent = null;

    public ParametersTableCellEditor(XBACatalog catalog, XBPluginRepository pluginRepository, XBTTreeNode node) {
        super(new JTextField());
        super.setClickCountToStart(0);
        this.catalog = catalog;
        this.pluginRepository = pluginRepository;
        this.node = node;
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        XBPropertyTableCellPanel cellPanel;
        ParametersTableItem tableItem = ((ParametersTableModel)table.getModel()).getRow(row);
        this.lineEditor = tableItem.getRowEditor();
        JComponent jComponent = this.lineEditorComponent = this.lineEditor == null ? null : this.lineEditor.getEditor();
        if (this.lineEditorComponent == null) {
            JComponent defaultComponent = (JComponent)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            defaultComponent.setEnabled(false);
            cellPanel = new XBPropertyTableCellPanel(defaultComponent, this.catalog, this.pluginRepository, this.node, row);
        } else {
            cellPanel = new XBPropertyTableCellPanel(this.lineEditorComponent, this.catalog, this.pluginRepository, this.node, row);
        }
        cellPanel.setApplication(this.application);
        cellPanel.setBackground(table.getSelectionBackground());
        cellPanel.getCellComponent().setBorder(null);
        return cellPanel;
    }

    @Override
    public boolean stopCellEditing() {
        if (this.lineEditor != null) {
            try {
                this.lineEditor.finishEditor();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.editorComponent, ex.toString(), "Cell Input", 0);
            }
        }
        return super.stopCellEditing();
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
    }

    public void setNode(XBTTreeNode node) {
        this.node = node;
    }
}

