/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URI;
import java.util.ResourceBundle;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.xbup.core.block.XBTEditableDocument;
import org.exbin.xbup.parser_tree.XBTTreeDocument;

@ParametersAreNonnullByDefault
public class DocumentPropertiesPanel
extends JPanel {
    private XBTEditableDocument doc;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(DocumentPropertiesPanel.class);
    private JPanel documentTypePanel;
    private JLabel fileNameLabel;
    private JTextField fileNameTextField;
    private JLabel fileSizeLabel;
    private JTextField fileSizeTextField;
    private JLabel fileTypeLabel;
    private JTextField fileTypeTextField;
    private JPanel generalPanel;
    private JTabbedPane propertiesTabbedPane;

    public DocumentPropertiesPanel() {
        this.initComponents();
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new DocumentPropertiesPanel());
    }

    private void initComponents() {
        this.propertiesTabbedPane = new JTabbedPane();
        this.generalPanel = new JPanel();
        this.fileNameLabel = new JLabel();
        this.fileNameTextField = new JTextField();
        this.fileSizeTextField = new JTextField();
        this.fileTypeLabel = new JLabel();
        this.fileTypeTextField = new JTextField();
        this.fileSizeLabel = new JLabel();
        this.documentTypePanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.fileNameLabel.setText(this.resourceBundle.getString("fileNameLabel.text"));
        this.fileNameTextField.setEditable(false);
        this.fileSizeTextField.setEditable(false);
        this.fileTypeLabel.setText(this.resourceBundle.getString("fileTypeLabel.text"));
        this.fileTypeTextField.setEditable(false);
        this.fileSizeLabel.setText(this.resourceBundle.getString("fileSizeLabel.text"));
        GroupLayout generalPanelLayout = new GroupLayout(this.generalPanel);
        this.generalPanel.setLayout(generalPanelLayout);
        generalPanelLayout.setHorizontalGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(generalPanelLayout.createSequentialGroup().addContainerGap().addGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fileNameLabel).addComponent(this.fileTypeLabel).addComponent(this.fileSizeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fileNameTextField, GroupLayout.Alignment.TRAILING, -1, 250, Short.MAX_VALUE).addComponent(this.fileTypeTextField).addComponent(this.fileSizeTextField, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        generalPanelLayout.setVerticalGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(generalPanelLayout.createSequentialGroup().addContainerGap().addGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileNameLabel).addComponent(this.fileNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileSizeTextField, -2, -1, -2).addComponent(this.fileSizeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileTypeLabel).addComponent(this.fileTypeTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.propertiesTabbedPane.addTab("General", this.generalPanel);
        GroupLayout documentTypePanelLayout = new GroupLayout(this.documentTypePanel);
        this.documentTypePanel.setLayout(documentTypePanelLayout);
        documentTypePanelLayout.setHorizontalGroup(documentTypePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 398, Short.MAX_VALUE));
        documentTypePanelLayout.setVerticalGroup(documentTypePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 93, Short.MAX_VALUE));
        this.propertiesTabbedPane.addTab("Type", this.documentTypePanel);
        this.add((Component)this.propertiesTabbedPane, "Center");
    }

    public void setDocument(XBTEditableDocument document) {
        this.doc = document;
        if (this.doc instanceof XBTTreeDocument) {
            this.fileSizeTextField.setText(Long.toString(((XBTTreeDocument)this.doc).getDocumentSize()));
        } else {
            this.fileSizeTextField.setText("Unknown");
        }
    }

    public void setDocumentUri(URI fileUri) {
        this.fileNameTextField.setText(fileUri == null ? "" : fileUri.toString());
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }
}

