/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.handler.DefaultControlHandler;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.declaration.XBBlockDecl;
import org.exbin.xbup.core.block.declaration.XBContext;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.block.declaration.XBGroup;
import org.exbin.xbup.core.block.declaration.catalog.XBCBlockDecl;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;
import org.exbin.xbup.parser_tree.XBTTreeNode;

@ParametersAreNonnullByDefault
public class ContextTypeChoicePanel
extends JPanel {
    private XBTTreeNode parentNode;
    private final XBACatalog catalog;
    private int selectedGroup;
    private final XBCXNameService nameService;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(ContextTypeChoicePanel.class);
    private DefaultControlHandler.DefaultControlEnablementListener enablementListener = null;
    private JLabel blockLabel;
    private JList<String> blockTypeList;
    private JScrollPane blockTypeScrollPane;
    private JComboBox<String> groupComboBox;
    private JLabel groupLabel;

    public ContextTypeChoicePanel(XBACatalog catalog, XBTTreeNode parentNode) {
        this.catalog = catalog;
        this.parentNode = parentNode;
        this.nameService = (XBCXNameService)catalog.getCatalogService(XBCXNameService.class);
        this.initComponents();
        this.init();
    }

    private void init() {
        if (this.catalog != null && this.parentNode != null) {
            XBContext context = this.parentNode.getContext();
            int groupId = 1;
            for (XBGroup typeGroup : context.getGroups()) {
                this.groupComboBox.addItem(Integer.toString(groupId));
                ++groupId;
            }
        }
    }

    private void initComponents() {
        this.groupLabel = new JLabel();
        this.groupComboBox = new JComboBox();
        this.blockLabel = new JLabel();
        this.blockTypeScrollPane = new JScrollPane();
        this.blockTypeList = new JList();
        this.groupLabel.setText("Type Group");
        this.groupComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContextTypeChoicePanel.this.groupComboBoxActionPerformed(evt);
            }
        });
        this.blockLabel.setText("Block Type");
        this.blockTypeList.setModel(new DefaultListModel());
        this.blockTypeList.setSelectionMode(0);
        this.blockTypeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ContextTypeChoicePanel.this.blockTypeListValueChanged(evt);
            }
        });
        this.blockTypeScrollPane.setViewportView(this.blockTypeList);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.groupLabel).addComponent(this.blockLabel)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.blockTypeScrollPane, -1, 330, Short.MAX_VALUE).addComponent(this.groupComboBox, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.groupLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.groupComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.blockLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.blockTypeScrollPane, -1, 214, Short.MAX_VALUE).addContainerGap()));
    }

    private void groupComboBoxActionPerformed(ActionEvent evt) {
        ((DefaultListModel)this.blockTypeList.getModel()).removeAllElements();
        if (this.parentNode != null) {
            XBGroup groupForId;
            XBContext context = this.parentNode.getContext();
            this.selectedGroup = this.groupComboBox.getSelectedIndex() + 1;
            if (this.selectedGroup >= 0 && (groupForId = context.getGroupForId(this.selectedGroup)) != null) {
                int blockId = 0;
                for (XBBlockDecl blockDecl : groupForId.getBlocks()) {
                    String blockCaption = Integer.toString(blockId);
                    if (blockDecl != null && blockDecl instanceof XBCBlockDecl) {
                        blockCaption = blockCaption + ": " + this.nameService.getDefaultText((XBCItem)((XBCBlockDecl)blockDecl).getBlockSpecRev().getParent());
                    }
                    ((DefaultListModel)this.blockTypeList.getModel()).addElement(blockCaption);
                    ++blockId;
                }
            }
        }
    }

    private void blockTypeListValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting() && this.enablementListener != null) {
            this.enablementListener.actionEnabled(DefaultControlHandler.ControlActionType.OK, this.blockTypeList.getSelectedIndex() >= 0);
        }
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new ContextTypeChoicePanel(null, null));
    }

    public void setParentNode(XBTTreeNode parentNode) {
        this.parentNode = parentNode;
    }

    @Nullable
    public XBBlockType getBlockType() {
        if (this.selectedGroup >= 0) {
            XBContext context = this.parentNode.getContext();
            XBGroup groupForId = context.getGroupForId(this.selectedGroup);
            XBBlockDecl blockDecl = groupForId.getBlockForId(this.blockTypeList.getSelectedIndex());
            return blockDecl != null ? new XBDeclBlockType(blockDecl) : null;
        }
        return null;
    }

    public void setCanProceedListener(DefaultControlHandler.DefaultControlEnablementListener enablementListener) {
        this.enablementListener = enablementListener;
        enablementListener.actionEnabled(DefaultControlHandler.ControlActionType.OK, false);
    }
}

