/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.gui;

import java.awt.Component;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.xbup.def.model.BlocksTableModel;
import org.exbin.framework.editor.xbup.gui.BlocksTableItem;
import org.exbin.framework.editor.xbup.gui.XBPropertyTableCellPanel;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.parser_tree.XBTTreeNode;
import org.exbin.xbup.plugin.XBPluginRepository;

@ParametersAreNonnullByDefault
public class BlocksTableCellRenderer
implements TableCellRenderer {
    private XBApplication application;
    private XBACatalog catalog;
    private XBPluginRepository pluginRepository;
    private XBTTreeNode node;

    public BlocksTableCellRenderer(XBACatalog catalog, XBPluginRepository pluginRepository, XBTTreeNode node) {
        this.catalog = catalog;
        this.pluginRepository = pluginRepository;
        this.node = node;
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        BlocksTableItem tableItem = ((BlocksTableModel)table.getModel()).getRow(row);
        JComponent component = tableItem.getRowEditor() == null ? null : tableItem.getRowEditor().getViewer();
        XBPropertyTableCellPanel cellPanel = component == null ? new XBPropertyTableCellPanel(this.catalog, this.pluginRepository, this.node, row) : new XBPropertyTableCellPanel(component, this.catalog, this.pluginRepository, this.node, row);
        cellPanel.setApplication(this.application);
        cellPanel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        cellPanel.getCellComponent().setBorder(null);
        return cellPanel;
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
    }

    public void setNode(XBTTreeNode node) {
        this.node = node;
    }
}

