/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.exbin.bined.CodeType;
import org.exbin.bined.highlight.swing.extended.ExtendedHighlightNonAsciiCodeAreaPainter;
import org.exbin.bined.swing.extended.ExtCodeArea;
import org.exbin.framework.action.gui.DropDownButton;
import org.exbin.framework.bined.preferences.BinaryEditorPreferences;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class BinaryToolbarPanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(BinaryToolbarPanel.class);
    private BinaryEditorPreferences preferences;
    private ExtCodeArea codeArea;
    private ActionListener goToPositionAction;
    private AbstractAction cycleCodeTypesAction;
    private JRadioButtonMenuItem binaryCodeTypeAction;
    private JRadioButtonMenuItem octalCodeTypeAction;
    private JRadioButtonMenuItem decimalCodeTypeAction;
    private JRadioButtonMenuItem hexadecimalCodeTypeAction;
    private ButtonGroup codeTypeButtonGroup;
    private DropDownButton codeTypeDropDown;
    private JToggleButton codeColorizationToggleButton;
    private JToolBar controlToolBar;
    private JButton goToButton;
    private JToolBar.Separator separator1;
    private JToolBar.Separator separator2;
    private JToggleButton showUnprintablesToggleButton;

    public BinaryToolbarPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.codeTypeButtonGroup = new ButtonGroup();
        this.binaryCodeTypeAction = new JRadioButtonMenuItem(new AbstractAction(this.resourceBundle.getString("codeType.binary")){

            @Override
            public void actionPerformed(ActionEvent e) {
                BinaryToolbarPanel.this.codeArea.setCodeType(CodeType.BINARY);
                BinaryToolbarPanel.this.updateCycleButtonState();
            }
        });
        this.codeTypeButtonGroup.add(this.binaryCodeTypeAction);
        this.octalCodeTypeAction = new JRadioButtonMenuItem(new AbstractAction(this.resourceBundle.getString("codeType.octal")){

            @Override
            public void actionPerformed(ActionEvent e) {
                BinaryToolbarPanel.this.codeArea.setCodeType(CodeType.OCTAL);
                BinaryToolbarPanel.this.updateCycleButtonState();
            }
        });
        this.codeTypeButtonGroup.add(this.octalCodeTypeAction);
        this.decimalCodeTypeAction = new JRadioButtonMenuItem(new AbstractAction(this.resourceBundle.getString("codeType.decimal")){

            @Override
            public void actionPerformed(ActionEvent e) {
                BinaryToolbarPanel.this.codeArea.setCodeType(CodeType.DECIMAL);
                BinaryToolbarPanel.this.updateCycleButtonState();
            }
        });
        this.codeTypeButtonGroup.add(this.decimalCodeTypeAction);
        this.hexadecimalCodeTypeAction = new JRadioButtonMenuItem(new AbstractAction(this.resourceBundle.getString("codeType.hexadecimal")){

            @Override
            public void actionPerformed(ActionEvent e) {
                BinaryToolbarPanel.this.codeArea.setCodeType(CodeType.HEXADECIMAL);
                BinaryToolbarPanel.this.updateCycleButtonState();
            }
        });
        this.codeTypeButtonGroup.add(this.hexadecimalCodeTypeAction);
        this.cycleCodeTypesAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeType[] values;
                int codeTypePos = BinaryToolbarPanel.this.codeArea.getCodeType().ordinal();
                CodeType next = codeTypePos + 1 >= (values = CodeType.values()).length ? values[0] : values[codeTypePos + 1];
                BinaryToolbarPanel.this.codeArea.setCodeType(next);
                BinaryToolbarPanel.this.updateCycleButtonState();
            }
        };
        this.cycleCodeTypesAction.putValue("ShortDescription", this.resourceBundle.getString("cycleCodeTypesAction.text"));
        JPopupMenu cycleCodeTypesPopupMenu = new JPopupMenu();
        cycleCodeTypesPopupMenu.add(this.binaryCodeTypeAction);
        cycleCodeTypesPopupMenu.add(this.octalCodeTypeAction);
        cycleCodeTypesPopupMenu.add(this.decimalCodeTypeAction);
        cycleCodeTypesPopupMenu.add(this.hexadecimalCodeTypeAction);
        this.codeTypeDropDown = new DropDownButton((Action)this.cycleCodeTypesAction, cycleCodeTypesPopupMenu);
        this.controlToolBar.add((Component)this.codeTypeDropDown, 0);
    }

    public void setCodeArea(ExtCodeArea codeArea) {
        this.codeArea = codeArea;
        this.codeColorizationToggleButton.setSelected(((ExtendedHighlightNonAsciiCodeAreaPainter)codeArea.getPainter()).isNonAsciiHighlightingEnabled());
        this.updateCycleButtonState();
    }

    public void setPreferences(BinaryEditorPreferences preferences) {
        this.preferences = preferences;
    }

    public void setGoToPositionAction(ActionListener goToPositionAction) {
        this.goToPositionAction = goToPositionAction;
    }

    private void updateCycleButtonState() {
        CodeType codeType = this.codeArea.getCodeType();
        this.codeTypeDropDown.setActionText(codeType.name().substring(0, 3));
        switch (codeType) {
            case BINARY: {
                if (this.binaryCodeTypeAction.isSelected()) break;
                this.binaryCodeTypeAction.setSelected(true);
                break;
            }
            case OCTAL: {
                if (this.octalCodeTypeAction.isSelected()) break;
                this.octalCodeTypeAction.setSelected(true);
                break;
            }
            case DECIMAL: {
                if (this.decimalCodeTypeAction.isSelected()) break;
                this.decimalCodeTypeAction.setSelected(true);
                break;
            }
            case HEXADECIMAL: {
                if (this.hexadecimalCodeTypeAction.isSelected()) break;
                this.hexadecimalCodeTypeAction.setSelected(true);
            }
        }
    }

    public void applyFromCodeArea() {
        this.updateCycleButtonState();
        this.updateUnprintables();
    }

    public void loadFromPreferences() {
        this.codeArea.setCodeType(this.preferences.getCodeAreaPreferences().getCodeType());
        this.updateCycleButtonState();
        this.updateUnprintables();
    }

    public void updateUnprintables() {
        this.showUnprintablesToggleButton.setSelected(this.codeArea.isShowUnprintables());
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.codeTypeDropDown != null) {
            this.codeTypeDropDown.updateUI();
        }
    }

    private void initComponents() {
        this.controlToolBar = new JToolBar();
        this.goToButton = new JButton();
        this.separator1 = new JToolBar.Separator();
        this.showUnprintablesToggleButton = new JToggleButton();
        this.codeColorizationToggleButton = new JToggleButton();
        this.separator2 = new JToolBar.Separator();
        this.controlToolBar.setBorder(null);
        this.controlToolBar.setRollover(true);
        this.goToButton.setIcon(new ImageIcon(this.getClass().getResource("/org/exbin/framework/editor/xbup/resources/icons/open_icon_library-standard/icons/png/16x16/actions/bullet_go.png")));
        this.goToButton.setToolTipText(this.resourceBundle.getString("goToButton.toolTipText"));
        this.goToButton.setFocusable(false);
        this.goToButton.setHorizontalTextPosition(0);
        this.goToButton.setVerticalTextPosition(3);
        this.goToButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BinaryToolbarPanel.this.goToButtonActionPerformed(evt);
            }
        });
        this.controlToolBar.add(this.goToButton);
        this.controlToolBar.add(this.separator1);
        this.showUnprintablesToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/org/exbin/framework/editor/xbup/resources/icons/open_icon_library-standard/icons/png/16x16/actions/insert-pilcrow.png")));
        this.showUnprintablesToggleButton.setToolTipText(this.resourceBundle.getString("showUnprintablesToggleButton.toolTipText"));
        this.showUnprintablesToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BinaryToolbarPanel.this.showUnprintablesToggleButtonActionPerformed(evt);
            }
        });
        this.controlToolBar.add(this.showUnprintablesToggleButton);
        this.codeColorizationToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/org/exbin/framework/editor/xbup/resources/icons/open_icon_library-standard/icons/png/16x16/actions/color_swatch.png")));
        this.codeColorizationToggleButton.setToolTipText(this.resourceBundle.getString("codeColorizationToggleButton.toolTipText"));
        this.codeColorizationToggleButton.setFocusable(false);
        this.codeColorizationToggleButton.setHorizontalTextPosition(0);
        this.codeColorizationToggleButton.setVerticalTextPosition(3);
        this.codeColorizationToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BinaryToolbarPanel.this.codeColorizationToggleButtonActionPerformed(evt);
            }
        });
        this.controlToolBar.add(this.codeColorizationToggleButton);
        this.controlToolBar.add(this.separator2);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.controlToolBar, -2, -1, -2).addGap(0, 231, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.controlToolBar, -2, 20, -2).addGap(0, 0, 0)));
    }

    private void showUnprintablesToggleButtonActionPerformed(ActionEvent evt) {
        this.codeArea.setShowUnprintables(this.showUnprintablesToggleButton.isSelected());
    }

    private void codeColorizationToggleButtonActionPerformed(ActionEvent evt) {
        ((ExtendedHighlightNonAsciiCodeAreaPainter)this.codeArea.getPainter()).setNonAsciiHighlightingEnabled(this.codeColorizationToggleButton.isSelected());
        this.codeArea.repaint();
    }

    private void goToButtonActionPerformed(ActionEvent evt) {
        this.goToPositionAction.actionPerformed(evt);
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new BinaryToolbarPanel());
    }
}

