/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.def.model;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.table.AbstractTableModel;
import org.exbin.framework.editor.xbup.gui.BlocksTableItem;
import org.exbin.framework.utils.LanguageUtils;

@ParametersAreNonnullByDefault
public class BlocksTableModel
extends AbstractTableModel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(BlocksTableModel.class);
    private List<BlocksTableItem> blocks;
    private final String[] columnNames;
    private Class[] columnTypes = new Class[]{Integer.class, String.class, String.class, Object.class};
    private final boolean[] columnsEditable = new boolean[]{false, false, false, true};

    public BlocksTableModel() {
        this.columnNames = new String[]{this.resourceBundle.getString("itemOrder"), this.resourceBundle.getString("itemName"), this.resourceBundle.getString("itemType"), this.resourceBundle.getString("itemValue")};
        this.blocks = new ArrayList<BlocksTableItem>();
    }

    @Override
    public int getRowCount() {
        return this.blocks.size();
    }

    public BlocksTableItem getRow(int index) {
        return this.blocks.get(index);
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.getTypes()[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.columnsEditable[columnIndex];
    }

    @Override
    @Nonnull
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return rowIndex;
            }
            case 1: {
                return this.getParameter(rowIndex).getValueName();
            }
            case 2: {
                return this.getParameter(rowIndex).getTypeName();
            }
            case 3: {
                return "";
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex < this.getRowCount() && columnIndex != 3) {
            throw new IllegalStateException();
        }
    }

    @Nonnull
    public List<BlocksTableItem> getParameters() {
        return this.blocks;
    }

    public void setParameters(List<BlocksTableItem> attributes) {
        this.blocks = attributes;
    }

    @Nonnull
    public Class[] getTypes() {
        return this.columnTypes;
    }

    public void setTypes(Class[] types) {
        this.columnTypes = types;
    }

    @Nullable
    public BlocksTableItem getParameter(int index) {
        if (index >= this.blocks.size()) {
            return null;
        }
        return this.blocks.get(index);
    }

    public void clear() {
        this.blocks.clear();
    }

    public void addRow(BlocksTableItem item) {
        this.blocks.add(item);
    }

    public boolean isEmpty() {
        return this.blocks == null || this.blocks.isEmpty();
    }
}

