/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.def.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.xbup.def.BinaryDataEditor;
import org.exbin.framework.editor.xbup.def.gui.BinaryDataPanel;
import org.exbin.framework.editor.xbup.def.gui.NodeBlockPanel;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.xbup.core.block.XBBlockDataMode;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.parser_tree.XBTTreeNode;
import org.exbin.xbup.plugin.XBPluginRepository;

@ParametersAreNonnullByDefault
public class BlockPanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(BlockPanel.class);
    private XBApplication application;
    private JComponent activeComponent = null;
    private XBTTreeNode block;
    private XBACatalog catalog;
    private XBPluginRepository pluginRepository;
    private boolean dataModeAdjusting = false;
    private BinaryDataEditor binaryDataEditor = new BinaryDataEditor();
    private JPopupMenu popupMenu;
    private ButtonGroup blockTypeButtonGroup;
    private JLabel blockTypeLabel;
    private JPanel contentPanel;
    private JRadioButton dataBlockRadioButton;
    private JRadioButton nodeBlockRadioButton;
    private JCheckBox terminationModeCheckBox;

    public BlockPanel() {
        this.initComponents();
    }

    public void setApplication(XBApplication application) {
        this.application = application;
        this.binaryDataEditor.setApplication(application);
    }

    private void initComponents() {
        this.blockTypeButtonGroup = new ButtonGroup();
        this.terminationModeCheckBox = new JCheckBox();
        this.blockTypeLabel = new JLabel();
        this.nodeBlockRadioButton = new JRadioButton();
        this.dataBlockRadioButton = new JRadioButton();
        this.contentPanel = new JPanel();
        this.terminationModeCheckBox.setText("Block size specified");
        this.blockTypeLabel.setText("Block Type");
        this.blockTypeLabel.setToolTipText("");
        this.blockTypeButtonGroup.add(this.nodeBlockRadioButton);
        this.nodeBlockRadioButton.setSelected(true);
        this.nodeBlockRadioButton.setText("Node Block");
        this.nodeBlockRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                BlockPanel.this.nodeBlockRadioButtonItemStateChanged(evt);
            }
        });
        this.blockTypeButtonGroup.add(this.dataBlockRadioButton);
        this.dataBlockRadioButton.setText("Data Block");
        this.dataBlockRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                BlockPanel.this.dataBlockRadioButtonItemStateChanged(evt);
            }
        });
        this.contentPanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.terminationModeCheckBox, -1, 388, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.blockTypeLabel).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.nodeBlockRadioButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.dataBlockRadioButton, -1, -1, Short.MAX_VALUE)).addContainerGap()).addComponent(this.contentPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.terminationModeCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.blockTypeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nodeBlockRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dataBlockRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.contentPanel, -1, 190, Short.MAX_VALUE)));
    }

    private void nodeBlockRadioButtonItemStateChanged(ItemEvent evt) {
        if (!this.dataModeAdjusting) {
            this.changeDataMode(XBBlockDataMode.NODE_BLOCK);
        }
    }

    private void dataBlockRadioButtonItemStateChanged(ItemEvent evt) {
        if (!this.dataModeAdjusting) {
            this.changeDataMode(XBBlockDataMode.DATA_BLOCK);
        }
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new BlockPanel());
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
    }

    public void setPluginRepository(XBPluginRepository pluginRepository) {
        this.pluginRepository = pluginRepository;
    }

    public void setBlock(XBTTreeNode block) {
        this.block = block;
        this.terminationModeCheckBox.setSelected(block.getTerminationMode() == XBBlockTerminationMode.SIZE_SPECIFIED);
        XBBlockDataMode dataMode = block.getDataMode();
        this.dataModeAdjusting = true;
        if (dataMode == XBBlockDataMode.DATA_BLOCK) {
            this.dataBlockRadioButton.setSelected(true);
        } else {
            this.nodeBlockRadioButton.setSelected(true);
        }
        this.dataModeAdjusting = false;
        if (!this.switchContentComponent(dataMode)) {
            this.updateContentComponent(this.activeComponent);
        }
    }

    private boolean switchContentComponent(XBBlockDataMode blockDataMode) {
        switch (blockDataMode) {
            case DATA_BLOCK: {
                if (this.activeComponent instanceof BinaryDataPanel) break;
                if (this.activeComponent != null) {
                    this.contentPanel.remove(this.activeComponent);
                }
                BinaryDataPanel binaryDataPanel = this.binaryDataEditor.getEditorPanel();
                this.updateContentComponent(binaryDataPanel);
                this.binaryDataEditor.attachExtraBars();
                this.contentPanel.add((Component)binaryDataPanel, "Center");
                this.contentPanel.revalidate();
                this.contentPanel.repaint();
                this.activeComponent = binaryDataPanel;
                return true;
            }
            case NODE_BLOCK: {
                if (this.activeComponent instanceof NodeBlockPanel) break;
                if (this.activeComponent != null) {
                    this.contentPanel.remove(this.activeComponent);
                }
                NodeBlockPanel nodeBlockPanel = new NodeBlockPanel();
                nodeBlockPanel.setApplication(this.application);
                nodeBlockPanel.setPluginRepository(this.pluginRepository);
                nodeBlockPanel.setCatalog(this.catalog);
                this.updateContentComponent(nodeBlockPanel);
                this.contentPanel.add((Component)nodeBlockPanel, "Center");
                this.contentPanel.revalidate();
                this.contentPanel.repaint();
                this.activeComponent = nodeBlockPanel;
                return true;
            }
        }
        return false;
    }

    private void updateContentComponent(JComponent activeComponent) {
        if (activeComponent instanceof BinaryDataPanel) {
            BinaryDataPanel binaryDataPanel = (BinaryDataPanel)activeComponent;
            binaryDataPanel.setContentData(this.block.getBlockData());
        } else if (activeComponent instanceof NodeBlockPanel) {
            NodeBlockPanel nodeBlockPanel = (NodeBlockPanel)activeComponent;
            nodeBlockPanel.setBlock(this.block);
        }
    }

    private void changeDataMode(XBBlockDataMode blockDataMode) {
        this.block.setDataMode(blockDataMode);
        this.switchContentComponent(blockDataMode);
    }
}

