/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.def;

import java.io.IOException;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JPopupMenu;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.xbup.def.gui.ParametersPanel;
import org.exbin.framework.editor.xbup.def.model.ParametersTableModel;
import org.exbin.framework.editor.xbup.gui.ParametersTableCellEditor;
import org.exbin.framework.editor.xbup.gui.ParametersTableCellRenderer;
import org.exbin.framework.editor.xbup.gui.ParametersTableItem;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.block.declaration.XBBlockDecl;
import org.exbin.xbup.core.block.declaration.catalog.XBCBlockDecl;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.XBPlugUiType;
import org.exbin.xbup.core.catalog.base.XBCBlockRev;
import org.exbin.xbup.core.catalog.base.XBCBlockSpec;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCRev;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.XBCSpecDef;
import org.exbin.xbup.core.catalog.base.XBCXBlockUi;
import org.exbin.xbup.core.catalog.base.XBCXName;
import org.exbin.xbup.core.catalog.base.XBCXPlugUi;
import org.exbin.xbup.core.catalog.base.XBCXPlugin;
import org.exbin.xbup.core.catalog.base.service.XBCSpecService;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;
import org.exbin.xbup.core.catalog.base.service.XBCXUiService;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.token.event.XBTEventListener;
import org.exbin.xbup.core.parser.token.pull.XBTPullProvider;
import org.exbin.xbup.core.serial.XBPSerialReader;
import org.exbin.xbup.core.serial.XBPSerialWriter;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.parser_tree.XBATreeParamExtractor;
import org.exbin.xbup.parser_tree.XBTTreeNode;
import org.exbin.xbup.plugin.XBCatalogPlugin;
import org.exbin.xbup.plugin.XBPluginRepository;
import org.exbin.xbup.plugin.XBRowEditor;
import org.exbin.xbup.plugin.XBRowEditorCatalogPlugin;

@ParametersAreNonnullByDefault
public class ParametersEditor {
    private ParametersPanel editorPanel = new ParametersPanel();
    private final ParametersTableModel parametersTableModel = new ParametersTableModel();
    private XBApplication application;
    private XBACatalog catalog;
    private XBPluginRepository pluginRepository;
    private JPopupMenu popupMenu;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(ParametersEditor.class);

    public ParametersEditor() {
        this.popupMenu = new JPopupMenu();
        this.editorPanel.setPanelPopup(this.popupMenu);
        this.editorPanel.setParametersTableModel(this.parametersTableModel);
    }

    @Nonnull
    public ParametersPanel getEditorPanel() {
        return this.editorPanel;
    }

    public void setApplication(XBApplication application) {
        this.application = application;
        this.editorPanel.setApplication(application);
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
        this.editorPanel.setCatalog(catalog);
    }

    public void setPluginRepository(XBPluginRepository pluginRepository) {
        this.pluginRepository = pluginRepository;
    }

    public void setBlock(XBTTreeNode block) {
        TableColumnModel columnModel = this.editorPanel.getParametersTable().getColumnModel();
        TableColumn column = columnModel.getColumn(3);
        ParametersTableCellEditor parametersTableCellEditor = new ParametersTableCellEditor(this.catalog, this.pluginRepository, block);
        parametersTableCellEditor.setApplication(this.application);
        column.setCellEditor(parametersTableCellEditor);
        ParametersTableCellRenderer parametersTableCellRenderer = new ParametersTableCellRenderer(this.catalog, this.pluginRepository, block);
        parametersTableCellRenderer.setApplication(this.application);
        column.setCellRenderer(parametersTableCellRenderer);
        this.parametersTableModel.clear();
        if (block == null) {
            this.parametersTableModel.fireTableDataChanged();
            return;
        }
        XBBlockDecl decl = block.getBlockDecl();
        XBCSpecService specService = (XBCSpecService)this.catalog.getCatalogService(XBCSpecService.class);
        if (decl instanceof XBCBlockDecl) {
            XBCXNameService nameService = (XBCXNameService)this.catalog.getCatalogService(XBCXNameService.class);
            XBCXUiService uiService = (XBCXUiService)this.catalog.getCatalogService(XBCXUiService.class);
            XBCBlockSpec spec = ((XBCBlockDecl)decl).getBlockSpecRev().getParent();
            long bindCount = specService.getSpecDefsCount((XBCSpec)spec);
            XBATreeParamExtractor paramExtractor = new XBATreeParamExtractor((XBTBlock)block, this.catalog);
            int paramIndex = 0;
            while ((long)paramIndex < bindCount) {
                XBCSpecDef specDef = specService.getSpecDefByOrder((XBCSpec)spec, (long)paramIndex);
                String specName = "";
                String specType = "";
                XBRowEditor lineEditor = null;
                if (specDef != null) {
                    Optional rowRev;
                    XBCXName specDefName = nameService.getDefaultItemName((XBCItem)specDef);
                    if (specDefName != null) {
                        specName = specDefName.getText();
                    }
                    if ((rowRev = specDef.getTargetRev()).isPresent()) {
                        XBCSpec rowSpec = ((XBCRev)rowRev.get()).getParent();
                        try {
                            lineEditor = this.getCustomEditor((XBCBlockRev)rowRev.get(), uiService);
                            if (lineEditor != null) {
                                paramExtractor.setParameterIndex(paramIndex);
                                XBPSerialReader serialReader = new XBPSerialReader((XBTPullProvider)paramExtractor);
                                serialReader.read((XBSerializable)lineEditor);
                                lineEditor.attachChangeListener((XBRowEditor.ChangeListener)new ComponentEditorChangeListener(lineEditor, paramExtractor, paramIndex));
                            }
                        }
                        catch (IOException | XBProcessingException ex) {
                            Logger.getLogger(ParametersEditor.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        XBCXName typeName = nameService.getDefaultItemName((XBCItem)rowSpec);
                        specType = typeName.getText();
                    }
                }
                ParametersTableItem itemRecord = new ParametersTableItem(specDef, specName, specType, lineEditor);
                itemRecord.setTypeName(itemRecord.getDefTypeName());
                this.parametersTableModel.addRow(itemRecord);
                ++paramIndex;
            }
        }
        this.parametersTableModel.fireTableDataChanged();
    }

    private XBRowEditor getCustomEditor(XBCBlockRev rev, XBCXUiService uiService) {
        if (rev == null || this.catalog == null) {
            return null;
        }
        XBCXBlockUi blockUi = uiService.findUiByPR(rev, XBPlugUiType.ROW_EDITOR, 0L);
        if (blockUi == null) {
            return null;
        }
        XBCXPlugUi plugUi = blockUi.getUi();
        if (plugUi == null) {
            return null;
        }
        XBCXPlugin plugin = plugUi.getPlugin();
        XBCatalogPlugin pluginHandler = this.pluginRepository.getPluginHandler(plugin);
        if (pluginHandler == null) {
            return null;
        }
        return ((XBRowEditorCatalogPlugin)pluginHandler).getRowEditor(plugUi.getMethodIndex());
    }

    @ParametersAreNonnullByDefault
    private class ComponentEditorChangeListener
    implements XBRowEditor.ChangeListener {
        private final XBATreeParamExtractor paramExtractor;
        private final int parameterIndex;
        private final XBRowEditor lineEditor;

        private ComponentEditorChangeListener(XBRowEditor lineEditor, XBATreeParamExtractor paramExtractor, int parameterIndex) {
            this.lineEditor = lineEditor;
            this.paramExtractor = paramExtractor;
            this.parameterIndex = parameterIndex;
        }

        public void valueChanged() {
            this.paramExtractor.setParameterIndex(this.parameterIndex);
            XBPSerialWriter serialWriter = new XBPSerialWriter((XBTEventListener)this.paramExtractor);
            serialWriter.write((XBSerializable)this.lineEditor);
        }
    }
}

