/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.def;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.component.action.DefaultEditItemActions;
import org.exbin.framework.component.api.ActionsProvider;
import org.exbin.framework.component.api.toolbar.EditItemActionsHandler;
import org.exbin.framework.component.api.toolbar.EditItemActionsUpdateListener;
import org.exbin.framework.editor.xbup.def.action.AddAttributeAction;
import org.exbin.framework.editor.xbup.def.action.RemoveAttributesAction;
import org.exbin.framework.editor.xbup.def.gui.AttributesPanel;
import org.exbin.framework.editor.xbup.def.model.AttributesTableModel;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.xbup.core.block.XBFixedBlockType;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.ubnumber.type.UBNat32;
import org.exbin.xbup.parser_tree.XBTTreeNode;

@ParametersAreNonnullByDefault
public class AttributesEditor {
    private AttributesPanel editorPanel = new AttributesPanel();
    private final AttributesTableModel attributesTableModel = new AttributesTableModel();
    private final DefaultEditItemActions editActions;
    private XBApplication application;
    private XBACatalog catalog;
    private JPopupMenu popupMenu;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(AttributesEditor.class);
    private AddAttributeAction addAttributeAction = new AddAttributeAction();
    private RemoveAttributesAction removeAttributesAction = new RemoveAttributesAction();

    public AttributesEditor() {
        this.editActions = new DefaultEditItemActions(DefaultEditItemActions.Mode.DIALOG);
        this.editActions.setEditItemActionsHandler(new EditItemActionsHandler(){

            public void performAddItem() {
                AttributesEditor.this.addAttributeAction.actionPerformed(null);
                JTable attributesTable = AttributesEditor.this.editorPanel.getAttributesTable();
                AttributesEditor.this.attributesTableModel.getAttribs().add((XBAttribute)new UBNat32());
                AttributesEditor.this.attributesTableModel.fireTableDataChanged();
                attributesTable.revalidate();
            }

            public void performEditItem() {
            }

            public void performDeleteItem() {
                AttributesEditor.this.removeAttributesAction.actionPerformed(null);
                JTable attributesTable = AttributesEditor.this.editorPanel.getAttributesTable();
                int[] selectedRows = attributesTable.getSelectedRows();
                if (selectedRows.length > 0) {
                    Arrays.sort(selectedRows);
                    for (int index = selectedRows.length - 1; index >= 0; --index) {
                        AttributesEditor.this.attributesTableModel.getAttribs().remove(selectedRows[index]);
                    }
                    AttributesEditor.this.attributesTableModel.fireTableDataChanged();
                    attributesTable.clearSelection();
                    attributesTable.revalidate();
                }
            }

            public boolean canAddItem() {
                return true;
            }

            public boolean canEditItem() {
                return false;
            }

            public boolean canDeleteItem() {
                return AttributesEditor.this.editorPanel.getSelectedRow() != null;
            }

            public void setUpdateListener(@Nonnull EditItemActionsUpdateListener updateListener) {
                AttributesEditor.this.editorPanel.addSelectionListener(updateListener);
            }
        });
        this.popupMenu = new JPopupMenu();
        JMenuItem addAttributeMenuItem = ActionUtils.actionToMenuItem((Action)this.editActions.getAddItemAction());
        addAttributeMenuItem.setText(this.resourceBundle.getString("addAttributeMenuItem.text") + "...");
        this.popupMenu.add(addAttributeMenuItem);
        JMenuItem editAttributeMenuItem = ActionUtils.actionToMenuItem((Action)this.editActions.getEditItemAction());
        editAttributeMenuItem.setText(this.resourceBundle.getString("editAttributeMenuItem.text") + "...");
        this.popupMenu.add(editAttributeMenuItem);
        this.editorPanel.setPanelPopup(this.popupMenu);
        this.editorPanel.setAttributesTableModel(this.attributesTableModel);
        this.editorPanel.addActions((ActionsProvider)this.editActions);
    }

    @Nonnull
    public AttributesPanel getEditorPanel() {
        return this.editorPanel;
    }

    public void setApplication(XBApplication application) {
        this.application = application;
        this.editorPanel.setApplication(application);
        this.addAttributeAction.setup(application);
        this.removeAttributesAction.setup(application);
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
        this.editorPanel.setCatalog(catalog);
        this.addAttributeAction.setCatalog(catalog);
        this.removeAttributesAction.setCatalog(catalog);
    }

    public void setBlock(XBTTreeNode block) {
        ArrayList<XBAttribute> attributes = new ArrayList<XBAttribute>();
        XBFixedBlockType fixedBlockType = block.getFixedBlockType();
        attributes.add((XBAttribute)fixedBlockType.getGroupID());
        if (!block.getSingleAttributeType()) {
            attributes.add((XBAttribute)fixedBlockType.getBlockID());
            attributes.addAll(Arrays.asList(block.getAttributes()));
        }
        this.attributesTableModel.setAttribs(attributes);
        this.attributesTableModel.fireTableDataChanged();
    }
}

