/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.action;

import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.editor.xbup.viewer.XbupEditorProvider;
import org.exbin.framework.editor.xbup.viewer.XbupFileHandler;
import org.exbin.framework.utils.ActionUtils;

@ParametersAreNonnullByDefault
public class SampleFilesActions {
    public static final String SAMPLE_HTML_FILE_ACTION_ID = "sampleHtmlFileAction";
    public static final String SAMPLE_PICTURE_FILE_ACTION_ID = "samplePictureFileAction";
    public static final String SAMPLE_TYPES_FILE_ACTION_ID = "sampleTypesFileAction";
    private static final String SAMPLE_FILES_DIR = "/org/exbin/framework/editor/xbup/resources/samples/";
    private EditorProvider editorProvider;
    private XBApplication application;
    private ResourceBundle resourceBundle;
    private Action sampleHtmlFileAction;
    private Action samplePictureFileAction;
    private Action sampleTypesFileAction;

    public void setup(XBApplication application, EditorProvider editorProvider, ResourceBundle resourceBundle) {
        this.application = application;
        this.editorProvider = editorProvider;
        this.resourceBundle = resourceBundle;
    }

    @Nonnull
    public Action getSampleHtmlFileAction() {
        if (this.sampleHtmlFileAction == null) {
            this.sampleHtmlFileAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SampleFilesActions.this.editorProvider instanceof XbupEditorProvider) {
                        XbupEditorProvider provider = (XbupEditorProvider)SampleFilesActions.this.editorProvider;
                        provider.newFile();
                        XbupFileHandler xbupFile = (XbupFileHandler)provider.getActiveFile().get();
                        xbupFile.loadFromResourcePath(this.getClass(), "/org/exbin/framework/editor/xbup/resources/samples/xhtml_example.xb");
                    }
                }
            };
            ActionUtils.setupAction((Action)this.sampleHtmlFileAction, (ResourceBundle)this.resourceBundle, (String)SAMPLE_HTML_FILE_ACTION_ID);
        }
        return this.sampleHtmlFileAction;
    }

    @Nonnull
    public Action getSamplePictureFileAction() {
        if (this.samplePictureFileAction == null) {
            this.samplePictureFileAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SampleFilesActions.this.editorProvider instanceof XbupEditorProvider) {
                        XbupEditorProvider provider = (XbupEditorProvider)SampleFilesActions.this.editorProvider;
                        provider.newFile();
                        XbupFileHandler xbupFile = (XbupFileHandler)provider.getActiveFile().get();
                        xbupFile.loadFromResourcePath(this.getClass(), "/org/exbin/framework/editor/xbup/resources/samples/xblogo.xbp");
                    }
                }
            };
            ActionUtils.setupAction((Action)this.samplePictureFileAction, (ResourceBundle)this.resourceBundle, (String)SAMPLE_PICTURE_FILE_ACTION_ID);
        }
        return this.samplePictureFileAction;
    }

    @Nonnull
    public Action getSampleTypesFileAction() {
        if (this.sampleTypesFileAction == null) {
            this.sampleTypesFileAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SampleFilesActions.this.editorProvider instanceof XbupEditorProvider) {
                        XbupEditorProvider provider = (XbupEditorProvider)SampleFilesActions.this.editorProvider;
                        provider.newFile();
                        XbupFileHandler xbupFile = (XbupFileHandler)provider.getActiveFile().get();
                        xbupFile.loadFromResourcePath(this.getClass(), "/org/exbin/framework/editor/xbup/resources/samples/xbtypes.xb");
                    }
                }
            };
            ActionUtils.setupAction((Action)this.sampleTypesFileAction, (ResourceBundle)this.resourceBundle, (String)SAMPLE_TYPES_FILE_ACTION_ID);
        }
        return this.sampleTypesFileAction;
    }
}

