/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.action;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.xbup.BlockEditor;
import org.exbin.framework.editor.xbup.viewer.XbupEditorProvider;
import org.exbin.framework.editor.xbup.viewer.XbupFileHandler;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.DefaultControlPanel;
import org.exbin.framework.utils.handler.DefaultControlHandler;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.block.XBTEditableBlock;
import org.exbin.xbup.core.block.XBTEditableDocument;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.type.XBData;
import org.exbin.xbup.operation.Command;
import org.exbin.xbup.operation.Operation;
import org.exbin.xbup.operation.basic.XBTModifyBlockOperation;
import org.exbin.xbup.operation.basic.XBTTailDataOperation;
import org.exbin.xbup.operation.basic.command.XBTChangeBlockCommand;
import org.exbin.xbup.operation.basic.command.XBTModifyBlockCommand;
import org.exbin.xbup.operation.undo.XBUndoHandler;
import org.exbin.xbup.parser_tree.XBTTreeDocument;
import org.exbin.xbup.parser_tree.XBTTreeNode;
import org.exbin.xbup.plugin.XBPluginRepository;

@ParametersAreNonnullByDefault
public class EditItemAction
extends AbstractAction {
    public static final String ACTION_ID = "editItemAction";
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(EditItemAction.class);
    private XbupEditorProvider editorProvider;

    public void setup(XbupEditorProvider editorProvider) {
        this.editorProvider = editorProvider;
        ActionUtils.setupAction((Action)this, (ResourceBundle)this.resourceBundle, (String)ACTION_ID);
        this.putValue("dialogMode", true);
        this.setEnabled(false);
        editorProvider.addItemSelectionListener(item -> this.setEnabled(item != null));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        XBApplication application = this.editorProvider.getApplication();
        XBACatalog catalog = this.editorProvider.getCatalog();
        XbupFileHandler xbupFile = (XbupFileHandler)this.editorProvider.getActiveFile().get();
        XBUndoHandler undoHandler = xbupFile.getUndoHandler();
        XBTTreeDocument mainDoc = xbupFile.getDocument();
        XBPluginRepository pluginRepository = this.editorProvider.getPluginRepository();
        FrameModuleApi frameModule = (FrameModuleApi)application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        XBTBlock block = xbupFile.getSelectedItem().get();
        if (!(block instanceof XBTTreeNode)) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        XBTTreeNode node = (XBTTreeNode)block;
        BlockEditor blockEditor = new BlockEditor();
        blockEditor.setApplication(application);
        blockEditor.setCatalog(catalog);
        blockEditor.setPluginRepository(pluginRepository);
        blockEditor.setBlock(node);
        JComponent component = blockEditor.getPanel();
        DefaultControlPanel controlPanel = new DefaultControlPanel();
        WindowUtils.DialogWrapper dialog = frameModule.createDialog(component, (JPanel)controlPanel);
        WindowUtils.addHeaderPanel((Window)dialog.getWindow(), BlockEditor.class, (ResourceBundle)blockEditor.getResourceBundle());
        frameModule.setDialogTitle(dialog, blockEditor.getResourceBundle());
        controlPanel.setHandler(actionType -> {
            if (actionType == DefaultControlHandler.ControlActionType.OK) {
                XBTChangeBlockCommand undoStep;
                XBTTreeNode newNode = blockEditor.getBlock();
                if (node.getParent() == null) {
                    undoStep = new XBTChangeBlockCommand((XBTEditableDocument)mainDoc);
                    long position = node.getBlockIndex();
                    XBTModifyBlockOperation modifyOperation = new XBTModifyBlockOperation((XBTEditableDocument)mainDoc, position, (XBTEditableBlock)newNode);
                    undoStep.appendOperation((Operation)modifyOperation);
                    XBData tailData = new XBData();
                    XBTTailDataOperation extOperation = new XBTTailDataOperation((XBTEditableDocument)mainDoc, tailData);
                    undoStep.appendOperation((Operation)extOperation);
                } else {
                    undoStep = new XBTModifyBlockCommand((XBTEditableDocument)mainDoc, node, newNode);
                }
                try {
                    undoHandler.execute((Command)undoStep);
                }
                catch (Exception ex) {
                    Logger.getLogger(EditItemAction.class.getName()).log(Level.SEVERE, null, ex);
                }
                xbupFile.notifyItemModified(node);
            }
            dialog.close();
            dialog.dispose();
        });
        dialog.showCentered((Component)this.editorProvider.getEditorComponent());
    }
}

