/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.file.api;

import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.framework.file.api.FileType;
import org.exbin.framework.file.api.FileTypes;

@ParametersAreNonnullByDefault
public class DefaultFileTypes
implements FileTypes {
    private final Collection<FileType> fileTypes;

    public DefaultFileTypes(Collection<FileType> fileTypes) {
        this.fileTypes = fileTypes;
    }

    @Override
    public boolean allowAllFiles() {
        return this.fileTypes.isEmpty();
    }

    @Override
    @Nonnull
    public Optional<FileType> getFileType(String fileTypeId) {
        return this.fileTypes.stream().filter(t -> fileTypeId.equals(t.getFileTypeId())).findFirst();
    }

    @Override
    @Nonnull
    public Collection<FileType> getFileTypes() {
        return this.fileTypes;
    }
}

