/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.catalog.entity.service;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import org.exbin.xbup.catalog.XBECatalog;
import org.exbin.xbup.catalog.entity.XBEXName;
import org.exbin.xbup.catalog.entity.manager.XBEXNameManager;
import org.exbin.xbup.catalog.entity.service.XBEDefaultService;
import org.exbin.xbup.core.catalog.base.XBCExtension;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCXLanguage;
import org.exbin.xbup.core.catalog.base.XBCXName;
import org.exbin.xbup.core.catalog.base.manager.XBCXLangManager;
import org.exbin.xbup.core.catalog.base.manager.XBCXNameManager;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class XBEXNameService
extends XBEDefaultService<XBCXName>
implements XBCXNameService,
Serializable {
    @Autowired
    private XBEXNameManager manager;

    public XBEXNameService() {
    }

    public XBEXNameService(XBECatalog catalog) {
        super(catalog);
        this.itemManager = new XBEXNameManager(catalog);
        catalog.addCatalogManager(XBCXNameManager.class, (XBCXNameManager)this.itemManager);
    }

    @PostConstruct
    public void init() {
        this.itemManager = this.manager;
    }

    public XBEXName getDefaultItemName(XBCItem item) {
        return ((XBEXNameManager)this.itemManager).getDefaultItemName(item);
    }

    public XBEXName getItemName(XBCItem item, XBCXLanguage language) {
        return ((XBEXNameManager)this.itemManager).getItemName(item, language);
    }

    public List<XBCXName> getItemNames(XBCItem item) {
        return ((XBEXNameManager)this.itemManager).getItemNames(item);
    }

    public String getExtensionName() {
        return ((XBCExtension)this.itemManager).getExtensionName();
    }

    public void initializeExtension() {
        ((XBCExtension)this.itemManager).initializeExtension();
    }

    public String getDefaultText(XBCItem item) {
        return ((XBEXNameManager)this.itemManager).getDefaultText(item);
    }

    public void setDefaultText(XBCItem item, String text) {
        XBEXName name = this.getDefaultItemName(item);
        if (text == null || text.isEmpty()) {
            if (name != null) {
                this.removeItem(name);
            }
        } else {
            if (name == null) {
                XBCXLangManager langManager = this.catalog.getCatalogManager(XBCXLangManager.class);
                name = (XBEXName)this.createItem();
                name.setItem(item);
                name.setLang(langManager.getDefaultLang());
            }
            name.setText(text);
            this.persistItem(name);
        }
    }

    public String getItemNamePath(@Nullable XBCItem item) {
        if (item == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.getDefaultText(item));
        Optional optionalParent = item.getParentItem();
        while (optionalParent.isPresent() && ((XBCItem)optionalParent.get()).getParentItem().isPresent()) {
            XBCItem parentItem = (XBCItem)optionalParent.get();
            builder.insert(0, this.getDefaultText(parentItem) + ".");
            optionalParent = parentItem.getParentItem();
        }
        return builder.toString();
    }
}

