/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.catalog.entity.manager;

import java.io.Serializable;
import java.util.Date;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.NoResultException;
import org.exbin.xbup.catalog.XBECatalog;
import org.exbin.xbup.catalog.entity.XBENode;
import org.exbin.xbup.catalog.entity.XBERoot;
import org.exbin.xbup.catalog.entity.manager.XBEDefaultCatalogManager;
import org.exbin.xbup.core.catalog.base.XBCBase;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCRoot;
import org.exbin.xbup.core.catalog.base.manager.XBCNodeManager;
import org.exbin.xbup.core.catalog.base.manager.XBCRootManager;
import org.springframework.stereotype.Repository;

@ParametersAreNonnullByDefault
@Repository
public class XBERootManager
extends XBEDefaultCatalogManager<XBCRoot>
implements XBCRootManager,
Serializable {
    public XBERootManager() {
    }

    public XBERootManager(XBECatalog catalog) {
        super(catalog);
    }

    @Override
    @Nonnull
    public Class getEntityClass() {
        return XBERoot.class;
    }

    @Nonnull
    public XBERoot getMainRoot() {
        try {
            return (XBERoot)this.em.createQuery("SELECT object(o) FROM XBRoot AS o WHERE o.url IS NULL").getSingleResult();
        }
        catch (NoResultException e) {
            throw new IllegalStateException("Missing main root", e);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Missing main root", ex);
        }
    }

    @Nonnull
    public Optional<Date> getMainLastUpdate() {
        try {
            return Optional.ofNullable((Date)this.em.createQuery("SELECT o.lastUpdate FROM XBRoot AS o WHERE o.url IS NULL").getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
        catch (Exception ex) {
            Logger.getLogger(XBERootManager.class.getName()).log(Level.SEVERE, null, ex);
            return Optional.empty();
        }
    }

    public void setMainLastUpdate(Date updateDate) {
        try {
            this.em.createQuery("UPDATE XBRoot AS o SET o.lastUpdate = " + updateDate.getTime() + " WHERE o.url IS NULL").executeUpdate();
        }
        catch (Exception ex) {
            Logger.getLogger(XBERootManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setMainLastUpdateToNow() {
        try {
            this.em.createQuery("UPDATE XBRoot AS o SET o.lastUpdate = CURRENT_TIMESTAMP WHERE o.url IS NULL").executeUpdate();
        }
        catch (Exception ex) {
            Logger.getLogger(XBERootManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean isMainPresent() {
        try {
            this.em.createQuery("SELECT 1 FROM XBRoot AS o WHERE o.url IS NULL").getSingleResult();
            return true;
        }
        catch (NoResultException e) {
            return false;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Missing main root", ex);
        }
    }

    @Nonnull
    public XBERoot createEmptyRoot(String catalogUrl) {
        XBCNodeManager nodeManager = this.catalog.getCatalogManager(XBCNodeManager.class);
        EntityManager em = this.catalog.getEntityManager();
        EntityTransaction transaction = em.getTransaction();
        transaction.begin();
        XBERoot catalogRoot = (XBERoot)this.createItem();
        catalogRoot.setUrl(catalogUrl);
        catalogRoot.setLastUpdate(new Date());
        XBENode rootNode = (XBENode)nodeManager.createItem();
        catalogRoot.setNode(rootNode);
        nodeManager.persistItem((XBCBase)rootNode);
        this.persistItem(catalogRoot);
        em.flush();
        transaction.commit();
        return catalogRoot;
    }

    public void removeFully(XBCRoot root) {
        XBCNodeManager nodeManager = this.catalog.getCatalogManager(XBCNodeManager.class);
        EntityManager em = this.catalog.getEntityManager();
        EntityTransaction transaction = em.getTransaction();
        transaction.begin();
        XBCNode node = root.getNode();
        this.removeItem(root);
        nodeManager.removeNodeFully(node);
        em.flush();
        transaction.commit();
    }

    @Override
    public boolean initCatalog() {
        XBENode node = new XBENode();
        node.setXBIndex(0L);
        node.setParent(null);
        this.em.persist((Object)node);
        XBERoot root = new XBERoot();
        root.setNode(node);
        this.em.persist((Object)root);
        return true;
    }
}

