/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.catalog.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.exbin.xbup.catalog.entity.XBENode;
import org.exbin.xbup.catalog.modifiable.XBMRoot;
import org.exbin.xbup.core.catalog.base.XBCNode;

@ParametersAreNonnullByDefault
@Entity(name="XBRoot")
@Inheritance(strategy=InheritanceType.JOINED)
public class XBERoot
implements XBMRoot,
Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    protected Long id;
    @ManyToOne
    private XBENode node;
    @Nullable
    private String url;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastUpdate;

    public long getId() {
        if (this.id == null) {
            return 0L;
        }
        return this.id;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof XBERoot)) {
            return false;
        }
        XBERoot other = (XBERoot)object;
        return this.id == other.id || this.id != null && this.id.equals(other.id);
    }

    public String toString() {
        return "org.exbin.xbup.catalog.entity.Item[id=" + this.id + "]";
    }

    @Nonnull
    public XBENode getNode() {
        return this.node;
    }

    @Override
    public void setNode(XBCNode node) {
        this.node = (XBENode)node;
    }

    @Nonnull
    public Optional<String> getUrl() {
        return Optional.ofNullable(this.url);
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Nonnull
    public Optional<Date> getLastUpdate() {
        return Optional.ofNullable(this.lastUpdate);
    }

    @Override
    public void setLastUpdate(@Nullable Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }
}

