/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.catalog.entity;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import org.exbin.xbup.catalog.modifiable.XBMItem;
import org.exbin.xbup.core.catalog.base.XBCItem;

@ParametersAreNonnullByDefault
@Entity(name="XBItem")
@Inheritance(strategy=InheritanceType.JOINED)
public class XBEItem
implements XBMItem,
Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    protected Long id;
    private Long xbIndex;
    @Nullable
    @ManyToOne
    @JoinColumn(name="OWNER_ID")
    private XBEItem parent;

    public long getId() {
        if (this.id == null) {
            return 0L;
        }
        return this.id;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof XBEItem)) {
            return false;
        }
        XBEItem other = (XBEItem)object;
        return Objects.equals(this.id, other.id) || this.id != null && this.id.equals(other.id);
    }

    @Nonnull
    public String toString() {
        return "org.exbin.xbup.catalog.entity.Item[id=" + this.id + "]";
    }

    public long getXBIndex() {
        return this.xbIndex == null ? 0L : this.xbIndex;
    }

    @Override
    public void setXBIndex(long xbIndex) {
        this.xbIndex = xbIndex;
    }

    @Nonnull
    public Optional<XBCItem> getParentItem() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    public void setParentItem(@Nullable XBCItem parent) {
        this.parent = (XBEItem)parent;
    }
}

