/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.action;

import java.awt.Component;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.api.EditorActionsApi;
import org.exbin.framework.editor.api.MultiEditorProvider;
import org.exbin.framework.editor.gui.UnsavedFilesPanel;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class EditorActions
implements EditorActionsApi {
    private ResourceBundle resourceBundle;
    private XBApplication application;
    private MultiEditorProvider editorProvider;

    public void setup(XBApplication application, ResourceBundle resourceBundle, MultiEditorProvider editorProvider) {
        this.application = application;
        this.resourceBundle = resourceBundle;
        this.editorProvider = editorProvider;
    }

    public boolean showAskForSaveDialog(List<FileHandler> fileHandlers) {
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        UnsavedFilesPanel unsavedFilesPanel = new UnsavedFilesPanel();
        unsavedFilesPanel.setUnsavedFiles(fileHandlers);
        final boolean[] result = new boolean[1];
        final WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)unsavedFilesPanel);
        unsavedFilesPanel.setController(new UnsavedFilesPanel.Controller(){

            @Override
            public boolean saveFile(FileHandler fileHandler) {
                EditorActions.this.editorProvider.saveFile(fileHandler);
                return !fileHandler.isModified();
            }

            @Override
            public void discardAll(List<FileHandler> fileHandlers) {
                result[0] = true;
                dialog.close();
            }

            @Override
            public void cancel() {
                result[0] = false;
                dialog.close();
            }
        });
        frameModule.setDialogTitle(dialog, unsavedFilesPanel.getResourceBundle());
        unsavedFilesPanel.assignGlobalKeys();
        dialog.showCentered((Component)this.editorProvider.getEditorComponent());
        return result[0];
    }
}

