/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.ui;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.accept.DockAcceptance;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.group.CGroupMovement;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.station.CommonDockStation;
import bibliothek.gui.dock.common.mode.CLocationMode;
import bibliothek.gui.dock.common.mode.CLocationModeManager;
import bibliothek.gui.dock.common.mode.ExtendedMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkingAreaAcceptance
implements DockAcceptance {
    private CControlAccess control;

    public WorkingAreaAcceptance(CControlAccess control) {
        this.control = control;
    }

    public boolean accept(DockStation parent, Dockable child, Dockable next) {
        return this.accept(parent, next);
    }

    public boolean accept(DockStation parent, Dockable child) {
        CGroupMovement action;
        CLocationModeManager manager = this.control.getLocationManager();
        if (manager.isOnTransaction() && ((action = manager.getCurrentAction()) == null || action.forceAccept(parent, child))) {
            return true;
        }
        ExtendedMode extendedMode = manager.childsExtendedMode(parent);
        if (extendedMode == null && (extendedMode = manager.getMode(child)) == null) {
            return true;
        }
        CLocationMode mode = (CLocationMode)manager.getMode(extendedMode.getModeIdentifier());
        if (mode == null) {
            return true;
        }
        if (!mode.respectWorkingAreas(parent)) {
            return true;
        }
        CStation<?> area = this.searchArea((DockElement)parent);
        return this.match(area, child);
    }

    private CStation<?> searchArea(DockElement element) {
        DockStation station = element.asDockStation();
        Dockable dockable = element.asDockable();
        while (dockable != null || station != null) {
            CStation cstation;
            if (station != null && station instanceof CommonDockStation && (cstation = ((CommonDockStation)station).getStation()).isWorkingArea()) {
                return cstation;
            }
            dockable = station == null ? null : station.asDockable();
            station = dockable == null ? null : dockable.getDockParent();
        }
        return null;
    }

    private boolean match(CStation<?> area, Dockable dockable) {
        CDockable fdockable;
        CStation<?> request;
        if (dockable instanceof CommonDockable && (request = (fdockable = ((CommonDockable)dockable).getDockable()).getWorkingArea()) != area) {
            return false;
        }
        DockStation station = dockable.asDockStation();
        if (station != null) {
            CStation<?> cstation;
            if (dockable instanceof CommonDockable && (cstation = ((CommonDockable)dockable).getStation()) != null && cstation.isWorkingArea()) {
                return true;
            }
            return this.match(area, station);
        }
        return true;
    }

    private boolean match(CStation<?> area, DockStation station) {
        int n = station.getDockableCount();
        for (int i = 0; i < n; ++i) {
            boolean result = this.match(area, station.getDockable(i));
            if (result) continue;
            return false;
        }
        return true;
    }
}

