/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.color;

import bibliothek.gui.dock.common.intern.color.TabColorTransmitter;
import bibliothek.gui.dock.themes.ColorBridgeFactory;
import bibliothek.gui.dock.util.color.ColorManager;
import bibliothek.util.Colors;
import java.awt.Color;

public class EclipseTabTransmitter
extends TabColorTransmitter {
    public static final ColorBridgeFactory FACTORY = new ColorBridgeFactory(){

        public EclipseTabTransmitter create(ColorManager manager) {
            return new EclipseTabTransmitter(manager);
        }
    };
    private static final String[] KEYS = new String[]{"stack.tab.border", "stack.tab.border.selected", "stack.tab.border.selected.focused", "stack.tab.border.selected.focuslost", "stack.tab.top", "stack.tab.top.selected", "stack.tab.top.selected.focused", "stack.tab.top.selected.focuslost", "stack.tab.bottom", "stack.tab.bottom.selected", "stack.tab.bottom.selected.focused", "stack.tab.bottom.selected.focuslost", "stack.tab.text", "stack.tab.text.selected", "stack.tab.text.selected.focused", "stack.tab.text.selected.focuslost"};

    public EclipseTabTransmitter(ColorManager manager) {
        super(manager, KEYS);
    }

    protected boolean isFocused(String id) {
        return id.contains("focused") || id.contains("focuslost");
    }

    protected boolean isSelected(String id) {
        return id.contains("selected");
    }

    protected boolean isForeground(String id) {
        return id.contains("text");
    }

    protected Color convert(Color source, String key) {
        if (this.isSelected(key)) {
            return this.convertSelected(source, key);
        }
        if (this.isFocused(key)) {
            return this.convertFocused(source, key);
        }
        if ("stack.tab.border".equals(key)) {
            return source;
        }
        if ("stack.tab.top".equals(key)) {
            return Colors.undiffMirror((Color)source, (double)0.5);
        }
        if ("stack.tab.bottom".equals(key)) {
            return source;
        }
        if ("stack.tab.text".equals(key)) {
            return Colors.diffMirror((Color)source, (double)1.0);
        }
        return null;
    }

    protected Color convertSelected(Color source, String key) {
        if (this.isFocused(key)) {
            return this.convertFocused(source, key);
        }
        if ("stack.tab.border.selected".equals(key)) {
            return source;
        }
        if ("stack.tab.top.selected".equals(key)) {
            return Colors.undiffMirror((Color)source, (double)0.5);
        }
        if ("stack.tab.bottom.selected".equals(key)) {
            return source;
        }
        if ("stack.tab.text.selected".equals(key)) {
            return Colors.diffMirror((Color)source, (double)1.0);
        }
        return null;
    }

    protected Color convertFocused(Color source, String key) {
        if ("stack.tab.border.selected.focused".equals(key)) {
            return source;
        }
        if ("stack.tab.border.selected.focuslost".equals(key)) {
            return source;
        }
        if ("stack.tab.top.selected.focused".equals(key)) {
            return Colors.undiffMirror((Color)source, (double)0.5);
        }
        if ("stack.tab.top.selected.focuslost".equals(key)) {
            return Colors.undiffMirror((Color)source, (double)0.5);
        }
        if ("stack.tab.bottom.selected.focused".equals(key)) {
            return source;
        }
        if ("stack.tab.bottom.selected.focuslost".equals(key)) {
            return source;
        }
        if ("stack.tab.text.selected.focused".equals(key)) {
            return Colors.diffMirror((Color)source, (double)1.0);
        }
        if ("stack.tab.text.selected.focuslost".equals(key)) {
            return Colors.diffMirror((Color)source, (double)1.0);
        }
        return null;
    }
}

