/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab;

import bibliothek.gui.dock.station.stack.tab.AbstractTabLayoutManager;
import bibliothek.gui.dock.station.stack.tab.AxisConversion;
import bibliothek.gui.dock.station.stack.tab.DefaultAxisConversion;
import bibliothek.gui.dock.station.stack.tab.DefaultMenuLineLayoutFactory;
import bibliothek.gui.dock.station.stack.tab.DefaultMenuLineLayoutStrategy;
import bibliothek.gui.dock.station.stack.tab.MenuLineLayoutFactory;
import bibliothek.gui.dock.station.stack.tab.MenuLineLayoutPane;
import bibliothek.gui.dock.station.stack.tab.MenuLineLayoutStrategy;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.layouting.LayoutBlock;
import bibliothek.gui.dock.station.stack.tab.layouting.Size;
import java.awt.Dimension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuLineLayout
extends AbstractTabLayoutManager<MenuLineLayoutPane> {
    private MenuLineLayoutFactory factory = new DefaultMenuLineLayoutFactory();
    private MenuLineLayoutStrategy strategy = new DefaultMenuLineLayoutStrategy();

    public void setFactory(MenuLineLayoutFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        this.factory = factory;
    }

    public MenuLineLayoutFactory getFactory() {
        return this.factory;
    }

    public void setStrategy(MenuLineLayoutStrategy strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException("strategy must not be null");
        }
        this.strategy = strategy;
    }

    public MenuLineLayoutStrategy getStrategy() {
        return this.strategy;
    }

    @Override
    protected MenuLineLayoutPane createInfoFor(TabPane pane) {
        return new MenuLineLayoutPane(this, pane);
    }

    @Override
    protected void destroy(MenuLineLayoutPane info) {
        info.destroy();
    }

    @Override
    public Dimension getMinimumSize(TabPane pane) {
        MenuLineLayoutPane layout = (MenuLineLayoutPane)this.getInfo(pane);
        if (layout == null) {
            throw new IllegalArgumentException("unknown pane");
        }
        return layout.getMinimumSize();
    }

    @Override
    public Dimension getPreferredSize(TabPane pane) {
        MenuLineLayoutPane layout = (MenuLineLayoutPane)this.getInfo(pane);
        if (layout == null) {
            throw new IllegalArgumentException("unknown pane");
        }
        return layout.getPreferredSize();
    }

    @Override
    public void layout(TabPane pane) {
        MenuLineLayoutPane layout = (MenuLineLayoutPane)this.getInfo(pane);
        if (layout == null) {
            throw new IllegalArgumentException("unknown pane");
        }
        layout.layout();
    }

    protected Size[] getSizes(LayoutBlock block, Size.Type type) {
        if (block == null) {
            return new Size[0];
        }
        Size[] sizes = block.getSizes();
        if (sizes == null) {
            return new Size[0];
        }
        return this.getSizes(sizes, type);
    }

    protected Size[] getSizes(Size[] choices, Size.Type type) {
        int count = 0;
        for (Size size : choices) {
            if (size.getType() != type) continue;
            ++count;
        }
        Size[] result = new Size[count];
        int index = 0;
        for (Size size : choices) {
            if (size.getType() != type) continue;
            result[index++] = size;
        }
        return result;
    }

    protected AxisConversion getConversion(TabPane pane) {
        return new DefaultAxisConversion(pane.getAvailableArea(), pane.getDockTabPlacement());
    }
}

