/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.station.split.Divideable;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.PutInfo;
import bibliothek.gui.dock.station.split.Root;
import bibliothek.gui.dock.station.split.SplitDockAccess;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockPlaceholderProperty;
import bibliothek.gui.dock.station.split.SplitDockTree;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.station.split.SplitNodeVisitor;
import bibliothek.gui.dock.station.split.SplitTreeFactory;
import bibliothek.gui.dock.station.split.VisibleSplitNode;
import bibliothek.util.Path;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node
extends VisibleSplitNode
implements Divideable {
    private SplitNode left;
    private SplitNode right;
    private double divider = 0.5;
    private SplitDockStation.Orientation orientation = SplitDockStation.Orientation.VERTICAL;
    private Rectangle dividerBounds = new Rectangle();
    private boolean visible;
    private boolean visibleCached = false;

    public Node(SplitDockAccess access, SplitNode left, SplitNode right, SplitDockStation.Orientation orientation) {
        this(access, left, right);
        this.orientation = orientation;
    }

    public Node(SplitDockAccess access, SplitNode left, SplitNode right, SplitDockStation.Orientation orientation, long id) {
        this(access, left, right, id);
        this.orientation = orientation;
    }

    public Node(SplitDockAccess access, SplitNode left, SplitNode right) {
        super(access, -1L);
        this.setRight(right);
        this.setLeft(left);
    }

    public Node(SplitDockAccess access, SplitNode left, SplitNode right, long id) {
        super(access, id);
        this.setRight(right);
        this.setLeft(left);
    }

    public Node(SplitDockAccess access) {
        super(access, -1L);
    }

    public Node(SplitDockAccess access, long id) {
        super(access, id);
    }

    public void setLeft(SplitNode left) {
        if (this.left != null) {
            this.left.setParent(null);
        }
        this.left = left;
        this.clearVisibility();
        if (left != null) {
            left.setParent(this);
        }
        this.treeChanged();
        if (left != null) {
            this.ensureIdUniqueAsync();
        }
        this.getAccess().getOwner().revalidate();
        this.getAccess().getOwner().repaint();
        this.getAccess().repositioned(this);
    }

    public SplitNode getLeft() {
        return this.left;
    }

    public void setRight(SplitNode right) {
        if (this.right != null) {
            this.right.setParent(null);
        }
        this.right = right;
        this.clearVisibility();
        if (right != null) {
            right.setParent(this);
        }
        this.treeChanged();
        if (right != null) {
            this.ensureIdUniqueAsync();
        }
        this.getAccess().getOwner().revalidate();
        this.getAccess().getOwner().repaint();
        this.getAccess().repositioned(this);
    }

    public SplitNode getRight() {
        return this.right;
    }

    @Override
    public int getChildLocation(SplitNode child) {
        if (this.left == child) {
            return 0;
        }
        if (this.right == child) {
            return 1;
        }
        return -1;
    }

    @Override
    public void setChild(SplitNode child, int location) {
        if (location == 0) {
            this.setLeft(child);
        } else if (location == 1) {
            this.setRight(child);
        } else {
            throw new IllegalArgumentException("Location not valid " + location);
        }
    }

    @Override
    public int getMaxChildrenCount() {
        return 2;
    }

    @Override
    public SplitNode getChild(int location) {
        switch (location) {
            case 0: {
                return this.getLeft();
            }
            case 1: {
                return this.getRight();
            }
        }
        return null;
    }

    @Override
    public SplitDockStation.Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(SplitDockStation.Orientation orientation) {
        if (orientation == null) {
            throw new NullPointerException("orientation must not be null");
        }
        this.orientation = orientation;
        this.getAccess().getOwner().revalidate();
    }

    @Override
    public Dimension getMinimumSize() {
        boolean leftVisible = this.left == null || this.left.isVisible();
        boolean rightVisible = this.right == null || this.right.isVisible();
        Dimension minLeft = leftVisible ? this.left.getMinimumSize() : null;
        Dimension minRight = rightVisible ? this.right.getMinimumSize() : null;
        return this.getSize(minLeft, minRight);
    }

    @Override
    public Dimension getPreferredSize() {
        boolean leftVisible = this.left == null || this.left.isVisible();
        boolean rightVisible = this.right == null || this.right.isVisible();
        Dimension minLeft = leftVisible ? this.left.getPreferredSize() : null;
        Dimension minRight = rightVisible ? this.right.getPreferredSize() : null;
        return this.getSize(minLeft, minRight);
    }

    private Dimension getSize(Dimension left, Dimension right) {
        if (left != null && right != null) {
            int divider = this.getAccess().getOwner().getDividerSize();
            if (this.orientation == SplitDockStation.Orientation.HORIZONTAL) {
                int onLeft = (int)((double)(left.width - divider / 2) / this.getDivider()) + divider;
                int onRight = (int)((double)(right.width - divider / 2) / (1.0 - this.getDivider())) + divider;
                return new Dimension(Math.max(onLeft, onRight), Math.max(left.height, right.height));
            }
            int onTop = (int)((double)(left.height - divider / 2) / this.getDivider()) + divider;
            int onBottom = (int)((double)(right.height - divider / 2) / (1.0 - this.getDivider())) + divider;
            return new Dimension(Math.max(left.width, right.width), Math.max(onTop, onBottom));
        }
        if (left != null) {
            return left;
        }
        if (right != null) {
            return right;
        }
        return new Dimension();
    }

    @Override
    public void setDivider(double divider) {
        if (this.divider != divider) {
            this.divider = divider;
            this.getAccess().getOwner().revalidate();
            this.getAccess().getOwner().repaint();
            this.getAccess().repositioned(this);
        }
    }

    @Override
    public double getDivider() {
        return this.divider;
    }

    @Override
    public double validateDivider(double divider) {
        return this.getStation().getCurrentSplitLayoutManager().validateDivider(this.getStation(), divider, this);
    }

    @Override
    public boolean isVisible() {
        if (!this.visibleCached) {
            this.visible = this.left == null || this.right == null || this.left.isVisible() || this.right.isVisible();
            this.visibleCached = true;
        }
        return this.visible;
    }

    private void clearVisibility() {
        this.visibleCached = false;
        SplitNode parent = this.getParent();
        if (parent instanceof Node) {
            ((Node)parent).clearVisibility();
        }
    }

    @Override
    public SplitNode getVisible() {
        if (this.left != null && this.right != null) {
            boolean leftVisible = this.left.isVisible();
            boolean rightVisible = this.right.isVisible();
            if (leftVisible && rightVisible) {
                return this;
            }
            if (leftVisible) {
                return this.left;
            }
            if (rightVisible) {
                return this.right;
            }
        }
        return null;
    }

    @Override
    public boolean isOfUse() {
        return true;
    }

    @Override
    public void updateBounds(double x, double y, double width, double height, double factorW, double factorH, boolean components) {
        boolean rightVisible;
        super.updateBounds(x, y, width, height, factorW, factorH, components);
        boolean leftVisible = this.left == null || this.left.isVisible();
        boolean bl = rightVisible = this.right == null || this.right.isVisible();
        if (leftVisible && !rightVisible) {
            this.left.updateBounds(x, y, width, height, factorW, factorH, components);
        } else if (!leftVisible && rightVisible) {
            this.right.updateBounds(x, y, width, height, factorW, factorH, components);
        } else if (leftVisible && rightVisible) {
            double divider = this.getAccess().validateDivider(this.divider, this);
            int dividerSize = this.getAccess().getOwner().getDividerSize();
            if (this.orientation == SplitDockStation.Orientation.HORIZONTAL) {
                double dividerWidth = factorW > 0.0 ? Math.max(0.0, (double)dividerSize / factorW) : 0.0;
                double dividerLocation = width * divider;
                if (this.left != null) {
                    this.left.updateBounds(x, y, dividerLocation - dividerWidth / 2.0, height, factorW, factorH, components);
                }
                if (this.right != null) {
                    this.right.updateBounds(x + dividerLocation + dividerWidth / 2.0, y, width - dividerLocation - dividerWidth / 2.0, height, factorW, factorH, components);
                }
            } else {
                double dividerHeight = factorH > 0.0 ? Math.max(0.0, (double)dividerSize / factorH) : 0.0;
                double dividerLocation = height * divider;
                if (this.left != null) {
                    this.left.updateBounds(x, y, width, dividerLocation - dividerHeight / 2.0, factorW, factorH, components);
                }
                if (this.right != null) {
                    this.right.updateBounds(x, y + dividerLocation + dividerHeight / 2.0, width, height - dividerLocation - dividerHeight / 2.0, factorW, factorH, components);
                }
            }
        }
    }

    @Override
    public void setBounds(double x, double y, double width, double height, double factorW, double factorH, boolean updateComponentBounds) {
        boolean rightVisible;
        super.setBounds(x, y, width, height, factorW, factorH, updateComponentBounds);
        boolean leftVisible = this.left == null || this.left.isVisible();
        boolean bl = rightVisible = this.right == null || this.right.isVisible();
        if (leftVisible && rightVisible) {
            double divider = this.getAccess().validateDivider(this.divider, this);
            int dividerSize = this.getAccess().getOwner().getDividerSize();
            if (this.orientation == SplitDockStation.Orientation.HORIZONTAL) {
                double dividerWidth = factorW > 0.0 ? Math.max(0.0, (double)dividerSize / factorW) : 0.0;
                double dividerLocation = width * divider;
                this.dividerBounds.setBounds((int)((x + dividerLocation - dividerWidth / 2.0) * factorW), (int)(y * factorH), dividerSize, (int)(height * factorH + 0.5));
            } else {
                double dividerHeight = factorH > 0.0 ? Math.max(0.0, (double)dividerSize / factorH) : 0.0;
                double dividerLocation = height * divider;
                this.dividerBounds.setBounds((int)(x * factorW), (int)((y + dividerLocation - dividerHeight / 2.0) * factorH), (int)(width * factorW + 0.5), dividerSize);
            }
        }
    }

    @Override
    public Rectangle getDividerBounds(double divider, Rectangle bounds) {
        if (bounds == null) {
            bounds = new Rectangle();
        }
        Root root = this.getRoot();
        double factorW = root.getWidthFactor();
        double factorH = root.getHeightFactor();
        int dividerSize = this.getAccess().getOwner().getDividerSize();
        if (this.orientation == SplitDockStation.Orientation.HORIZONTAL) {
            double dividerWidth = (double)dividerSize / factorW;
            double dividerLocation = this.width * divider;
            bounds.setBounds((int)((this.x + dividerLocation - dividerWidth / 2.0) * factorW + 0.5), (int)(this.y * factorH + 0.5), dividerSize, (int)(this.height * factorH + 0.5));
        } else {
            double dividerHeight = (double)dividerSize / factorH;
            double dividerLocation = this.height * divider;
            bounds.setBounds((int)(this.x * factorW + 0.5), (int)((this.y + dividerLocation - dividerHeight / 2.0) * factorH + 0.5), (int)(this.width * factorW + 0.5), dividerSize);
        }
        return bounds;
    }

    @Override
    public double getDividerAt(int x, int y) {
        Root root = this.getRoot();
        if (this.orientation == SplitDockStation.Orientation.HORIZONTAL) {
            double mx = (double)x / root.getWidthFactor();
            return (mx - this.x) / this.width;
        }
        double my = (double)y / root.getHeightFactor();
        return (my - this.y) / this.height;
    }

    @Override
    public PutInfo getPut(int x, int y, double factorW, double factorH, Dockable drop) {
        boolean rightVisible;
        boolean leftVisible = this.left == null || this.left.isVisible();
        boolean bl = rightVisible = this.right == null || this.right.isVisible();
        if (leftVisible && rightVisible) {
            if (this.orientation == SplitDockStation.Orientation.HORIZONTAL) {
                if ((double)x < (this.x + this.divider * this.width) * factorW) {
                    return this.left == null ? null : this.left.getPut(x, y, factorW, factorH, drop);
                }
                return this.right == null ? null : this.right.getPut(x, y, factorW, factorH, drop);
            }
            if ((double)y < (this.y + this.divider * this.height) * factorH) {
                return this.left == null ? null : this.left.getPut(x, y, factorW, factorH, drop);
            }
            return this.right == null ? null : this.right.getPut(x, y, factorW, factorH, drop);
        }
        if (leftVisible) {
            return this.left.getPut(x, y, factorW, factorH, drop);
        }
        if (rightVisible) {
            return this.right.getPut(x, y, factorW, factorH, drop);
        }
        return null;
    }

    @Override
    public boolean isInOverrideZone(int x, int y, double factorW, double factorH) {
        boolean rightVisible;
        boolean leftVisible = this.left == null || this.left.isVisible();
        boolean bl = rightVisible = this.right == null || this.right.isVisible();
        if (leftVisible && rightVisible) {
            if (this.orientation == SplitDockStation.Orientation.HORIZONTAL) {
                if ((double)x < (this.x + this.divider * this.width) * factorW) {
                    return this.left.isInOverrideZone(x, y, factorW, factorH);
                }
                return this.right.isInOverrideZone(x, y, factorW, factorH);
            }
            if ((double)y < (this.y + this.divider * this.height) * factorH) {
                return this.left.isInOverrideZone(x, y, factorW, factorH);
            }
            return this.right.isInOverrideZone(x, y, factorW, factorH);
        }
        if (leftVisible) {
            return this.left.isInOverrideZone(x, y, factorW, factorH);
        }
        if (rightVisible) {
            return this.right.isInOverrideZone(x, y, factorW, factorH);
        }
        return false;
    }

    @Override
    public void evolve(SplitDockTree.Key key, boolean checkValidity, Map<Leaf, Dockable> linksToSet) {
        SplitDockTree tree = key.getTree();
        this.setPlaceholders(tree.getPlaceholders(key));
        this.setPlaceholderMap(tree.getPlaceholderMap(key));
        if (tree.isHorizontal(key)) {
            this.orientation = SplitDockStation.Orientation.HORIZONTAL;
            this.setLeft(this.create(tree.getLeft(key), checkValidity, linksToSet));
            this.setRight(this.create(tree.getRight(key), checkValidity, linksToSet));
            this.setDivider(tree.getDivider(key));
        } else {
            this.orientation = SplitDockStation.Orientation.VERTICAL;
            this.setLeft(this.create(tree.getTop(key), checkValidity, linksToSet));
            this.setRight(this.create(tree.getBottom(key), checkValidity, linksToSet));
            this.setDivider(tree.getDivider(key));
        }
    }

    @Override
    public boolean insert(SplitDockPlaceholderProperty property, Dockable dockable) {
        Path placeholder = property.getPlaceholder();
        if (this.hasPlaceholder(placeholder)) {
            Leaf leaf = this.create(dockable, -1L);
            if (leaf == null) {
                return false;
            }
            this.getAccess().getPlaceholderSet().set(null, placeholder, this);
            leaf.setPlaceholders(this.getPlaceholders());
            Node node = this.createNode(-1L);
            node.setDivider(0.5);
            if (this.width > this.height) {
                node.setOrientation(SplitDockStation.Orientation.HORIZONTAL);
            } else {
                node.setOrientation(SplitDockStation.Orientation.VERTICAL);
            }
            SplitNode parent = this.getParent();
            int location = parent.getChildLocation(this);
            node.setLeft(leaf);
            node.setRight(this);
            parent.setChild(node, location);
            leaf.setDockable(dockable, null);
            return true;
        }
        if (this.left != null && this.left.insert(property, dockable)) {
            return true;
        }
        return this.right != null && this.right.insert(property, dockable);
    }

    @Override
    public boolean insert(SplitDockPathProperty property, int depth, Dockable dockable) {
        boolean rightVisible;
        boolean leftVisible = this.left == null || this.left.isVisible();
        boolean bl = rightVisible = this.right == null || this.right.isVisible();
        if (leftVisible && rightVisible) {
            boolean expand;
            if (depth >= property.size()) {
                return this.getAccess().drop(dockable, property.toLocation(this), this);
            }
            SplitDockPathProperty.Node node = property.getNode(depth);
            boolean bl2 = expand = this.orientation == SplitDockStation.Orientation.HORIZONTAL && (node.getLocation() == SplitDockPathProperty.Location.TOP || node.getLocation() == SplitDockPathProperty.Location.BOTTOM) || this.orientation == SplitDockStation.Orientation.VERTICAL && (node.getLocation() == SplitDockPathProperty.Location.LEFT || node.getLocation() == SplitDockPathProperty.Location.RIGHT);
            if (node.getId() != -1L && node.getId() != this.getId()) {
                expand = true;
            }
            if (expand) {
                Node split;
                Leaf leaf;
                long leafId = property.getLeafId();
                SplitDockPathProperty.Node lastNode = null;
                if (leafId == -1L && (lastNode = property.getLastNode()) != null) {
                    leafId = lastNode.getId();
                }
                long splitId = -1L;
                if (lastNode != node) {
                    splitId = depth > 0 ? property.getNode(depth - 1).getId() : node.getId();
                }
                if ((leaf = this.create(dockable, leafId)) == null) {
                    return false;
                }
                SplitDockStation.Orientation orientation = node.getLocation() == SplitDockPathProperty.Location.TOP || node.getLocation() == SplitDockPathProperty.Location.BOTTOM ? SplitDockStation.Orientation.VERTICAL : SplitDockStation.Orientation.HORIZONTAL;
                SplitNode parent = this.getParent();
                int location = parent.getChildLocation(this);
                if (node.getLocation() == SplitDockPathProperty.Location.LEFT || node.getLocation() == SplitDockPathProperty.Location.TOP) {
                    split = this.createNode(splitId);
                    split.setLeft(leaf);
                    split.setRight(this);
                    split.setOrientation(orientation);
                    split.setDivider(node.getSize());
                } else {
                    split = this.createNode(splitId);
                    split.setLeft(this);
                    split.setRight(leaf);
                    split.setOrientation(orientation);
                    split.setDivider(1.0 - node.getSize());
                }
                parent.setChild(split, location);
                leaf.setDockable(dockable, null);
                return true;
            }
            if (node.getLocation() == SplitDockPathProperty.Location.LEFT || node.getLocation() == SplitDockPathProperty.Location.TOP) {
                return this.left.insert(property, depth + 1, dockable);
            }
            return this.right.insert(property, depth + 1, dockable);
        }
        if (leftVisible) {
            return this.left.insert(property, depth, dockable);
        }
        if (rightVisible) {
            return this.right.insert(property, depth, dockable);
        }
        return false;
    }

    @Override
    public <N> N submit(SplitTreeFactory<N> factory) {
        if (this.orientation == SplitDockStation.Orientation.HORIZONTAL) {
            return factory.horizontal(this.left.submit(factory), this.right.submit(factory), this.divider, this.getId(), this.getPlaceholders(), this.getPlaceholderMap(), this.isVisible());
        }
        return factory.vertical(this.left.submit(factory), this.right.submit(factory), this.divider, this.getId(), this.getPlaceholders(), this.getPlaceholderMap(), this.isVisible());
    }

    @Override
    public Leaf getLeaf(Dockable dockable) {
        Leaf leaf;
        if (this.left != null && this.left.isVisible() && (leaf = this.left.getLeaf(dockable)) != null) {
            return leaf;
        }
        if (this.right != null && this.right.isVisible()) {
            return this.right.getLeaf(dockable);
        }
        return null;
    }

    @Override
    public Node getDividerNode(int x, int y) {
        Node node;
        boolean rightVisible;
        boolean leftVisible = this.left == null || this.left.isVisible();
        boolean bl = rightVisible = this.right == null || this.right.isVisible();
        if (leftVisible && rightVisible && this.dividerBounds.contains(x, y)) {
            return this;
        }
        if (this.left != null && leftVisible && (node = this.left.getDividerNode(x, y)) != null) {
            return node;
        }
        if (this.right != null && rightVisible) {
            return this.right.getDividerNode(x, y);
        }
        return null;
    }

    @Override
    public void visit(SplitNodeVisitor visitor) {
        visitor.handleNode(this);
        if (this.left != null) {
            this.left.visit(visitor);
        }
        if (this.right != null) {
            this.right.visit(visitor);
        }
    }

    @Override
    public void toString(int tabs, StringBuilder out) {
        int i;
        out.append("Node[ ");
        out.append((Object)this.orientation);
        out.append(" , id=");
        out.append(this.getId());
        out.append(", placeholders={");
        Path[] placeholders = this.getPlaceholders();
        if (placeholders != null) {
            for (i = 0; i < placeholders.length; ++i) {
                if (i > 0) {
                    out.append(", ");
                }
                out.append(placeholders[i]);
            }
        }
        out.append("}]");
        out.append('\n');
        for (i = 0; i < tabs + 1; ++i) {
            out.append('\t');
        }
        if (this.left == null) {
            out.append("<null>");
        } else {
            this.left.toString(tabs + 1, out);
        }
        out.append('\n');
        for (i = 0; i < tabs + 1; ++i) {
            out.append('\t');
        }
        if (this.right == null) {
            out.append("<null>");
        } else {
            this.right.toString(tabs + 1, out);
        }
    }
}

