/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen.window;

import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.station.screen.window.AbstractScreenDockWindow;
import bibliothek.gui.dock.station.screen.window.WindowConfiguration;
import bibliothek.util.Workarounds;
import java.awt.Dialog;
import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class ScreenDockDialog
extends AbstractScreenDockWindow {
    private JDialog dialog;

    public ScreenDockDialog(ScreenDockStation station, WindowConfiguration configuration, boolean undecorated) {
        super(station, configuration);
        this.dialog = new JDialog();
        this.init(undecorated, configuration);
    }

    public ScreenDockDialog(ScreenDockStation station, WindowConfiguration configuration, Frame frame, boolean undecorated) {
        super(station, configuration);
        this.dialog = new JDialog(frame);
        this.init(undecorated, configuration);
    }

    public ScreenDockDialog(ScreenDockStation station, WindowConfiguration configuration, Dialog dialog, boolean undecorated) {
        super(station, configuration);
        this.dialog = new JDialog(dialog);
        this.init(undecorated, configuration);
    }

    private void init(boolean undecorated, WindowConfiguration configuration) {
        if (undecorated) {
            this.dialog.setUndecorated(true);
            this.dialog.getRootPane().setWindowDecorationStyle(0);
        }
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.setModal(false);
        if (configuration.isTransparent()) {
            JPanel panel = new JPanel();
            panel.setOpaque(false);
            this.dialog.setContentPane(panel);
            Workarounds.getDefault().makeTransparent(this.dialog);
        }
        this.init(this.dialog, this.dialog.getContentPane(), configuration, undecorated);
    }

    public void setPreventFocusStealing(boolean prevent) {
        this.dialog.setFocusableWindowState(!prevent);
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public void destroy() {
        this.dialog.dispose();
    }

    public void toFront() {
        this.dialog.toFront();
    }

    protected void updateTitleText() {
        this.dialog.setTitle(this.getTitleText());
    }
}

