/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control.relocator;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.control.relocator.DefaultDockRelocatorEvent;
import bibliothek.gui.dock.control.relocator.Merger;
import bibliothek.gui.dock.control.relocator.RelocateOperation;
import bibliothek.gui.dock.control.relocator.VetoableDockRelocatorListener;
import bibliothek.gui.dock.station.StationDropItem;
import bibliothek.gui.dock.station.StationDropOperation;
import java.awt.Point;

public class MergeOperation
implements RelocateOperation {
    private DockController controller;
    private Merger merger;
    private DockStation station;
    private StationDropOperation operation;
    private StationDropItem item;

    public MergeOperation(DockController controller, Merger merger, DockStation station, StationDropOperation operation, StationDropItem item) {
        this.controller = controller;
        this.merger = merger;
        this.station = station;
        this.operation = operation;
        this.item = item;
    }

    public DockStation getStation() {
        return this.station;
    }

    public StationDropOperation getOperation() {
        return this.operation;
    }

    public void destroy(RelocateOperation next) {
        if (next == null) {
            this.operation.destroy(null);
        } else {
            this.operation.destroy(next.getOperation());
        }
    }

    public Dockable[] getImplicit(Dockable selection) {
        DockStation child = selection.asDockStation();
        Dockable[] children = new Dockable[child.getDockableCount()];
        for (int i = 0; i < children.length; ++i) {
            children[i] = child.getDockable(i);
        }
        return children;
    }

    public boolean execute(Dockable selection, VetoableDockRelocatorListener listener) {
        DockStation child = selection.asDockStation();
        DockStation parent = selection.getDockParent();
        Dockable[] children = this.getImplicit(selection);
        if (parent != null && parent != this.station) {
            Point mouse = new Point(this.item.getMouseX(), this.item.getMouseY());
            DefaultDockRelocatorEvent event = new DefaultDockRelocatorEvent(this.controller, selection, children, this.station, mouse);
            listener.dragging(event);
            if (event.isCanceled() || event.isForbidden()) {
                return false;
            }
        }
        this.merger.merge(this.operation, this.station, child);
        parent = selection.getDockParent();
        if (parent != null && parent != this.station) {
            parent.drag(selection);
        }
        return true;
    }
}

