/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control.relocator;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.control.relocator.DefaultDockRelocatorEvent;
import bibliothek.gui.dock.control.relocator.RelocateOperation;
import bibliothek.gui.dock.control.relocator.VetoableDockRelocatorListener;
import bibliothek.gui.dock.station.StationDropItem;
import bibliothek.gui.dock.station.StationDropOperation;
import java.awt.Point;

public class DropOperation
implements RelocateOperation {
    private DockController controller;
    private DockStation station;
    private StationDropOperation operation;
    private StationDropItem item;

    public DropOperation(DockController controller, DockStation station, StationDropOperation operation, StationDropItem item) {
        this.controller = controller;
        this.station = station;
        this.operation = operation;
        this.item = item;
    }

    public DockStation getStation() {
        return this.station;
    }

    public StationDropOperation getOperation() {
        return this.operation;
    }

    public Dockable[] getImplicit(Dockable selection) {
        return new Dockable[0];
    }

    public void destroy(RelocateOperation next) {
        if (next == null) {
            this.operation.destroy(null);
        } else {
            this.operation.destroy(next.getOperation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Dockable selection, VetoableDockRelocatorListener listener) {
        try {
            Point mouse = new Point(this.item.getMouseX(), this.item.getMouseY());
            if (this.operation.isMove()) {
                DefaultDockRelocatorEvent event = new DefaultDockRelocatorEvent(this.controller, selection, new Dockable[0], this.station, mouse);
                listener.dragging(event);
                if (event.isCanceled() || event.isForbidden()) {
                    boolean bl = false;
                    return bl;
                }
                this.operation.execute();
                listener.dragged(new DefaultDockRelocatorEvent(this.controller, selection, new Dockable[0], this.station, mouse));
            } else {
                DockStation parent = selection.getDockParent();
                if (parent != null) {
                    DefaultDockRelocatorEvent event = new DefaultDockRelocatorEvent(this.controller, selection, new Dockable[0], this.station, mouse);
                    listener.dragging(event);
                    if (event.isCanceled() || event.isForbidden()) {
                        boolean bl = false;
                        return bl;
                    }
                    parent.drag(selection);
                    listener.dragged(new DefaultDockRelocatorEvent(this.controller, selection, new Dockable[0], this.station, mouse));
                }
                this.operation.execute();
            }
        }
        finally {
            this.operation.destroy(null);
        }
        return true;
    }
}

