/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui;

import bibliothek.extension.gui.dock.theme.eclipse.EclipseTabDockAction;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.action.ActionGuard;
import bibliothek.gui.dock.action.DefaultDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionIcon;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.DockActionText;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.action.actions.SimpleButtonAction;
import bibliothek.gui.dock.control.DockRegister;
import bibliothek.gui.dock.dockable.DefaultDockableFactory;
import bibliothek.gui.dock.event.DockFrontendListener;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import bibliothek.gui.dock.event.VetoableDockFrontendListener;
import bibliothek.gui.dock.frontend.DefaultFrontendPerspectiveCache;
import bibliothek.gui.dock.frontend.DefaultLayoutChangeStrategy;
import bibliothek.gui.dock.frontend.DockFrontendExtension;
import bibliothek.gui.dock.frontend.DockFrontendInternals;
import bibliothek.gui.dock.frontend.DockFrontendPerspective;
import bibliothek.gui.dock.frontend.FrontendEntry;
import bibliothek.gui.dock.frontend.FrontendPerspectiveCache;
import bibliothek.gui.dock.frontend.LayoutChangeStrategy;
import bibliothek.gui.dock.frontend.MissingDockableStrategy;
import bibliothek.gui.dock.frontend.Setting;
import bibliothek.gui.dock.frontend.SettingsBlop;
import bibliothek.gui.dock.frontend.VetoManager;
import bibliothek.gui.dock.layout.AdjacentDockFactory;
import bibliothek.gui.dock.layout.DockLayoutComposition;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.layout.DockSituation;
import bibliothek.gui.dock.layout.DockSituationIgnore;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.DockablePropertyFactory;
import bibliothek.gui.dock.layout.PropertyTransformer;
import bibliothek.gui.dock.station.flap.FlapDockPropertyFactory;
import bibliothek.gui.dock.station.flap.FlapDockStationFactory;
import bibliothek.gui.dock.station.screen.ScreenDockPropertyFactory;
import bibliothek.gui.dock.station.screen.ScreenDockStationFactory;
import bibliothek.gui.dock.station.split.SplitDockPropertyFactory;
import bibliothek.gui.dock.station.split.SplitDockStationFactory;
import bibliothek.gui.dock.station.stack.StackDockPropertyFactory;
import bibliothek.gui.dock.station.stack.StackDockStationFactory;
import bibliothek.gui.dock.util.DirectWindowProvider;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.NullWindowProvider;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.WindowProvider;
import bibliothek.gui.dock.util.extension.ExtensionName;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XAttribute;
import bibliothek.util.xml.XElement;
import bibliothek.util.xml.XException;
import java.awt.Window;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DockFrontend {
    public static final PropertyKey<KeyStroke> HIDE_ACCELERATOR = new PropertyKey("frontend hide accelerator");
    public static final String DOCKABLE_KEY_PREFIX = "dockable";
    public static final String ROOT_KEY_PREFIX = "root";
    public static final Path FRONTEND_EXTENSION = new Path("dock", "DockFrontendExtension");
    private List<DockFrontendExtension> extensions;
    private DockController controller;
    private Hider hider;
    private Map<String, DockInfo> dockables = new HashMap<String, DockInfo>();
    private Set<String> empty = new HashSet<String>();
    private DockStation defaultStation;
    private Map<String, RootInfo> roots = new HashMap<String, RootInfo>();
    private Set<DockFactory<?, ?, ?>> dockFactories = new HashSet();
    private Set<DockFactory<? extends Dockable, ?, ?>> backupDockFactories = new HashSet();
    private Set<AdjacentDockFactory<?>> adjacentDockFactories = new HashSet();
    private Set<DockablePropertyFactory> propertyFactories = new HashSet<DockablePropertyFactory>();
    private String currentSetting;
    private Map<String, Setting> settings = new HashMap<String, Setting>();
    private List<DockFrontendListener> listeners = new ArrayList<DockFrontendListener>();
    private VetoManager veto;
    private DockSituationIgnore ignoreForEntry;
    private DockSituationIgnore ignoreForFinal;
    private MissingDockableStrategy missingDockable = MissingDockableStrategy.DISCARD_ALL;
    private LayoutChangeStrategy layoutChangeStrategy = new DefaultLayoutChangeStrategy();
    private boolean showHideAction = true;
    private boolean defaultEntryLayout = true;
    private boolean defaultHideable = false;
    private int onAutoFire = 0;
    private Setting lastAppliedFullSetting = null;
    private Setting lastAppliedEntrySetting = null;

    public DockFrontend() {
        this(new DockController(), new NullWindowProvider());
    }

    public DockFrontend(Window owner) {
        this(new DockController(), owner == null ? new NullWindowProvider() : new DirectWindowProvider(owner));
    }

    public DockFrontend(WindowProvider owner) {
        this(new DockController(), owner);
    }

    public DockFrontend(DockController controller) {
        this(controller, new NullWindowProvider());
    }

    public DockFrontend(DockController controller, Window owner) {
        this(controller, owner == null ? new NullWindowProvider() : new DirectWindowProvider(owner));
    }

    public DockFrontend(DockController controller, WindowProvider owner) {
        if (controller == null) {
            throw new IllegalArgumentException("controller must not be null");
        }
        this.controller = controller;
        controller.setRootWindowProvider(owner);
        this.veto = new VetoManager(this);
        this.hider = this.createHider();
        controller.addActionGuard(this.hider);
        this.registerFactory(new DefaultDockableFactory());
        this.registerFactory(new SplitDockStationFactory());
        this.registerFactory(new StackDockStationFactory());
        this.registerFactory(new FlapDockStationFactory());
        this.registerFactory(new ScreenDockStationFactory(controller.getRootWindowProvider()));
        this.registerFactory(new SplitDockPropertyFactory());
        this.registerFactory(new StackDockPropertyFactory());
        this.registerFactory(new FlapDockPropertyFactory());
        this.registerFactory(new ScreenDockPropertyFactory());
        controller.getRegister().addDockRegisterListener(new DockRegisterAdapter(){

            public void dockableRegistered(DockController controller, Dockable dockable) {
                if (DockFrontend.this.onAutoFire == 0) {
                    DockFrontend.this.fireShown(dockable);
                }
            }

            public void dockableUnregistered(DockController controller, Dockable dockable) {
                if (DockFrontend.this.onAutoFire == 0) {
                    DockFrontend.this.fireHidden(dockable);
                }
            }
        });
        this.extensions = controller.getExtensions().load(new ExtensionName<DockFrontendExtension>(FRONTEND_EXTENSION, DockFrontendExtension.class));
        for (DockFrontendExtension extension : this.extensions) {
            extension.install(this);
        }
    }

    public DockController getController() {
        return this.controller;
    }

    public void setOwner(WindowProvider owner) {
        this.controller.setRootWindowProvider(owner);
    }

    public WindowProvider getOwner() {
        return this.controller.getRootWindowProvider();
    }

    public void kill() {
        this.controller.kill();
        for (DockFrontendExtension extension : this.extensions) {
            extension.uninstall(this);
        }
    }

    @Deprecated
    public Collection<Dockable> getDockables() {
        return this.listDockables();
    }

    public void addFrontendListener(DockFrontendListener listener) {
        this.listeners.add(listener);
    }

    public void removeFrontendListener(DockFrontendListener listener) {
        this.listeners.remove(listener);
    }

    public void addVetoableListener(VetoableDockFrontendListener listener) {
        this.veto.addVetoableListener(listener);
    }

    public void removeVetoableListener(VetoableDockFrontendListener listener) {
        this.veto.removeVetoableListener(listener);
    }

    public void registerFactory(DockFactory<?, ?, ?> factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        this.dockFactories.add(factory);
        this.fillMissing(factory);
    }

    public DockFactory<?, ?, ?> getDockFactory(String factoryId) {
        for (DockFactory<?, ?, ?> factory : this.dockFactories) {
            if (!factory.getID().equals(factoryId)) continue;
            return factory;
        }
        return null;
    }

    public void registerFactory(DockFactory<? extends Dockable, ?, ?> factory, boolean backup) {
        if (factory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        this.dockFactories.add(factory);
        if (backup) {
            this.backupDockFactories.add(factory);
        }
        this.fillMissing(factory);
    }

    public void registerBackupFactory(DockFactory<? extends Dockable, ?, ?> factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        this.backupDockFactories.add(factory);
        this.fillMissing(factory);
    }

    public void registerAdjacentFactory(AdjacentDockFactory<?> factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        this.adjacentDockFactories.add(factory);
    }

    public void unregisterFactory(DockFactory<?, ?, ?> factory) {
        this.dockFactories.remove(factory);
    }

    public void unregisterBackupFactory(DockFactory<?, ?, ?> factory) {
        this.backupDockFactories.remove(factory);
    }

    public void unregisterAdjacentFactory(AdjacentDockFactory<?> factory) {
        this.adjacentDockFactories.remove(factory);
    }

    public void registerFactory(DockablePropertyFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        this.propertyFactories.add(factory);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addDockable(String id, Dockable dockable) {
        if (dockable == null) {
            throw new IllegalArgumentException("Dockable must not be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        DockInfo info = this.dockables.get(id);
        if (info != null) {
            if (info.getDockable() != null) throw new IllegalArgumentException("There is already a dockable registered with name " + id);
            info.setDockable(dockable);
            info.updateHideAction();
        } else {
            info = new DockInfo(dockable, id);
            this.dockables.put(id, info);
        }
        DockLayoutComposition layout = info.getLayout();
        if (layout != null) {
            try {
                DockSituation situation = this.layoutChangeStrategy.createSituation(new Internals(), false);
                layout = situation.fillMissing(layout);
                situation.convert(layout);
                info.setLayout(null);
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Cannot read old layout information", ex);
            }
        }
        this.fireAdded(dockable);
    }

    public void setMissingDockableStrategy(MissingDockableStrategy missingDockable) {
        this.missingDockable = missingDockable == null ? MissingDockableStrategy.DISCARD_ALL : missingDockable;
    }

    public MissingDockableStrategy getMissingDockable() {
        return this.missingDockable;
    }

    public void setLayoutChangeStrategy(LayoutChangeStrategy strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException("strategy must not be null");
        }
        this.layoutChangeStrategy = strategy;
    }

    public LayoutChangeStrategy getLayoutChangeStrategy() {
        return this.layoutChangeStrategy;
    }

    public PropertyTransformer createPropertyTransformer() {
        return this.layoutChangeStrategy.createTransformer(new Internals());
    }

    public Map<String, Dockable> getNamedDockables() {
        HashMap<String, Dockable> result = new HashMap<String, Dockable>();
        for (Map.Entry<String, DockInfo> entry : this.dockables.entrySet()) {
            if (entry.getValue().getDockable() == null) continue;
            result.put(entry.getKey(), entry.getValue().getDockable());
        }
        return result;
    }

    public Dockable getDockable(String name) {
        DockInfo info = this.getInfo(name);
        return info == null ? null : info.dockable;
    }

    public String getNameOf(Dockable dockable) {
        if (dockable == null) {
            throw new NullPointerException("dockable is null");
        }
        for (Map.Entry<String, DockInfo> entry : this.dockables.entrySet()) {
            if (entry.getValue().dockable != dockable) continue;
            return entry.getKey();
        }
        return null;
    }

    public void addRoot(String id, DockStation station) {
        this.addRoot(station, id);
    }

    @Deprecated
    public void addRoot(DockStation station, String name) {
        if (station == null) {
            throw new IllegalArgumentException("Stations must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (this.roots.containsKey(name)) {
            throw new IllegalArgumentException("There is already a station registered with name " + name);
        }
        this.controller.add(station);
        this.roots.put(name, new RootInfo(station, name));
    }

    public DockStation getRoot(String name) {
        RootInfo info = this.roots.get(name);
        if (info == null) {
            return null;
        }
        return info.getStation();
    }

    public String[] getRootNames() {
        return this.roots.keySet().toArray(new String[this.roots.size()]);
    }

    public DockStation[] getRoots() {
        DockStation[] stations = new DockStation[this.roots.size()];
        int i = 0;
        for (RootInfo info : this.roots.values()) {
            stations[i++] = info.station;
        }
        return stations;
    }

    public void addRepresentative(DockElementRepresentative representative) {
        this.controller.addRepresentative(representative);
    }

    public void removeRepresentative(DockElementRepresentative representative) {
        this.controller.removeRepresentative(representative);
    }

    public void setDefaultStation(DockStation defaultStation) {
        if (defaultStation != null && this.getRoot(defaultStation) == null) {
            throw new IllegalArgumentException("The default station must be registered as root");
        }
        this.defaultStation = defaultStation;
    }

    public DockStation getDefaultStation() {
        if (this.defaultStation != null) {
            return this.defaultStation;
        }
        Iterator<RootInfo> infos = this.roots.values().iterator();
        if (infos.hasNext()) {
            return infos.next().getStation();
        }
        return null;
    }

    public void remove(Dockable dockable) {
        DockInfo info = this.getInfo(dockable);
        if (info != null) {
            boolean hideable = info.isHideable();
            info.setHideable(false);
            if (this.empty.contains(info.getKey())) {
                info.updateLocation();
                this.fireRemoved(dockable);
                info.setDockable(null);
                info.setHideable(hideable);
            } else {
                this.dockables.remove(info.getKey());
                this.fireRemoved(dockable);
            }
        }
    }

    public void addEmpty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.empty.add(name);
        if (!this.dockables.containsKey(name)) {
            this.dockables.put(name, new DockInfo(null, name));
        }
    }

    public void removeEmpty(String name) {
        this.empty.remove(name);
        DockInfo info = this.getInfo(name);
        if (info != null && info.getDockable() == null) {
            this.dockables.remove(name);
        }
    }

    public boolean isEmpty(String name) {
        return this.empty.contains(name);
    }

    public String[] listEmpty(boolean all) {
        if (all) {
            return this.empty.toArray(new String[this.empty.size()]);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String key : this.empty) {
            DockInfo info = this.getInfo(key);
            if (info.getDockable() != null) continue;
            result.add(key);
        }
        return result.toArray(new String[result.size()]);
    }

    public void removeRoot(DockStation station) {
        RootInfo info = this.getRoot(station);
        if (info != null) {
            if (this.defaultStation == info.getStation()) {
                this.defaultStation = null;
            }
            this.roots.remove(info.getName());
            this.controller.remove(station);
        }
    }

    public boolean hasLocation(Dockable dockable) {
        DockInfo info = this.getInfo(dockable);
        if (info == null) {
            return false;
        }
        if (this.isShown(dockable)) {
            return true;
        }
        return info.root != null && info.location != null;
    }

    public boolean hasLocation(String id) {
        DockInfo info = this.getInfo(id);
        if (info == null) {
            return false;
        }
        return info.root != null && info.location != null;
    }

    public void setIgnoreForEntry(DockSituationIgnore ignoreForEntry) {
        this.ignoreForEntry = ignoreForEntry;
    }

    public DockSituationIgnore getIgnoreForEntry() {
        return this.ignoreForEntry;
    }

    public void setIgnoreForFinal(DockSituationIgnore ignoreForFinal) {
        this.ignoreForFinal = ignoreForFinal;
    }

    public DockSituationIgnore getIgnoreForFinal() {
        return this.ignoreForFinal;
    }

    public DockProperties getDockProperties() {
        return this.controller.getProperties();
    }

    public Setting getLastAppliedFullSetting() {
        return this.lastAppliedFullSetting;
    }

    public Setting getLastAppliedEntrySetting() {
        return this.lastAppliedEntrySetting;
    }

    public Set<String> getSettings() {
        Set<String> keys = this.settings.keySet();
        return Collections.unmodifiableSet(keys);
    }

    public Setting getSetting(String name) {
        return this.settings.get(name);
    }

    public String getCurrentSetting() {
        return this.currentSetting;
    }

    public void setCurrentSetting(String setting) {
        if (setting == null) {
            throw new IllegalArgumentException("the name of a setting must not be null");
        }
        if (this.settings.containsKey(setting)) {
            this.load(setting);
        } else {
            this.save(setting);
        }
    }

    public void setCurrentSettingName(String setting) {
        this.currentSetting = setting;
    }

    public void setSetting(String name, Setting setting) {
        if (setting == null) {
            throw new IllegalArgumentException("setting is null");
        }
        this.settings.put(name, setting);
    }

    public boolean isHidden(Dockable dockable) {
        return !this.isShown(dockable);
    }

    public boolean isShown(Dockable dockable) {
        return this.controller.getRegister().willBeRegistered(dockable);
    }

    public boolean isHiddenRootStation(DockElement element) {
        Dockable dockable = element.asDockable();
        DockStation station = element.asDockStation();
        if (station == null || dockable == null) {
            return false;
        }
        DockRegister register = this.controller.getRegister();
        if (register.isProtected(station)) {
            return dockable.getDockParent() == null;
        }
        return false;
    }

    public void setDefaultHideable(boolean defaultHideable) {
        this.defaultHideable = defaultHideable;
    }

    public boolean isDefaultHideable() {
        return this.defaultHideable;
    }

    public boolean isHideable(Dockable dockable) {
        DockInfo info = this.getInfo(dockable);
        if (info == null) {
            throw new IllegalArgumentException("Dockable not registered");
        }
        return info.isHideable();
    }

    public void setHideable(Dockable dockable, boolean hideable) {
        DockInfo info = this.getInfo(dockable);
        if (info == null) {
            throw new IllegalArgumentException("Dockable not registered");
        }
        if (info.isHideable() != hideable) {
            info.setHideable(hideable);
            this.fireHideable(dockable, hideable);
        }
    }

    public void setShowHideAction(boolean show) {
        if (this.showHideAction != show) {
            this.showHideAction = show;
            for (DockInfo info : this.dockables.values()) {
                info.updateHideAction();
            }
        }
    }

    public boolean isShowHideAction() {
        return this.showHideAction;
    }

    public void setDefaultEntryLayout(boolean defaultEntryLayout) {
        this.defaultEntryLayout = defaultEntryLayout;
    }

    public boolean isDefaultEntryLayout() {
        return this.defaultEntryLayout;
    }

    public void setEntryLayout(Dockable dockable, boolean layout) {
        DockInfo info = this.getInfo(dockable);
        if (info == null) {
            throw new IllegalArgumentException("dockable not registered");
        }
        info.setEntryLayout(layout);
    }

    public void setEntryLayout(String id, boolean layout) {
        DockInfo info = this.getInfo(id);
        if (info == null) {
            throw new IllegalArgumentException("no entry present for: " + id);
        }
        info.setEntryLayout(layout);
    }

    public boolean isEntryLayout(Dockable dockable) {
        DockInfo info = this.getInfo(dockable);
        if (info == null) {
            throw new IllegalArgumentException("dockable not registered");
        }
        return info.isEntryLayout();
    }

    public boolean isEntryLayout(String id) {
        DockInfo info = this.getInfo(id);
        if (info == null) {
            throw new IllegalArgumentException("no entry present for: " + id);
        }
        return info.isEntryLayout();
    }

    public void show(Dockable dockable) {
        this.show(dockable, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show(Dockable dockable, boolean cancelable) {
        try {
            ++this.onAutoFire;
            if ((this.isHidden(dockable) || this.isHiddenRootStation(dockable)) && this.veto.expectToShow(dockable, cancelable)) {
                DockInfo info = this.getInfo(dockable);
                if (info == null) {
                    DockStation station = this.getDefaultStation();
                    if (station == null) {
                        throw new IllegalStateException("Can't find the default station");
                    }
                    station.drop(dockable);
                } else {
                    String root = info.getRoot();
                    DockableProperty location = info.getLocation();
                    DockStation station = root == null ? this.getDefaultStation() : this.getRoot(root);
                    if (station == null && (station = this.getDefaultStation()) == null) {
                        throw new IllegalStateException("Can't find the default station");
                    }
                    if (location == null) {
                        this.getDefaultStation().drop(dockable);
                    } else if (!station.drop(dockable, location)) {
                        this.getDefaultStation().drop(dockable);
                    }
                }
                this.fireAllShown(dockable, null);
            }
        }
        finally {
            --this.onAutoFire;
        }
    }

    public void hide(Dockable dockable) {
        this.hide(dockable, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hide(Dockable dockable, boolean cancelable) {
        try {
            ++this.onAutoFire;
            if (this.isShown(dockable) && (dockable.getDockParent() == null || this.veto.expectToHide(dockable, cancelable))) {
                DockInfo info = this.getInfo(dockable);
                if (info != null) {
                    info.updateLocation();
                }
                if (dockable.getDockParent() != null) {
                    dockable.getDockParent().drag(dockable);
                    this.fireAllHidden(dockable, null);
                }
            }
        }
        finally {
            --this.onAutoFire;
        }
    }

    public void save() {
        if (this.currentSetting == null) {
            throw new IllegalStateException("No setting loaded yet");
        }
        this.save(this.currentSetting);
    }

    public void save(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        Setting setting = this.getSetting(true);
        this.setSetting(name, setting);
        this.currentSetting = name;
        this.fireSaved(name);
    }

    public void load(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        Setting setting = this.settings.get(name);
        if (setting == null) {
            throw new IllegalArgumentException("Unknown setting \"" + name + "\"");
        }
        this.currentSetting = name;
        this.setSetting(setting, true);
        this.fireLoaded(name);
    }

    public Setting getSetting(boolean entry) {
        DockLayoutComposition layout;
        Setting setting = this.createSetting();
        DockSituation situation = this.layoutChangeStrategy.createSituation(new Internals(), entry);
        for (RootInfo rootInfo : this.roots.values()) {
            DockStation station = rootInfo.getStation();
            if (station.asDockable() != null && station.asDockable().getDockParent() != null) continue;
            layout = situation.convert(station);
            setting.putRoot(rootInfo.getName(), layout);
        }
        for (DockInfo dockInfo : this.dockables.values()) {
            Dockable dockable = dockInfo.getDockable();
            if (dockable != null && dockable.getController() != null) continue;
            layout = null;
            if (!entry || dockInfo.isEntryLayout()) {
                layout = dockable != null ? situation.convert(dockable) : dockInfo.getLayout();
            }
            setting.addInvisible(dockInfo.getKey(), dockInfo.getRoot(), layout, dockInfo.getLocation());
        }
        return setting;
    }

    public void setSetting(Setting setting, boolean entry) {
        try {
            ++this.onAutoFire;
            this.controller.getRegister().setStalled(true);
            if (this.layoutChangeStrategy.setLayout(new Internals(), setting, entry)) {
                if (entry) {
                    this.lastAppliedEntrySetting = setting;
                } else {
                    this.lastAppliedEntrySetting = null;
                    this.lastAppliedFullSetting = setting;
                }
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot set Setting", e);
        }
        catch (XException e) {
            throw new IllegalArgumentException("Cannot set Setting", e);
        }
        finally {
            --this.onAutoFire;
            this.controller.getRegister().setStalled(false);
        }
        for (DockInfo info : this.dockables.values()) {
            if (info.getDockable() == null || info.isHideable() || !this.isHidden(info.getDockable())) continue;
            this.show(info.getDockable());
        }
    }

    public DockFrontendPerspective getPerspective(boolean entry) {
        return this.getPerspective(entry, new DefaultFrontendPerspectiveCache(this));
    }

    public DockFrontendPerspective getPerspective(boolean entry, FrontendPerspectiveCache factory) {
        return this.layoutChangeStrategy.createPerspective(new Internals(), entry, factory);
    }

    private void fillMissing() {
        DockSituation situation = this.layoutChangeStrategy.createSituation(new Internals(), false);
        for (Setting setting : this.settings.values()) {
            setting.fillMissing(situation);
        }
        if (this.lastAppliedFullSetting != null && !this.settings.containsValue(this.lastAppliedFullSetting)) {
            this.lastAppliedFullSetting.fillMissing(situation);
        }
        if (this.lastAppliedEntrySetting != null && this.lastAppliedEntrySetting != this.lastAppliedFullSetting && !this.settings.containsValue(this.lastAppliedEntrySetting)) {
            this.lastAppliedEntrySetting.fillMissing(situation);
        }
        List<FrontendEntry> entries = this.listFrontendEntries();
        for (FrontendEntry entry : entries) {
            DockElement element;
            Dockable dockable;
            if (entry.getDockable() != null || entry.getLayout() == null || (dockable = (element = situation.convert(entry.getLayout())) == null ? null : element.asDockable()) == null) continue;
            entry.setLayout(null);
            this.addDockable(entry.getKey(), dockable);
        }
    }

    private void fillMissing(DockFactory<?, ?, ?> factory) {
        this.fillMissing();
        Setting last = this.getLastAppliedEntrySetting();
        boolean entry = true;
        if (last == null) {
            last = this.getLastAppliedFullSetting();
            entry = false;
        }
        if (last == null) {
            return;
        }
        Internals internals = new Internals();
        DockSituation situation = this.layoutChangeStrategy.createSituation(internals, entry);
        String factoryId = situation.convertFactoryId(factory);
        for (String root : this.roots.keySet()) {
            DockLayoutComposition composition = last.getRoot(root);
            if (composition == null) continue;
            this.layoutChangeStrategy.estimateLocations(internals, situation, composition);
            this.fillMissing(root, composition, factory, factoryId);
        }
    }

    private void fillMissing(String root, DockLayoutComposition composition, DockFactory<?, ?, ?> factory, String factoryId) {
        List<DockLayoutComposition> children;
        RootInfo rootInfo;
        Dockable dockable;
        Object element;
        DockFactory<?, ?, ?> normalizedFactory;
        DockableProperty location;
        DockLayoutInfo info = composition.getLayout();
        if (info.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT && info.getDataLayout().getFactoryID().equals(factoryId) && (location = info.getLocation()) != null && this.missingDockable.shouldCreate(normalizedFactory = factory, info.getDataLayout().getData()) && (element = normalizedFactory.layout(info.getDataLayout().getData(), this.layoutChangeStrategy.getPlaceholderStrategy(new Internals()))) != null && (dockable = element.asDockable()) != null && !(rootInfo = this.roots.get(root)).getStation().drop(dockable, location)) {
            rootInfo.getStation().drop(dockable);
        }
        if ((children = composition.getChildren()) != null) {
            for (DockLayoutComposition child : children) {
                this.fillMissing(root, child, factory, factoryId);
            }
        }
    }

    public Set<Dockable> listShownDockables() {
        HashSet<Dockable> set = new HashSet<Dockable>();
        for (DockInfo info : this.dockables.values()) {
            if (info.getDockable() == null || !this.isShown(info.getDockable())) continue;
            set.add(info.getDockable());
        }
        return set;
    }

    public List<Dockable> listDockables() {
        ArrayList<Dockable> result = new ArrayList<Dockable>(this.dockables.size());
        for (DockInfo info : this.dockables.values()) {
            if (info.getDockable() == null) continue;
            result.add(info.getDockable());
        }
        return result;
    }

    public List<FrontendEntry> listFrontendEntries() {
        return new ArrayList<FrontendEntry>(this.dockables.values());
    }

    public FrontendEntry getFrontendEntry(String key) {
        return this.dockables.get(key);
    }

    public FrontendEntry getFrontendEntry(Dockable dockable) {
        return this.getInfo(dockable);
    }

    protected void clean(DockSituationIgnore ignore) {
        for (RootInfo root : this.roots.values()) {
            if (ignore.ignoreElement(root.getStation())) continue;
            this.clean(root.getStation(), ignore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clean(DockStation station, DockSituationIgnore ignore) {
        try {
            this.controller.getRegister().setStalled(true);
            if (!ignore.ignoreChildren(station)) {
                for (int i = station.getDockableCount() - 1; i >= 0; --i) {
                    Dockable dockable = station.getDockable(i);
                    if (ignore.ignoreElement(dockable)) continue;
                    DockStation check = dockable.asDockStation();
                    if (check != null) {
                        this.clean(check, ignore);
                    }
                    station.drag(dockable);
                }
            }
        }
        finally {
            this.controller.getRegister().setStalled(false);
        }
    }

    public int deleteAll() {
        String[] array;
        int count = 0;
        Set<String> settings = this.getSettings();
        for (String name : array = settings.toArray(new String[settings.size()])) {
            if (!this.delete(name)) continue;
            ++count;
        }
        return count;
    }

    public boolean delete(String name) {
        boolean deleted;
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        boolean bl = deleted = this.settings.remove(name) != null;
        if (deleted) {
            if (name.equals(this.currentSetting)) {
                this.currentSetting = null;
            }
            this.fireDeleted(name);
        }
        return deleted;
    }

    public void write(DataOutputStream out) throws IOException {
        this.writeBlop(this.writeBlop(), out);
    }

    public void writeBlop(SettingsBlop blop, DataOutputStream out) throws IOException {
        String currentSetting = blop.getCurrentName();
        if (currentSetting == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(currentSetting);
        }
        String[] names = blop.getNames();
        out.writeInt(names.length);
        for (String name : names) {
            out.writeUTF(name);
            this.write(blop.getSetting(name), true, out);
        }
        this.write(blop.getCurrentSetting(), false, out);
    }

    protected void write(Setting setting, boolean entry, DataOutputStream out) throws IOException {
        Internals internals = new Internals();
        DockSituation situation = this.layoutChangeStrategy.createSituation(internals, entry);
        PropertyTransformer properties = this.layoutChangeStrategy.createTransformer(internals);
        setting.write(situation, properties, entry, out);
    }

    public void read(DataInputStream in) throws IOException {
        this.read(in, false);
    }

    public void read(DataInputStream in, boolean keepExistingSettings) throws IOException {
        this.readBlop(this.readBlop(in), keepExistingSettings);
    }

    public SettingsBlop readBlop(DataInputStream in) throws IOException {
        SettingsBlop blop = new SettingsBlop();
        Version version = Version.read(in);
        version.checkCurrent();
        String currentSetting = null;
        if (in.readBoolean()) {
            currentSetting = in.readUTF();
        }
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            String key = in.readUTF();
            Setting setting = this.read(true, in);
            blop.put(key, setting);
        }
        blop.setCurrent(currentSetting, this.read(false, in));
        return blop;
    }

    protected Setting read(boolean entry, DataInputStream in) throws IOException {
        Setting setting = this.createSetting();
        Internals internals = new Internals();
        DockSituation situation = this.layoutChangeStrategy.createSituation(internals, entry);
        PropertyTransformer properties = this.layoutChangeStrategy.createTransformer(internals);
        setting.read(situation, properties, entry, in);
        return setting;
    }

    public void writeXML(XElement element) {
        this.writeBlopXML(this.writeBlop(), element);
    }

    public void writeBlopXML(SettingsBlop blop, XElement element) {
        String[] names = blop.getNames();
        if (names.length > 0) {
            XElement xsettings = element.addElement("settings");
            for (String name : names) {
                XElement xsetting = xsettings.addElement("setting");
                xsetting.addString("name", name);
                this.writeXML(blop.getSetting(name), true, xsetting);
            }
        }
        XElement xcurrent = element.addElement("current");
        String current = blop.getCurrentName();
        if (current != null) {
            xcurrent.addString("name", current);
        }
        this.writeXML(blop.getCurrentSetting(), false, xcurrent);
    }

    protected void writeXML(Setting setting, boolean entry, XElement element) {
        Internals internals = new Internals();
        DockSituation situation = this.layoutChangeStrategy.createSituation(internals, entry);
        PropertyTransformer properties = this.layoutChangeStrategy.createTransformer(internals);
        setting.writeXML(situation, properties, entry, element);
    }

    public void readXML(XElement element) {
        this.readXML(element, false);
    }

    public void readXML(XElement element, boolean keepExistingSettings) {
        this.readBlop(this.readBlopXML(element), keepExistingSettings);
    }

    public SettingsBlop readBlopXML(XElement element) {
        XElement xcurrent;
        SettingsBlop blop = new SettingsBlop();
        XElement xsettings = element.getElement("settings");
        if (xsettings != null) {
            for (XElement xsetting : xsettings.getElements("setting")) {
                String key = xsetting.getString("name");
                Setting setting = this.readXML(true, xsetting);
                blop.put(key, setting);
            }
        }
        if ((xcurrent = element.getElement("current")) != null) {
            XAttribute xname = xcurrent.getAttribute("name");
            String name = null;
            if (xname != null) {
                name = xname.getString();
            }
            blop.setCurrent(name, this.readXML(false, xcurrent));
        }
        return blop;
    }

    protected Setting readXML(boolean entry, XElement element) {
        Setting setting = this.createSetting();
        Internals internals = new Internals();
        DockSituation situation = this.layoutChangeStrategy.createSituation(internals, entry);
        PropertyTransformer properties = this.layoutChangeStrategy.createTransformer(internals);
        setting.readXML(situation, properties, entry, element);
        return setting;
    }

    public SettingsBlop writeBlop() {
        SettingsBlop blop = new SettingsBlop();
        for (Map.Entry<String, Setting> entry : this.settings.entrySet()) {
            blop.put(entry.getKey(), entry.getValue());
        }
        blop.setCurrent(this.currentSetting, this.getSetting(false));
        return blop;
    }

    public void readBlop(SettingsBlop blop, boolean keepExistingSettings) {
        if (!keepExistingSettings) {
            this.deleteAll();
        }
        for (String name : blop.getNames()) {
            this.settings.put(name, blop.getSetting(name));
            this.fireRead(name);
        }
        this.currentSetting = blop.getCurrentName();
        this.setSetting(blop.getCurrentSetting(), false);
    }

    protected Hider createHider() {
        return new Hider();
    }

    protected Setting createSetting() {
        return new Setting();
    }

    public Hider getHider() {
        return this.hider;
    }

    private DockInfo getInfo(Dockable dockable) {
        if (dockable == null) {
            throw new NullPointerException("dockable is null");
        }
        for (DockInfo info : this.dockables.values()) {
            if (info.getDockable() != dockable) continue;
            return info;
        }
        return null;
    }

    private DockInfo getInfo(String name) {
        return this.dockables.get(name);
    }

    private RootInfo getRoot(DockStation station) {
        for (RootInfo info : this.roots.values()) {
            if (info.getStation() != station) continue;
            return info;
        }
        return null;
    }

    private RootInfo getRoot(Dockable dockable) {
        RootInfo info;
        DockStation station = dockable.asDockStation();
        if (station != null && (info = this.getRoot(station)) != null) {
            return info;
        }
        station = dockable.getDockParent();
        while (station != null) {
            info = this.getRoot(station);
            if (info != null) {
                return info;
            }
            dockable = station.asDockable();
            if (dockable == null) {
                return null;
            }
            station = dockable.getDockParent();
        }
        return null;
    }

    protected DockFrontendListener[] listeners() {
        return this.listeners.toArray(new DockFrontendListener[this.listeners.size()]);
    }

    protected void fireAllHidden(Dockable dockable, final Set<Dockable> processed) {
        DockUtilities.visit(dockable, new DockUtilities.DockVisitor(){

            public void handleDockable(Dockable dockable) {
                if (processed == null || processed.add(dockable)) {
                    DockFrontend.this.fireHidden(dockable);
                    DockInfo info = DockFrontend.this.getInfo(dockable);
                    if (info != null) {
                        info.setShown(false);
                    }
                }
            }
        });
    }

    protected void fireHidden(Dockable dockable) {
        for (DockFrontendListener listener : this.listeners()) {
            listener.hidden(this, dockable);
        }
    }

    protected void fireAdded(Dockable dockable) {
        for (DockFrontendListener listener : this.listeners()) {
            listener.added(this, dockable);
        }
    }

    protected void fireHideable(Dockable dockable, boolean value) {
        for (DockFrontendListener listener : this.listeners()) {
            listener.hideable(this, dockable, value);
        }
    }

    protected void fireRemoved(Dockable dockable) {
        for (DockFrontendListener listener : this.listeners()) {
            listener.removed(this, dockable);
        }
    }

    protected void fireAllShown(Dockable dockable, final Set<Dockable> processed) {
        DockUtilities.visit(dockable, new DockUtilities.DockVisitor(){

            public void handleDockable(Dockable dockable) {
                if (processed == null || processed.add(dockable)) {
                    DockFrontend.this.fireShown(dockable);
                    DockInfo info = DockFrontend.this.getInfo(dockable);
                    if (info != null) {
                        info.setShown(true);
                    }
                }
            }
        });
    }

    protected void fireShown(Dockable dockable) {
        for (DockFrontendListener listener : this.listeners()) {
            listener.shown(this, dockable);
        }
    }

    protected void fireSaved(String name) {
        for (DockFrontendListener listener : this.listeners()) {
            listener.saved(this, name);
        }
    }

    protected void fireLoaded(String name) {
        for (DockFrontendListener listener : this.listeners()) {
            listener.loaded(this, name);
        }
    }

    protected void fireRead(String name) {
        for (DockFrontendListener listener : this.listeners()) {
            listener.read(this, name);
        }
    }

    protected void fireDeleted(String name) {
        for (DockFrontendListener listener : this.listeners()) {
            listener.deleted(this, name);
        }
    }

    @EclipseTabDockAction
    public class Hider
    extends SimpleButtonAction
    implements ActionGuard {
        private DockActionIcon icon;
        private DockActionText text;
        private DockActionText tooltip;

        public Hider() {
            this.text = new DockActionText("close", this){

                protected void changed(String oldValue, String newValue) {
                    Hider.this.setText(newValue);
                }
            };
            this.tooltip = new DockActionText("close.tooltip", this){

                protected void changed(String oldValue, String newValue) {
                    Hider.this.setTooltip(newValue);
                }
            };
            this.icon = new DockActionIcon("close", this){

                protected void changed(Icon oldValue, Icon newValue) {
                    Hider.this.setIcon(newValue);
                }
            };
            this.text.setController(DockFrontend.this.controller);
            this.tooltip.setController(DockFrontend.this.controller);
            this.icon.setManager(DockFrontend.this.controller.getIcons());
            PropertyValue<KeyStroke> stroke = new PropertyValue<KeyStroke>(HIDE_ACCELERATOR){

                @Override
                protected void valueChanged(KeyStroke oldValue, KeyStroke newValue) {
                    Hider.this.setAccelerator(newValue);
                }
            };
            stroke.setProperties(DockFrontend.this.controller);
            this.setAccelerator((KeyStroke)stroke.getValue());
        }

        public void iconChanged(String key, Icon icon) {
            this.setIcon(icon);
        }

        public DockActionSource getSource(Dockable dockable) {
            DockInfo info = DockFrontend.this.getInfo(dockable);
            if (info == null) {
                return new DefaultDockActionSource(new LocationHint(LocationHint.ACTION_GUARD, LocationHint.RIGHT_OF_ALL), this);
            }
            return info.getSource();
        }

        public boolean react(Dockable dockable) {
            DockInfo info = DockFrontend.this.getInfo(dockable);
            return info != null;
        }

        public void action(Dockable dockable) {
            DockFrontend.this.hide(dockable);
        }
    }

    public static class RootInfo {
        private DockStation station;
        private String name;

        public RootInfo(DockStation station, String name) {
            this.name = name;
            this.station = station;
        }

        public String getName() {
            return this.name;
        }

        public DockStation getStation() {
            return this.station;
        }
    }

    public class DockInfo
    implements FrontendEntry {
        private Dockable dockable;
        private String key;
        private boolean hideable;
        private DefaultDockActionSource source;
        private String root;
        private DockableProperty location;
        private boolean entryLayout;
        private DockLayoutComposition layout;
        private boolean hideActionVisible;
        private boolean shown = false;

        public DockInfo(Dockable dockable, String key) {
            this.dockable = dockable;
            this.key = key;
            this.entryLayout = DockFrontend.this.defaultEntryLayout;
            this.source = new DefaultDockActionSource(new LocationHint(LocationHint.ACTION_GUARD, LocationHint.RIGHT_OF_ALL), new DockAction[0]);
            this.hideActionVisible = false;
            this.setHideable(DockFrontend.this.defaultHideable);
        }

        public void setShown(boolean shown) {
            this.shown = shown;
        }

        public boolean isShown() {
            return this.shown;
        }

        public boolean isEntryLayout() {
            return this.entryLayout;
        }

        public void setEntryLayout(boolean entryLayout) {
            this.entryLayout = entryLayout;
        }

        public boolean isHideable() {
            return this.hideable;
        }

        public void setHideable(boolean hideable) {
            this.hideable = hideable;
            this.updateHideAction();
        }

        public void updateHideAction() {
            boolean shouldShow;
            boolean bl = shouldShow = this.hideable && DockFrontend.this.showHideAction;
            if (shouldShow != this.hideActionVisible) {
                this.hideActionVisible = shouldShow;
                if (shouldShow) {
                    this.source.add(DockFrontend.this.hider);
                } else {
                    this.source.remove(DockFrontend.this.hider);
                }
            }
        }

        public DefaultDockActionSource getSource() {
            return this.source;
        }

        public Dockable getDockable() {
            return this.dockable;
        }

        public void setDockable(Dockable dockable) {
            this.dockable = dockable;
        }

        public String getKey() {
            return this.key;
        }

        public void updateLocation() {
            RootInfo info = DockFrontend.this.getRoot(this.dockable);
            if (info == null) {
                return;
            }
            if (info.getStation() == this.dockable) {
                if (this.dockable.getDockParent() != null) {
                    info = DockFrontend.this.getRoot(this.dockable.getDockParent());
                    if (info == null) {
                        return;
                    }
                } else {
                    return;
                }
            }
            this.root = info.getName();
            this.location = DockUtilities.getPropertyChain(info.getStation(), this.dockable);
        }

        public void setLocation(String root, DockableProperty location) {
            this.root = root;
            this.location = location;
        }

        public String getRoot() {
            return this.root;
        }

        public DockableProperty getLocation() {
            return this.location;
        }

        public void setLayout(DockLayoutComposition layout) {
            this.layout = layout;
        }

        public DockLayoutComposition getLayout() {
            return this.layout;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Internals
    implements DockFrontendInternals {
        private Internals() {
        }

        @Override
        public void clean(DockSituationIgnore ignore) {
            DockFrontend.this.clean(ignore);
        }

        @Override
        public AdjacentDockFactory<?>[] getAdjacentDockFactories() {
            return DockFrontend.this.adjacentDockFactories.toArray(new AdjacentDockFactory[DockFrontend.this.adjacentDockFactories.size()]);
        }

        @Override
        public DockFactory<?, ?, ?>[] getBackupDockFactories() {
            return DockFrontend.this.backupDockFactories.toArray(new DockFactory[DockFrontend.this.backupDockFactories.size()]);
        }

        @Override
        public DockFactory<?, ?, ?>[] getDockFactories() {
            return DockFrontend.this.dockFactories.toArray(new DockFactory[DockFrontend.this.dockFactories.size()]);
        }

        @Override
        public DockInfo[] getDockables() {
            return DockFrontend.this.dockables.values().toArray(new DockInfo[DockFrontend.this.dockables.size()]);
        }

        @Override
        public DockFrontend getFrontend() {
            return DockFrontend.this;
        }

        @Override
        public DockInfo getInfo(String key) {
            return DockFrontend.this.getInfo(key);
        }

        @Override
        public DockInfo getInfo(Dockable dockable) {
            return DockFrontend.this.getInfo(dockable);
        }

        @Override
        public MissingDockableStrategy getMissingDockableStrategy() {
            return DockFrontend.this.getMissingDockable();
        }

        @Override
        public DockablePropertyFactory[] getPropertyFactories() {
            return DockFrontend.this.propertyFactories.toArray(new DockablePropertyFactory[DockFrontend.this.propertyFactories.size()]);
        }

        @Override
        public RootInfo[] getRoots() {
            return DockFrontend.this.roots.values().toArray(new RootInfo[DockFrontend.this.roots.size()]);
        }

        @Override
        public VetoManager getVetos() {
            return DockFrontend.this.veto;
        }
    }
}

