/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.parser_tree;

import java.io.IOException;
import java.io.InputStream;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.xbup.core.block.XBBlock;
import org.exbin.xbup.core.block.XBBlockDataMode;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.XBDefaultDocument;
import org.exbin.xbup.core.block.XBDocument;
import org.exbin.xbup.core.block.XBEditableBlock;
import org.exbin.xbup.core.block.XBEditableDocument;
import org.exbin.xbup.core.parser.XBParserState;
import org.exbin.xbup.core.parser.XBParsingException;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.basic.XBListener;
import org.exbin.xbup.core.parser.basic.convert.XBSkipBlockListener;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.type.XBData;
import org.exbin.xbup.core.ubnumber.UBNatural;

public class XBTreeReader
implements XBListener {
    private XBDocument target;
    private XBEditableBlock block;
    private final boolean recursive;
    private final boolean allowTailData;
    private boolean finished;
    private XBParserState parserState;
    private XBSkipBlockListener skipNode;
    private long level;

    public XBTreeReader(XBDocument target) {
        this(target, true, true);
    }

    public XBTreeReader(XBDocument target, boolean recursive, boolean allowTailData) {
        this.target = target;
        this.block = target.getRootBlock().orElse(null);
        this.recursive = recursive;
        this.allowTailData = allowTailData;
        this.finished = false;
        if (!recursive) {
            this.skipNode = new XBSkipBlockListener();
        }
        this.parserState = XBParserState.START;
        this.level = 0L;
    }

    public XBTreeReader(XBEditableBlock block) {
        this((XBDocument)new XBDefaultDocument((XBBlock)block), true, false);
    }

    public void beginXB(XBBlockTerminationMode terminationMode) throws XBProcessingException, IOException {
        if (this.finished) {
            throw new XBParsingException("Block already parsed", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (!this.recursive && !this.skipNode.isSkipped()) {
            this.skipNode.beginXB(terminationMode);
            return;
        }
        if (this.parserState == XBParserState.START) {
            if (!this.recursive) {
                if (this.block.getDataMode() == XBBlockDataMode.NODE_BLOCK) {
                    this.block.setAttributesCount(0);
                } else {
                    this.block.setData((BinaryData)new XBData());
                }
            } else {
                this.block.clear();
            }
            this.block.setTerminationMode(terminationMode);
            this.parserState = XBParserState.BLOCK_BEGIN;
        } else if (this.parserState == XBParserState.ATTRIBUTE_PART || this.parserState == XBParserState.BLOCK_END) {
            if (!this.recursive) {
                throw new XBParsingException("Parser invalid state", XBProcessingExceptionType.UNKNOWN);
            }
            XBEditableBlock node = (XBEditableBlock)this.block.createNewChild(this.block.getChildrenCount());
            node.setParent((XBBlock)this.block);
            node.setTerminationMode(terminationMode);
            ++this.level;
            this.block = node;
            this.parserState = XBParserState.BLOCK_BEGIN;
        } else {
            throw new XBParsingException("Unexpected block begin event", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
    }

    public void attribXB(XBAttribute value) throws XBProcessingException, IOException {
        if (this.finished) {
            throw new XBParsingException("Block already parsed", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (!this.recursive && !this.skipNode.isSkipped()) {
            this.skipNode.attribXB((XBAttribute)((UBNatural)value));
            return;
        }
        if (this.parserState == XBParserState.BLOCK_BEGIN) {
            this.block.setAttributesCount(0);
            this.parserState = XBParserState.ATTRIBUTE_PART;
        }
        if (this.parserState != XBParserState.ATTRIBUTE_PART) {
            throw new XBParsingException("Unexpected attribute event", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        this.block.setAttributeAt(value, this.block.getAttributesCount());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dataXB(InputStream data) throws XBProcessingException, IOException {
        if (this.finished) {
            throw new XBParsingException("Block already parsed", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (!this.recursive && !this.skipNode.isSkipped()) {
            this.skipNode.dataXB(data);
            return;
        }
        if (this.level == 0L && (this.parserState == XBParserState.ATTRIBUTE_PART || this.parserState == XBParserState.DATA_PART || this.parserState == XBParserState.BLOCK_END)) {
            if (!this.allowTailData) throw new XBParsingException("Unexpected data event for tail data", XBProcessingExceptionType.UNEXPECTED_ORDER);
            ((XBEditableDocument)this.target).setTailData(data);
            this.parserState = XBParserState.TAIL_DATA;
            return;
        } else {
            if (this.parserState != XBParserState.BLOCK_BEGIN) throw new XBParsingException("Unexpected data event", XBProcessingExceptionType.UNEXPECTED_ORDER);
            this.parserState = XBParserState.DATA_PART;
            this.block.setDataMode(XBBlockDataMode.DATA_BLOCK);
            this.block.setData(data);
        }
    }

    public void endXB() throws XBProcessingException, IOException {
        if (this.finished) {
            throw new XBParsingException("Block already parsed", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (!this.recursive && !this.skipNode.isSkipped()) {
            this.skipNode.endXB();
            return;
        }
        if (this.parserState == XBParserState.DATA_PART || this.parserState == XBParserState.ATTRIBUTE_PART || this.parserState == XBParserState.BLOCK_END || this.parserState == XBParserState.TAIL_DATA) {
            this.parserState = XBParserState.BLOCK_END;
            if (this.level > 0L) {
                --this.level;
                this.block = this.block.getParentBlock().orElse(null);
                return;
            }
            this.finished = true;
            this.parserState = XBParserState.EOF;
            return;
        }
        throw new XBParsingException("Unexpected block end event", XBProcessingExceptionType.UNEXPECTED_ORDER);
    }

    public boolean isClosed() {
        return this.finished;
    }
}

