/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.parser_tree;

import java.io.IOException;
import org.exbin.xbup.core.block.XBBlockDataMode;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.block.XBTDefaultDocument;
import org.exbin.xbup.core.block.XBTDocument;
import org.exbin.xbup.core.parser.XBParserState;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.basic.XBTListener;
import org.exbin.xbup.core.parser.basic.XBTProvider;

public class XBTTreeWriter
implements XBTProvider {
    private final XBTDocument source;
    private XBTBlock block;
    private XBParserState state = XBParserState.BLOCK_BEGIN;
    private int attrPosition = 0;
    private int childPosition = 0;
    private XBTTreeWriter subProducer = null;

    public XBTTreeWriter(XBTDocument source) {
        this.source = source;
        this.block = source.getRootBlock().orElse(null);
    }

    public XBTTreeWriter(XBTBlock sourceBlock) {
        this((XBTDocument)new XBTDefaultDocument(sourceBlock));
    }

    public void produceXBT(XBTListener listener) throws XBProcessingException, IOException {
        if (this.subProducer != null) {
            if (!this.subProducer.isFinished()) {
                this.subProducer.produceXBT(listener);
                return;
            }
            this.subProducer = null;
        }
        switch (this.state) {
            case BLOCK_BEGIN: {
                listener.beginXBT(this.block.getTerminationMode());
                this.state = this.block.getDataMode() == XBBlockDataMode.DATA_BLOCK ? XBParserState.DATA_PART : XBParserState.BLOCK_TYPE;
                break;
            }
            case DATA_PART: {
                listener.dataXBT(this.block.getData());
                this.state = XBParserState.BLOCK_END;
                break;
            }
            case BLOCK_TYPE: {
                listener.typeXBT(this.block.getBlockType());
                this.state = XBParserState.ATTRIBUTE_PART;
                break;
            }
            case ATTRIBUTE_PART: {
                if (this.attrPosition < this.block.getAttributesCount()) {
                    listener.attribXBT(this.block.getAttributeAt(this.attrPosition));
                    ++this.attrPosition;
                    break;
                }
                this.state = XBParserState.CHILDREN_PART;
            }
            case CHILDREN_PART: {
                if (this.childPosition < this.block.getChildrenCount()) {
                    this.subProducer = new XBTTreeWriter(this.block.getChildAt(this.childPosition));
                    ++this.childPosition;
                    this.subProducer.produceXBT(listener);
                    break;
                }
                this.state = XBParserState.BLOCK_END;
            }
            case BLOCK_END: {
                listener.endXBT();
                this.state = XBParserState.EOF;
                break;
            }
            case EOF: {
                throw new XBProcessingException("Reading after block end", XBProcessingExceptionType.READING_AFTER_END);
            }
            default: {
                throw new XBProcessingException("Unexpected state", XBProcessingExceptionType.UNEXPECTED_ORDER);
            }
        }
    }

    public boolean isFinished() {
        return this.state == XBParserState.EOF;
    }
}

