/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.parser_tree;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.exbin.xbup.core.block.XBBlock;
import org.exbin.xbup.core.block.XBEditableDocument;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.block.XBTDocument;
import org.exbin.xbup.core.block.XBTEditableDocument;
import org.exbin.xbup.parser_tree.XBBlockToXBTBlock;
import org.exbin.xbup.parser_tree.XBTBlockToXBBlock;

public class XBTDocumentToXBDocument
implements XBEditableDocument {
    private final XBTDocument document;

    public XBTDocumentToXBDocument(XBTDocument document) {
        this.document = document;
    }

    @Nonnull
    public Optional<XBBlock> getRootBlock() {
        XBTBlock rootBlock = (XBTBlock)this.document.getRootBlock().get();
        if (rootBlock instanceof XBBlockToXBTBlock) {
            return Optional.of(((XBBlockToXBTBlock)rootBlock).getBlock());
        }
        return Optional.of(new XBTBlockToXBBlock(rootBlock));
    }

    @Nonnull
    public Optional<InputStream> getTailData() {
        return this.document.getTailData();
    }

    public long getTailDataSize() {
        return this.document.getTailDataSize();
    }

    public void setRootBlock(XBBlock block) {
        if (!(this.document instanceof XBTEditableDocument)) {
            throw new IllegalStateException("Cannot set root of read only document");
        }
        if (block instanceof XBTBlockToXBBlock) {
            ((XBTEditableDocument)this.document).setRootBlock(((XBTBlockToXBBlock)block).getBlock());
        } else {
            ((XBTEditableDocument)this.document).setRootBlock((XBTBlock)(block == null ? null : new XBBlockToXBTBlock(block)));
        }
    }

    public void setTailData(InputStream source) throws IOException {
        if (!(this.document instanceof XBTEditableDocument)) {
            throw new IllegalStateException("Cannot set tail data of read only document");
        }
        ((XBTEditableDocument)this.document).setTailData(source);
    }

    public void clear() {
        if (!(this.document instanceof XBTEditableDocument)) {
            throw new IllegalStateException("Cannot clear read only document");
        }
        ((XBTEditableDocument)this.document).clear();
    }

    public long getDocumentSize() {
        return this.document.getDocumentSize();
    }
}

