/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.parser_tree;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBBlock;
import org.exbin.xbup.core.block.XBDocument;
import org.exbin.xbup.core.block.XBEditableDocument;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.block.XBTEditableDocument;
import org.exbin.xbup.parser_tree.XBBlockToXBTBlock;
import org.exbin.xbup.parser_tree.XBTBlockToXBBlock;

@ParametersAreNonnullByDefault
public class XBDocumentToXBTDocument
implements XBTEditableDocument {
    private final XBDocument document;

    public XBDocumentToXBTDocument(XBDocument document) {
        this.document = document;
    }

    @Nonnull
    public Optional<XBTBlock> getRootBlock() {
        XBBlock rootBlock = (XBBlock)this.document.getRootBlock().get();
        if (rootBlock instanceof XBTBlockToXBBlock) {
            return Optional.of(((XBTBlockToXBBlock)rootBlock).getBlock());
        }
        return Optional.of(new XBBlockToXBTBlock(rootBlock));
    }

    @Nonnull
    public Optional<InputStream> getTailData() {
        return this.document.getTailData();
    }

    public long getTailDataSize() {
        return this.document.getTailDataSize();
    }

    public void setRootBlock(XBTBlock block) {
        if (!(this.document instanceof XBEditableDocument)) {
            throw new IllegalStateException("Cannot set root of read only document");
        }
        if (block instanceof XBBlockToXBTBlock) {
            ((XBEditableDocument)this.document).setRootBlock(((XBBlockToXBTBlock)block).getBlock());
        } else {
            ((XBEditableDocument)this.document).setRootBlock((XBBlock)(block == null ? null : new XBTBlockToXBBlock(block)));
        }
    }

    public void setTailData(InputStream source) throws IOException {
        if (!(this.document instanceof XBEditableDocument)) {
            throw new IllegalStateException("Cannot set tail data of read only document");
        }
        ((XBEditableDocument)this.document).setTailData(source);
    }

    @Nonnull
    public Optional<XBTBlock> findBlockByIndex(long index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public XBTBlock createNewBlock(XBTBlock parent) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void clear() {
        if (!(this.document instanceof XBEditableDocument)) {
            throw new IllegalStateException("Cannot clear read only document");
        }
        ((XBEditableDocument)this.document).clear();
    }

    public long getDocumentSize() {
        return this.document.getDocumentSize();
    }
}

