/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.parser_tree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.exbin.xbup.core.block.XBBasicBlockType;
import org.exbin.xbup.core.block.XBBlockDataMode;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.XBFixedBlockType;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.block.XBTEditableBlock;
import org.exbin.xbup.core.block.declaration.XBBlockDecl;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.block.declaration.catalog.XBCBlockDecl;
import org.exbin.xbup.core.block.definition.XBBlockDef;
import org.exbin.xbup.core.block.definition.XBBlockParam;
import org.exbin.xbup.core.block.definition.XBRevisionDef;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.basic.XBTListener;
import org.exbin.xbup.core.parser.param.XBParamListProcessingState;
import org.exbin.xbup.core.parser.param.XBParamProcessingState;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.parser.token.XBTAttributeToken;
import org.exbin.xbup.core.parser.token.XBTBeginToken;
import org.exbin.xbup.core.parser.token.XBTEndToken;
import org.exbin.xbup.core.parser.token.XBTToken;
import org.exbin.xbup.core.parser.token.XBTTypeToken;
import org.exbin.xbup.core.parser.token.convert.XBTListenerToToken;
import org.exbin.xbup.core.parser.token.event.XBTEventListener;
import org.exbin.xbup.core.parser.token.pull.XBTPullProvider;
import org.exbin.xbup.core.ubnumber.UBENatural;
import org.exbin.xbup.core.ubnumber.type.UBENat32;
import org.exbin.xbup.core.ubnumber.type.UBNat32;
import org.exbin.xbup.parser_tree.XBTTreeNode;
import org.exbin.xbup.parser_tree.XBTTreeReader;
import org.exbin.xbup.parser_tree.XBTTreeWriter;

public class XBATreeParamExtractor
implements XBTPullProvider,
XBTEventListener {
    private final XBTBlock source;
    private final List<ProcessingState> processingStates = new ArrayList<ProcessingState>();
    private XBParamProcessingState currentProcessingState;
    private XBParamListProcessingState currentListProcessingState;
    private int currentParameter;
    private XBBlockParam parameterType = null;
    private ParameterInfo currentParameterInfo;
    private XBTTreeWriter childWriter;
    private XBTTreeReader childReader;
    private final XBTListenerToToken childConvertor = new XBTListenerToToken();
    private final ParameterInfo position;

    public XBATreeParamExtractor(XBTBlock source, XBACatalog catalog) {
        this.source = source;
        this.position = new ParameterInfo();
        XBBlockType blockType = source.getBlockType();
        if (!(blockType instanceof XBDeclBlockType)) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        this.position.blockDecl = ((XBDeclBlockType)blockType).getBlockDecl();
        this.reset();
    }

    private void reset() {
        this.currentParameter = 0;
        this.currentParameterInfo = null;
        this.position.attributeCount = 0;
        this.position.childCount = 0;
        this.currentProcessingState = XBParamProcessingState.BEGIN;
        this.currentListProcessingState = XBParamListProcessingState.BEGIN;
        this.childWriter = null;
        this.childReader = null;
    }

    public XBTToken pullXBTToken() throws XBProcessingException, IOException {
        XBBlockDef blockDef;
        if (this.childWriter != null) {
            return this.getChildToken();
        }
        if (this.parameterType == null && (blockDef = this.position.blockDecl.getBlockDef()) != null) {
            this.parameterType = blockDef.getBlockParam(this.currentParameter);
            if (this.parameterType == null) {
                throw new XBProcessingException("Unable to process parameter " + this.currentParameter, XBProcessingExceptionType.UNSUPPORTED);
            }
        }
        switch (this.parameterType.getParamType()) {
            case JOIN: {
                switch (this.currentProcessingState) {
                    case BEGIN: {
                        if (this.currentParameterInfo == null) {
                            this.currentParameterInfo = this.processParameterInfo();
                            this.currentProcessingState = XBParamProcessingState.TYPE;
                            return XBTBeginToken.create((XBBlockTerminationMode)XBBlockTerminationMode.SIZE_SPECIFIED);
                        }
                        throw new XBProcessingException("Parameter already processed", XBProcessingExceptionType.READING_AFTER_END);
                    }
                    case TYPE: {
                        this.currentProcessingState = this.currentParameterInfo.isEmpty() ? XBParamProcessingState.END : (this.currentParameterInfo.attributeCount > 0 ? XBParamProcessingState.ATTRIBUTES : XBParamProcessingState.CHILDREN);
                        return XBTTypeToken.create((XBBlockType)new XBDeclBlockType(this.currentParameterInfo.blockDecl));
                    }
                    case ATTRIBUTES: {
                        if (this.currentParameterInfo.attributeCount > 0) {
                            --this.currentParameterInfo.attributeCount;
                            if (this.currentParameterInfo.attributeCount == 0) {
                                this.currentProcessingState = this.currentParameterInfo.childCount > 0 ? XBParamProcessingState.CHILDREN : XBParamProcessingState.END;
                            }
                            return this.getNextAttributeToken();
                        }
                    }
                    case CHILDREN: {
                        if (this.currentParameterInfo.childCount > 0) {
                            if (this.currentParameterInfo.childCount == 1) {
                                this.currentProcessingState = XBParamProcessingState.END;
                            }
                            this.childWriter = new XBTTreeWriter((XBTBlock)this.getNextChild());
                            return this.getChildToken();
                        }
                        throw new IllegalStateException();
                    }
                    case END: {
                        this.currentProcessingState = XBParamProcessingState.BEGIN;
                        return XBTEndToken.create();
                    }
                }
                break;
            }
            case CONSIST: {
                if (this.currentParameterInfo == null) {
                    this.currentParameterInfo = this.processParameterInfo();
                    this.childWriter = new XBTTreeWriter((XBTBlock)this.getNextChild());
                    return this.getChildToken();
                }
                throw new XBProcessingException("Parameter already processed", XBProcessingExceptionType.READING_AFTER_END);
            }
            case LIST_JOIN: {
                UBENat32 listSize;
                switch (this.currentListProcessingState) {
                    case BEGIN: {
                        if (this.currentParameterInfo == null) {
                            this.currentParameterInfo = this.processParameterInfo();
                            this.currentListProcessingState = XBParamListProcessingState.TYPE;
                            return XBTBeginToken.create((XBBlockTerminationMode)XBBlockTerminationMode.SIZE_SPECIFIED);
                        }
                        throw new XBProcessingException("Parameter already processed", XBProcessingExceptionType.READING_AFTER_END);
                    }
                    case TYPE: {
                        this.currentListProcessingState = XBParamListProcessingState.LIST_SIZE;
                        return XBTTypeToken.create((XBBlockType)new XBFixedBlockType(XBBasicBlockType.UNKNOWN_BLOCK));
                    }
                    case LIST_SIZE: {
                        listSize = new UBNat32(this.currentParameterInfo.listSize);
                        XBParamListProcessingState xBParamListProcessingState = this.currentListProcessingState = this.currentParameterInfo.listSize == 0 ? XBParamListProcessingState.END : XBParamListProcessingState.ITEMS;
                        if (this.currentParameterInfo.attributeCount == 0) {
                            throw new IllegalStateException();
                        }
                        --this.currentParameterInfo.attributeCount;
                        return XBTAttributeToken.create((XBAttribute)listSize);
                    }
                    case ITEMS: {
                        if (this.currentParameterInfo.listSize >= 0) {
                            switch (this.currentProcessingState) {
                                case BEGIN: {
                                    this.currentParameterInfo = this.processParameterInfo();
                                    this.currentProcessingState = XBParamProcessingState.TYPE;
                                    return XBTBeginToken.create((XBBlockTerminationMode)XBBlockTerminationMode.SIZE_SPECIFIED);
                                }
                                case TYPE: {
                                    this.currentProcessingState = this.currentParameterInfo.isEmpty() ? XBParamProcessingState.END : (this.currentParameterInfo.attributeCount > 0 ? XBParamProcessingState.ATTRIBUTES : XBParamProcessingState.CHILDREN);
                                    return XBTTypeToken.create((XBBlockType)new XBDeclBlockType(this.currentParameterInfo.blockDecl));
                                }
                                case ATTRIBUTES: {
                                    if (this.currentParameterInfo.attributeCount > 0) {
                                        --this.currentParameterInfo.attributeCount;
                                        if (this.currentParameterInfo.attributeCount == 0) {
                                            this.currentProcessingState = this.currentParameterInfo.childCount > 0 ? XBParamProcessingState.CHILDREN : XBParamProcessingState.END;
                                        }
                                        return this.getNextAttributeToken();
                                    }
                                }
                                case CHILDREN: {
                                    if (this.currentParameterInfo.childCount > 0) {
                                        if (this.currentParameterInfo.childCount == 1) {
                                            this.currentProcessingState = XBParamProcessingState.END;
                                        }
                                        this.childWriter = new XBTTreeWriter((XBTBlock)this.getNextChild());
                                        return this.getChildToken();
                                    }
                                    throw new IllegalStateException();
                                }
                                case END: {
                                    this.currentProcessingState = XBParamProcessingState.BEGIN;
                                    --this.currentParameterInfo.listSize;
                                    if (this.currentParameterInfo.listSize == 0) {
                                        this.currentListProcessingState = XBParamListProcessingState.END;
                                    }
                                    return XBTEndToken.create();
                                }
                            }
                        }
                    }
                    case END: {
                        this.currentListProcessingState = XBParamListProcessingState.BEGIN;
                        return XBTEndToken.create();
                    }
                }
                break;
            }
            case LIST_CONSIST: {
                UBENat32 listSize;
                switch (this.currentListProcessingState) {
                    case BEGIN: {
                        if (this.currentParameterInfo == null) {
                            this.currentParameterInfo = this.processParameterInfo();
                            this.currentListProcessingState = XBParamListProcessingState.TYPE;
                            return XBTBeginToken.create((XBBlockTerminationMode)XBBlockTerminationMode.SIZE_SPECIFIED);
                        }
                        throw new XBProcessingException("Parameter already processed", XBProcessingExceptionType.READING_AFTER_END);
                    }
                    case TYPE: {
                        this.currentListProcessingState = XBParamListProcessingState.LIST_SIZE;
                        return XBTTypeToken.create((XBBlockType)new XBFixedBlockType(XBBasicBlockType.UNKNOWN_BLOCK));
                    }
                    case LIST_SIZE: {
                        listSize = new UBENat32();
                        if (this.currentParameterInfo.listSize >= 0) {
                            listSize.setValue(this.currentParameterInfo.listSize);
                        } else {
                            listSize.setInfinity();
                        }
                        XBParamListProcessingState xBParamListProcessingState = this.currentListProcessingState = this.currentParameterInfo.listSize == 0 ? XBParamListProcessingState.END : XBParamListProcessingState.ITEMS;
                        if (this.currentParameterInfo.attributeCount == 0) {
                            throw new IllegalStateException();
                        }
                        --this.currentParameterInfo.attributeCount;
                        return XBTAttributeToken.create((XBAttribute)listSize.convertToNatural());
                    }
                    case ITEMS: {
                        if (this.currentParameterInfo.listSize >= 0) {
                            this.childWriter = new XBTTreeWriter((XBTBlock)this.getNextChild());
                            --this.currentParameterInfo.listSize;
                            if (this.currentParameterInfo.listSize == 0) {
                                this.currentListProcessingState = XBParamListProcessingState.END;
                            }
                            return this.getChildToken();
                        }
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                    case END: {
                        this.currentListProcessingState = XBParamListProcessingState.BEGIN;
                        return XBTEndToken.create();
                    }
                }
            }
        }
        throw new XBProcessingException("Unexpected processing state", XBProcessingExceptionType.UNKNOWN);
    }

    public void putXBTToken(XBTToken token) throws XBProcessingException, IOException {
        XBBlockDef blockDef;
        if (this.childReader != null) {
            XBTListenerToToken.tokenToListener((XBTToken)token, (XBTListener)this.childReader);
            if (this.childReader.isClosed()) {
                this.childReader = null;
                --this.currentParameterInfo.childCount;
            }
            return;
        }
        if (this.parameterType == null && (blockDef = this.position.blockDecl.getBlockDef()) != null) {
            this.parameterType = blockDef.getBlockParam(this.currentParameter);
            if (this.parameterType == null) {
                throw new XBProcessingException("Unable to process parameter " + this.currentParameter, XBProcessingExceptionType.UNSUPPORTED);
            }
        }
        switch (this.parameterType.getParamType()) {
            case JOIN: {
                switch (token.getTokenType()) {
                    case BEGIN: {
                        if (this.currentProcessingState == XBParamProcessingState.BEGIN) {
                            if (this.currentParameterInfo == null) {
                                this.currentParameterInfo = this.processParameterInfo();
                                this.currentProcessingState = XBParamProcessingState.TYPE;
                                return;
                            }
                            throw new XBProcessingException("Parameter already processed", XBProcessingExceptionType.READING_AFTER_END);
                        }
                        if (this.currentProcessingState == XBParamProcessingState.ATTRIBUTES) {
                            if (this.currentParameterInfo == null || this.currentParameterInfo.attributeCount == 0) {
                                throw new IllegalStateException();
                            }
                            this.currentProcessingState = XBParamProcessingState.CHILDREN;
                            throw new UnsupportedOperationException("Not supported yet.");
                        }
                        if (this.currentProcessingState == XBParamProcessingState.CHILDREN) {
                            this.childReader = new XBTTreeReader(this.getNextChild());
                            this.childReader.beginXBT(((XBTBeginToken)token).getTerminationMode());
                            return;
                        }
                        throw new XBProcessingException("Unexpected join processing order", XBProcessingExceptionType.UNEXPECTED_ORDER);
                    }
                    case TYPE: {
                        if (this.currentProcessingState == XBParamProcessingState.TYPE) {
                            this.currentProcessingState = this.currentParameterInfo.isEmpty() ? XBParamProcessingState.END : (this.currentParameterInfo.attributeCount > 0 ? XBParamProcessingState.ATTRIBUTES : XBParamProcessingState.CHILDREN);
                            return;
                        }
                        throw new XBProcessingException("Unexpected join processing order", XBProcessingExceptionType.UNEXPECTED_ORDER);
                    }
                    case ATTRIBUTE: {
                        if (this.currentProcessingState != XBParamProcessingState.ATTRIBUTES) break;
                        this.setNextAttributeToken(((XBTAttributeToken)token).getAttribute());
                        --this.currentParameterInfo.attributeCount;
                        return;
                    }
                    case DATA: {
                        throw new IllegalStateException("Unexpected data node");
                    }
                    case END: {
                        if (this.currentProcessingState == XBParamProcessingState.ATTRIBUTES || this.currentProcessingState == XBParamProcessingState.CHILDREN) {
                            while (this.currentParameterInfo.attributeCount > 0) {
                                UBNat32 zeroAttribute = new UBNat32();
                                this.setNextAttributeToken((XBAttribute)zeroAttribute);
                                --this.currentParameterInfo.attributeCount;
                            }
                            if (this.currentParameterInfo.childCount > 0) {
                                throw new UnsupportedOperationException("Not supported yet.");
                            }
                            this.currentProcessingState = XBParamProcessingState.END;
                            return;
                        }
                        throw new XBProcessingException("Unexpected join processing order", XBProcessingExceptionType.UNEXPECTED_ORDER);
                    }
                }
                throw new IllegalStateException();
            }
            case CONSIST: {
                if (this.currentParameterInfo == null) {
                    this.currentParameterInfo = this.processParameterInfo();
                    this.childReader = new XBTTreeReader(this.getNextChild());
                    XBTListenerToToken.tokenToListener((XBTToken)token, (XBTListener)this.childReader);
                    return;
                }
                throw new XBProcessingException("Parameter already processed", XBProcessingExceptionType.READING_AFTER_END);
            }
            case LIST_JOIN: {
                throw new UnsupportedOperationException("Not supported yet.");
            }
            case LIST_CONSIST: {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        }
        throw new XBProcessingException("Unexpected processing state", XBProcessingExceptionType.UNKNOWN);
    }

    private XBTToken getChildToken() throws XBProcessingException, IOException {
        this.childWriter.produceXBT((XBTListener)this.childConvertor);
        if (this.childWriter.isFinished()) {
            this.childWriter = null;
            --this.currentParameterInfo.childCount;
        }
        return this.childConvertor.getToken();
    }

    private ParameterInfo processParameterInfo() {
        this.processingStates.clear();
        ParameterInfo parameterInfo = new ParameterInfo();
        ProcessingState processingState = new ProcessingState(null);
        XBBlockDef blockDef = this.position.blockDecl.getBlockDef();
        if (blockDef != null) {
            XBBlockDecl blockDecl;
            XBBlockParam paramParam = blockDef.getBlockParam(this.currentParameter);
            processingState.blockDecl = blockDecl = paramParam.getBlockDecl();
            parameterInfo.blockDecl = blockDecl;
            int parametersCount = 0;
            if (blockDecl != null) {
                XBRevisionDef paramRevisionDef;
                long revision = blockDecl.getRevision();
                XBBlockDef paramBlockDef = processingState.blockDecl.getBlockDef();
                if (paramBlockDef != null && (paramRevisionDef = paramBlockDef.getRevisionDef()) != null) {
                    parametersCount = paramRevisionDef.getRevisionLimit(revision);
                }
            }
            processingState.parametersCount = parametersCount;
            this.processingStates.add(processingState);
            this.processState(parameterInfo);
        }
        return parameterInfo;
    }

    private XBTToken getNextAttributeToken() {
        if (this.position.attributeCount >= this.source.getAttributesCount()) {
            ++this.position.attributeCount;
            return XBTAttributeToken.createZeroToken();
        }
        XBTAttributeToken attributeToken = XBTAttributeToken.create((XBAttribute)this.source.getAttributeAt(this.position.attributeCount));
        ++this.position.attributeCount;
        return attributeToken;
    }

    private void setNextAttributeToken(XBAttribute attribute) {
        ((XBTEditableBlock)this.source).setAttributeAt(attribute, this.position.attributeCount);
        ++this.position.attributeCount;
    }

    private XBTTreeNode getNextChild() {
        if (this.position.childCount >= this.source.getChildrenCount()) {
            XBTTreeNode emptyNode = new XBTTreeNode();
            emptyNode.setDataMode(XBBlockDataMode.DATA_BLOCK);
            ++this.position.childCount;
            return emptyNode;
        }
        XBTTreeNode childNode = (XBTTreeNode)this.source.getChildAt(this.position.childCount);
        ++this.position.childCount;
        return childNode;
    }

    public void setParameterIndex(int targetParameter) throws XBProcessingException {
        if (targetParameter <= this.currentParameter) {
            this.reset();
        }
        if (targetParameter > this.currentParameter) {
            if (this.currentParameterInfo != null) {
                this.position.attributeCount += this.currentParameterInfo.attributeCount;
                this.position.childCount += this.currentParameterInfo.childCount;
                ++this.currentParameter;
                this.currentParameterInfo = null;
            }
            while (targetParameter > this.currentParameter) {
                ParameterInfo parameterInfo = this.processParameterInfo();
                this.position.attributeCount += parameterInfo.attributeCount;
                this.position.childCount += parameterInfo.childCount;
                ++this.currentParameter;
            }
            this.currentProcessingState = XBParamProcessingState.BEGIN;
            this.currentListProcessingState = XBParamListProcessingState.BEGIN;
        }
        this.parameterType = null;
        this.currentParameterInfo = null;
    }

    private void processState(ParameterInfo parameterInfo) {
        while (true) {
            XBBlockDef blockDef;
            XBBlockParam blockParam;
            ProcessingState processingState = this.processingStates.get(this.processingStates.size() - 1);
            if (processingState.processingParameter < processingState.parametersCount && (blockParam = (blockDef = processingState.blockDecl.getBlockDef()).getBlockParam(processingState.processingParameter)) != null) {
                switch (blockParam.getParamType()) {
                    case CONSIST: {
                        ++parameterInfo.childCount;
                        break;
                    }
                    case JOIN: {
                        XBBlockDecl blockDecl = blockParam.getBlockDecl();
                        if (!(blockDecl instanceof XBCBlockDecl)) break;
                        ProcessingState joinState = new ProcessingState((XBBlockDecl)((XBCBlockDecl)blockParam.getBlockDecl()));
                        if (joinState.blockDecl instanceof XBCBlockDecl && ((XBCBlockDecl)joinState.blockDecl).getBlockSpecRev() == null) {
                            ++parameterInfo.attributeCount;
                            break;
                        }
                        long revision = joinState.blockDecl.getRevision();
                        joinState.parametersCount = joinState.blockDecl.getBlockDef().getRevisionDef().getRevisionLimit(revision);
                        this.processingStates.add(joinState);
                        break;
                    }
                    case LIST_CONSIST: {
                        UBENatural listSizeNat;
                        XBAttribute attribute = this.source.getAttributeAt(this.position.attributeCount + parameterInfo.attributeCount);
                        if (attribute instanceof UBENatural) {
                            listSizeNat = (UBENatural)attribute;
                        } else {
                            listSizeNat = new UBENat32();
                            listSizeNat.convertFromNatural(attribute.convertToNatural());
                        }
                        ++parameterInfo.attributeCount;
                        if (!listSizeNat.isInfinity()) {
                            parameterInfo.childCount += listSizeNat.getInt();
                        } else {
                            throw new UnsupportedOperationException("Not supported yet.");
                        }
                    }
                    case LIST_JOIN: {
                        long revision;
                        ProcessingState joinState;
                        ++parameterInfo.attributeCount;
                        for (int listSize = this.source.getAttributeAt(this.position.attributeCount + parameterInfo.attributeCount).getNaturalInt(); listSize > 0; --listSize) {
                            joinState = new ProcessingState((XBBlockDecl)((XBCBlockDecl)blockParam.getBlockDecl()));
                            if (joinState.blockDecl instanceof XBCBlockDecl && ((XBCBlockDecl)joinState.blockDecl).getBlockSpecRev() == null) {
                                ++parameterInfo.attributeCount;
                                continue;
                            }
                            revision = joinState.blockDecl.getRevision();
                            joinState.parametersCount = joinState.blockDecl.getBlockDef().getRevisionDef().getRevisionLimit(revision);
                            this.processingStates.add(joinState);
                        }
                        break;
                    }
                }
            }
            if (processingState.processingParameter >= processingState.parametersCount) {
                if (this.processingStates.size() == 1) break;
                this.processingStates.remove(this.processingStates.size() - 1);
            }
            ++processingState.processingParameter;
        }
    }

    private static class ParameterInfo {
        XBBlockDecl blockDecl = null;
        int attributeCount = 0;
        int childCount = 0;
        int listSize;

        private ParameterInfo() {
        }

        boolean isEmpty() {
            return this.attributeCount == 0 && this.childCount == 0;
        }
    }

    private static class ProcessingState {
        XBBlockDecl blockDecl = null;
        int processingParameter = 0;
        int parametersCount = 0;

        ProcessingState(XBBlockDecl blockDecl) {
            this.blockDecl = blockDecl;
        }
    }
}

