/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.operation.undo;

import java.awt.Component;
import java.awt.Window;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.exbin.framework.action.api.ActionModuleApi;
import org.exbin.framework.action.api.MenuGroup;
import org.exbin.framework.action.api.MenuPosition;
import org.exbin.framework.action.api.PositionMode;
import org.exbin.framework.action.api.SeparationMode;
import org.exbin.framework.action.api.ToolBarGroup;
import org.exbin.framework.action.api.ToolBarPosition;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.operation.undo.action.BasicUndoActions;
import org.exbin.framework.operation.undo.api.OperationUndoModuleApi;
import org.exbin.framework.operation.undo.api.UndoActions;
import org.exbin.framework.operation.undo.api.UndoActionsHandler;
import org.exbin.framework.operation.undo.api.UndoUpdateListener;
import org.exbin.framework.operation.undo.gui.UndoManagerControlPanel;
import org.exbin.framework.operation.undo.gui.UndoManagerModel;
import org.exbin.framework.operation.undo.gui.UndoManagerPanel;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.xbup.operation.Command;
import org.exbin.xbup.operation.undo.XBUndoHandler;
import org.exbin.xbup.operation.undo.XBUndoUpdateListener;
import org.exbin.xbup.plugin.XBModuleHandler;

@ParametersAreNonnullByDefault
public class OperationUndoModule
implements OperationUndoModuleApi {
    private static final String UNDO_MENU_GROUP_ID = MODULE_ID + ".undoMenuGroup";
    private static final String UNDO_TOOL_BAR_GROUP_ID = MODULE_ID + ".undoToolBarGroup";
    private XBApplication application;
    private final UndoManagerModel undoModel = new UndoManagerModel();
    private XBUndoHandler undoHandler;
    private BasicUndoActions defaultUndoActions = null;

    public void init(XBModuleHandler moduleHandler) {
        this.application = (XBApplication)moduleHandler;
        this.undoModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                OperationUndoModule.this.updateUndoStatus();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
            }
        });
    }

    public void unregisterModule(String moduleId) {
    }

    public void actionEditUndo() {
        try {
            this.undoHandler.performUndo();
        }
        catch (Exception ex) {
            Logger.getLogger(OperationUndoModule.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void actionEditRedo() {
        try {
            this.undoHandler.performRedo();
        }
        catch (Exception ex) {
            Logger.getLogger(OperationUndoModule.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setUndoHandler(final XBUndoHandler undoHandler) {
        this.undoHandler = undoHandler;
        this.getDefaultUndoActions().setUndoActionsHandler(new UndoActionsHandler(){

            public boolean canUndo() {
                return undoHandler.canUndo();
            }

            public boolean canRedo() {
                return undoHandler.canRedo();
            }

            public void performUndo() {
                OperationUndoModule.this.actionEditUndo();
            }

            public void performRedo() {
                OperationUndoModule.this.actionEditRedo();
            }

            public void performUndoManager() {
                OperationUndoModule.this.openUndoManager();
            }

            public void setUndoUpdateListener(UndoUpdateListener undoUpdateListener) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        });
        this.undoModel.setUndoHandler(undoHandler);
        undoHandler.addUndoUpdateListener(new XBUndoUpdateListener(){

            public void undoCommandPositionChanged() {
                OperationUndoModule.this.updateUndoStatus();
            }

            public void undoCommandAdded(Command cmnd) {
            }
        });
    }

    public void updateUndoStatus() {
        this.getDefaultUndoActions().updateUndoActions();
    }

    public void registerMainMenu() {
        this.getDefaultUndoActions();
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuGroup(FrameModuleApi.EDIT_MENU_ID, new MenuGroup(UNDO_MENU_GROUP_ID, new MenuPosition(PositionMode.TOP), SeparationMode.BELOW));
        actionModule.registerMenuItem(FrameModuleApi.EDIT_MENU_ID, OperationUndoModuleApi.MODULE_ID, this.defaultUndoActions.getUndoAction(), new MenuPosition(UNDO_MENU_GROUP_ID));
        actionModule.registerMenuItem(FrameModuleApi.EDIT_MENU_ID, OperationUndoModuleApi.MODULE_ID, this.defaultUndoActions.getRedoAction(), new MenuPosition(UNDO_MENU_GROUP_ID));
    }

    public void registerUndoManagerInMainMenu() {
        this.getDefaultUndoActions();
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuItem(FrameModuleApi.EDIT_MENU_ID, OperationUndoModuleApi.MODULE_ID, this.defaultUndoActions.getUndoManagerAction(), new MenuPosition(UNDO_MENU_GROUP_ID));
    }

    public void registerMainToolBar() {
        this.getDefaultUndoActions();
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerToolBarGroup(FrameModuleApi.MAIN_TOOL_BAR_ID, new ToolBarGroup(UNDO_TOOL_BAR_GROUP_ID, new ToolBarPosition(PositionMode.TOP), SeparationMode.AROUND));
        actionModule.registerToolBarItem(FrameModuleApi.MAIN_TOOL_BAR_ID, MODULE_ID, this.defaultUndoActions.getUndoAction(), new ToolBarPosition(UNDO_TOOL_BAR_GROUP_ID));
        actionModule.registerToolBarItem(FrameModuleApi.MAIN_TOOL_BAR_ID, MODULE_ID, this.defaultUndoActions.getRedoAction(), new ToolBarPosition(UNDO_TOOL_BAR_GROUP_ID));
    }

    public XBUndoHandler getUndoHandler() {
        return this.undoHandler;
    }

    public void openUndoManager() {
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        UndoManagerPanel undoManagerPanel = new UndoManagerPanel(this.undoModel);
        UndoManagerControlPanel undoManagerControlPanel = new UndoManagerControlPanel();
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)undoManagerPanel, (JPanel)undoManagerControlPanel);
        frameModule.setDialogTitle(dialog, undoManagerPanel.getResourceBundle());
        undoManagerControlPanel.setHandler(actionType -> {
            dialog.close();
            dialog.dispose();
        });
        WindowUtils.addHeaderPanel((Window)dialog.getWindow(), undoManagerPanel.getClass(), (ResourceBundle)undoManagerPanel.getResourceBundle());
        dialog.showCentered((Component)frameModule.getFrame());
    }

    @Nonnull
    public UndoActions createUndoActions(UndoActionsHandler undoActionsHandler) {
        BasicUndoActions undoActions = new BasicUndoActions();
        undoActions.setUndoActionsHandler(undoActionsHandler);
        return undoActions;
    }

    @Nonnull
    public BasicUndoActions getDefaultUndoActions() {
        if (this.defaultUndoActions == null) {
            this.defaultUndoActions = new BasicUndoActions();
        }
        return this.defaultUndoActions;
    }
}

