/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.picture.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

public class ImageResizePanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(ImageResizePanel.class);
    private JLabel heightLabel;
    private JTextField heightTextField;
    private JPanel imageSizePanel;
    private JPanel resizeImagePanel;
    private JLabel widthLabel;
    private JTextField widthTextField;

    public ImageResizePanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.resizeImagePanel = new JPanel();
        this.imageSizePanel = new JPanel();
        this.widthLabel = new JLabel();
        this.widthTextField = new JTextField();
        this.heightLabel = new JLabel();
        this.heightTextField = new JTextField();
        this.setLayout(new BorderLayout());
        this.resizeImagePanel.setLayout(new GridLayout(1, 0));
        this.imageSizePanel.setBorder(BorderFactory.createTitledBorder(this.resourceBundle.getString("imageSizePanel.border.title")));
        this.widthLabel.setText(this.resourceBundle.getString("widthLabel.text"));
        this.heightLabel.setText(this.resourceBundle.getString("heightLabel.text"));
        GroupLayout imageSizePanelLayout = new GroupLayout(this.imageSizePanel);
        this.imageSizePanel.setLayout(imageSizePanelLayout);
        imageSizePanelLayout.setHorizontalGroup(imageSizePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, imageSizePanelLayout.createSequentialGroup().addContainerGap().addGroup(imageSizePanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.heightTextField, GroupLayout.Alignment.LEADING, -1, 378, Short.MAX_VALUE).addComponent(this.widthTextField, GroupLayout.Alignment.LEADING, -1, 378, Short.MAX_VALUE).addComponent(this.widthLabel, GroupLayout.Alignment.LEADING).addComponent(this.heightLabel, GroupLayout.Alignment.LEADING)).addContainerGap()));
        imageSizePanelLayout.setVerticalGroup(imageSizePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(imageSizePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.widthLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.widthTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.heightLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.heightTextField, -2, -1, -2).addContainerGap(178, Short.MAX_VALUE)));
        this.resizeImagePanel.add(this.imageSizePanel);
        this.add((Component)this.resizeImagePanel, "Center");
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResolution(Point point) {
        this.widthTextField.setText(Integer.toString((int)point.getX()));
        this.heightTextField.setText(Integer.toString((int)point.getY()));
    }

    public Point getResolution() {
        return new Point(Integer.valueOf(this.widthTextField.getText()), Integer.valueOf(this.heightTextField.getText()));
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new ImageResizePanel());
    }
}

