/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.options.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.frame.api.ApplicationFrameHandler;
import org.exbin.framework.options.api.OptionsComponent;
import org.exbin.framework.options.api.OptionsData;
import org.exbin.framework.options.api.OptionsModifiedListener;
import org.exbin.framework.options.api.OptionsModuleApi;
import org.exbin.framework.options.api.OptionsPage;
import org.exbin.framework.options.api.OptionsPathItem;
import org.exbin.framework.options.gui.AppearanceOptionsPanel;
import org.exbin.framework.options.gui.MainOptionsPanel;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.LazyComponentListener;
import org.exbin.framework.utils.LazyComponentsIssuable;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class OptionsTreePanel
extends JPanel
implements LazyComponentsIssuable {
    private Preferences preferences = null;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(OptionsTreePanel.class);
    private Map<String, PageRecord<?>> optionPages;
    private PageRecord<?> currentOptionsPanel = null;
    private OptionsModifiedListener optionsModifiedListener;
    private final List<LazyComponentListener> listeners = new ArrayList<LazyComponentListener>();
    private boolean modified;
    private OptionsMutableTreeNode top;
    private XBApplication application;
    private final ApplicationFrameHandler frame;
    private MainOptionsPanel mainOptionsPanel;
    private AppearanceOptionsPanel appearanceOptionsPanel;
    private PageRecord<?> mainOptionsExtPage = null;
    private PageRecord<?> appearanceOptionsExtPage = null;
    private JScrollPane optionsAreaScrollPane;
    private JLabel optionsAreaTitleLabel;
    private JPanel optionsAreaTitlePanel;
    private JSplitPane optionsSplitPane;
    private JTree optionsTree;
    private JPanel optionsTreePanel;
    private JScrollPane optionsTreeScrollPane;
    private JSeparator separator;

    public OptionsTreePanel(ApplicationFrameHandler frame) {
        this.frame = frame;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.optionPages = new HashMap();
        this.modified = false;
        this.optionsModifiedListener = () -> this.setModified(true);
        this.addPropertyChangeListener(evt -> {
            if ("modified".equals(evt.getPropertyName())) {
                this.modified = true;
            }
        });
        UIManager.addPropertyChangeListener(evt -> SwingUtilities.updateComponentTreeUI(this));
        this.top = new OptionsMutableTreeNode(this.resourceBundle.getString("options.root.caption"), "options");
        this.optionsTree.setModel(new DefaultTreeModel(this.top, true));
        this.optionsTree.getSelectionModel().addTreeSelectionListener(e -> {
            if (e.getPath() != null) {
                String caption;
                OptionsMutableTreeNode node = (OptionsMutableTreeNode)this.optionsTree.getLastSelectedPathComponent();
                if (node == null) {
                    caption = null;
                    this.optionsAreaTitleLabel.setText("");
                } else {
                    caption = node.getName();
                    this.optionsAreaTitleLabel.setText(" " + (String)node.getUserObject());
                }
                if (this.currentOptionsPanel != null) {
                    this.optionsAreaScrollPane.remove((Component)((PageRecord)this.currentOptionsPanel).panel);
                }
                if (caption != null) {
                    this.currentOptionsPanel = this.optionPages.get(caption);
                    if (this.currentOptionsPanel != null) {
                        this.optionsAreaScrollPane.setViewportView((Component)((PageRecord)this.currentOptionsPanel).panel);
                    } else {
                        this.optionsAreaScrollPane.setViewportView(null);
                    }
                } else {
                    this.currentOptionsPanel = null;
                    this.optionsAreaScrollPane.setViewportView(null);
                }
            }
        });
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void pagesFinished() {
        this.optionsTree.setSelectionRow(0);
        OptionsTreePanel.expandJTree(this.optionsTree, -1);
    }

    private void initComponents() {
        this.optionsSplitPane = new JSplitPane();
        this.optionsTreeScrollPane = new JScrollPane();
        this.optionsTree = new JTree();
        this.optionsTreePanel = new JPanel();
        this.optionsAreaScrollPane = new JScrollPane();
        this.optionsAreaTitlePanel = new JPanel();
        this.optionsAreaTitleLabel = new JLabel();
        this.separator = new JSeparator();
        this.setLayout(new BorderLayout());
        this.optionsSplitPane.setDividerLocation(130);
        this.optionsTreeScrollPane.setViewportView(this.optionsTree);
        this.optionsSplitPane.setLeftComponent(this.optionsTreeScrollPane);
        this.optionsTreePanel.setLayout(new BorderLayout());
        this.optionsTreePanel.add((Component)this.optionsAreaScrollPane, "Center");
        this.optionsAreaTitlePanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.optionsAreaTitlePanel.setLayout(new BorderLayout());
        this.optionsAreaTitleLabel.setBackground(UIManager.getDefaults().getColor("EditorPane.selectionBackground"));
        this.optionsAreaTitleLabel.setForeground(UIManager.getDefaults().getColor("EditorPane.background"));
        this.optionsAreaTitleLabel.setText(this.resourceBundle.getString("optionsAreaTitleLabel.text"));
        this.optionsAreaTitleLabel.setOpaque(true);
        this.optionsAreaTitleLabel.setVerifyInputWhenFocusTarget(false);
        this.optionsAreaTitlePanel.add((Component)this.optionsAreaTitleLabel, "North");
        this.optionsTreePanel.add((Component)this.optionsAreaTitlePanel, "North");
        this.optionsSplitPane.setRightComponent(this.optionsTreePanel);
        this.add((Component)this.optionsSplitPane, "Center");
        this.add((Component)this.separator, "South");
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new OptionsTreePanel(null));
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public void addOptionsPage(OptionsPage<?> optionPage, @Nullable List<OptionsPathItem> path) {
        String panelKey;
        if (path == null) {
            panelKey = "options";
        } else {
            panelKey = path.get(path.size() - 1).getName();
            this.establishPath(path);
        }
        PageRecord pageRecord = new PageRecord(optionPage);
        if (pageRecord.panel instanceof MainOptionsPanel) {
            this.mainOptionsPanel = (MainOptionsPanel)pageRecord.panel;
        } else if (pageRecord.panel instanceof AppearanceOptionsPanel) {
            this.appearanceOptionsPanel = (AppearanceOptionsPanel)pageRecord.panel;
        }
        this.optionPages.put(panelKey, pageRecord);
        pageRecord.panel.setOptionsModifiedListener(this.optionsModifiedListener);
        this.optionsTree.setSelectionRow(0);
    }

    public void extendMainOptionsPage(OptionsPage<?> optionsPage) {
        this.mainOptionsExtPage = new PageRecord(optionsPage);
        this.mainOptionsPanel.addExtendedPanel(((PageRecord)this.mainOptionsExtPage).panel);
    }

    public void extendAppearanceOptionsPage(OptionsPage<?> optionsPage) {
        this.appearanceOptionsExtPage = new PageRecord(optionsPage);
        this.appearanceOptionsPanel.addExtendedPanel(((PageRecord)this.appearanceOptionsExtPage).panel);
    }

    public void loadAllFromPreferences() {
        this.optionPages.values().forEach(pageRecord -> {
            try {
                pageRecord.loadFromPreferences(this.preferences);
            }
            catch (Exception ex) {
                Logger.getLogger(OptionsTreePanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        if (this.mainOptionsExtPage != null) {
            this.mainOptionsExtPage.loadFromPreferences(this.preferences);
        }
        if (this.appearanceOptionsExtPage != null) {
            this.appearanceOptionsExtPage.loadFromPreferences(this.preferences);
        }
    }

    public void saveAndApplyAll() {
        this.optionPages.values().forEach(pageRecord -> {
            try {
                pageRecord.saveAndApply(this.preferences);
            }
            catch (Exception ex) {
                Logger.getLogger(OptionsTreePanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        if (this.mainOptionsExtPage != null) {
            this.mainOptionsExtPage.saveAndApply(this.preferences);
        }
        if (this.appearanceOptionsExtPage != null) {
            this.appearanceOptionsExtPage.saveAndApply(this.preferences);
        }
        OptionsModuleApi optionsModule = (OptionsModuleApi)this.application.getModuleRepository().getModuleByInterface(OptionsModuleApi.class);
        optionsModule.notifyOptionsChanged();
    }

    public void applyPreferencesChanges() {
        this.optionPages.values().forEach(pageRecord -> {
            try {
                pageRecord.applyPreferencesChanges(this.preferences);
            }
            catch (Exception ex) {
                Logger.getLogger(OptionsTreePanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        if (this.mainOptionsExtPage != null) {
            this.mainOptionsExtPage.applyPreferencesChanges(this.preferences);
        }
        if (this.appearanceOptionsExtPage != null) {
            this.appearanceOptionsExtPage.applyPreferencesChanges(this.preferences);
        }
        OptionsModuleApi frameModule = (OptionsModuleApi)this.application.getModuleRepository().getModuleByInterface(OptionsModuleApi.class);
        frameModule.notifyOptionsChanged();
    }

    private void establishPath(List<OptionsPathItem> path) {
        OptionsMutableTreeNode node = this.top;
        for (OptionsPathItem pathItem : path) {
            int childIndex;
            OptionsMutableTreeNode child = null;
            if (node == null) {
                return;
            }
            for (childIndex = 0; childIndex >= 0 && childIndex < node.getChildCount(); ++childIndex) {
                child = (OptionsMutableTreeNode)node.getChildAt(childIndex);
                String name = child.getName();
                if (!name.equals(pathItem.getName())) continue;
                Object caption = child.getUserObject();
                String newCaption = pathItem.getCaption();
                if (!(caption instanceof String) || !name.equals(caption) || name.equals(newCaption)) break;
                child.setUserObject(newCaption);
                break;
            }
            if (childIndex == node.getChildCount()) {
                OptionsMutableTreeNode newNode = new OptionsMutableTreeNode(pathItem.getCaption(), pathItem.getName());
                node.add(newNode);
                node = newNode;
                continue;
            }
            node = child;
        }
        this.optionsTree.setModel(new DefaultTreeModel(this.top, true));
        for (int i = 0; i < this.optionsTree.getRowCount(); ++i) {
            this.optionsTree.expandRow(i);
        }
    }

    public void setPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    public XBApplication getApplication() {
        return this.application;
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    public void addChildComponentListener(LazyComponentListener listener) {
        this.listeners.add(listener);
        for (PageRecord<?> pageRecord : this.optionPages.values()) {
            listener.componentCreated((Component)((PageRecord)pageRecord).panel);
        }
    }

    public void removeChildComponentListener(LazyComponentListener listener) {
        this.listeners.remove(listener);
    }

    public static void expandJTree(JTree tree, int depth) {
        TreeModel model = tree.getModel();
        OptionsTreePanel.expandJTreeNode(tree, model, model.getRoot(), 0, depth);
    }

    public static int expandJTreeNode(JTree tree, TreeModel model, Object node, int row, int depth) {
        if (node != null && !model.isLeaf(node)) {
            tree.expandRow(row);
            if (depth != 0) {
                for (int index = 0; row + 1 < tree.getRowCount() && index < model.getChildCount(node); ++index) {
                    TreePath path;
                    ++row;
                    Object child = model.getChild(node, index);
                    if (child == null) break;
                    while ((path = tree.getPathForRow(row)) != null && path.getLastPathComponent() != child) {
                        ++row;
                    }
                    if (path == null) break;
                    row = OptionsTreePanel.expandJTreeNode(tree, model, child, row, depth - 1);
                }
            }
        }
        return row;
    }

    @ParametersAreNonnullByDefault
    private static class PageRecord<T extends OptionsData> {
        private final OptionsPage<T> page;
        private final OptionsComponent<T> panel;

        PageRecord(OptionsPage<T> page) {
            this.page = page;
            this.panel = page.createPanel();
        }

        void loadFromPreferences(Preferences preferences) {
            OptionsData options = this.page.createOptions();
            this.page.loadFromPreferences(preferences, options);
            this.panel.loadFromOptions(options);
        }

        void saveToPreferences(Preferences preferences) {
            OptionsData options = this.page.createOptions();
            this.panel.saveToOptions(options);
            this.page.saveToPreferences(preferences, options);
        }

        void saveAndApply(Preferences preferences) {
            OptionsData options = this.page.createOptions();
            this.panel.saveToOptions(options);
            this.page.saveToPreferences(preferences, options);
            this.page.applyPreferencesChanges(options);
        }

        void applyPreferencesChanges(Preferences preferences) {
            OptionsData options = this.page.createOptions();
            this.panel.saveToOptions(options);
            this.page.applyPreferencesChanges(options);
        }
    }

    @ParametersAreNonnullByDefault
    private class OptionsMutableTreeNode
    extends DefaultMutableTreeNode {
        private final String name;

        public OptionsMutableTreeNode(Object userObject, String name) {
            super(userObject);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

