/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.options.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import org.exbin.framework.options.api.OptionsComponent;
import org.exbin.framework.options.api.OptionsModifiedListener;
import org.exbin.framework.options.model.LanguageRecord;
import org.exbin.framework.options.options.impl.FrameworkOptionsImpl;
import org.exbin.framework.utils.DesktopUtils;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class MainOptionsPanel
extends JPanel
implements OptionsComponent<FrameworkOptionsImpl> {
    private ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(MainOptionsPanel.class);
    private OptionsModifiedListener optionsModifiedListener;
    private OptionsComponent extendedOptionsPanel = null;
    private String defaultLocaleName = "";
    private JComboBox<String> fontAntialiasingComboBox;
    private JLabel fontAntialiasingLabel;
    private JPanel generalPanel;
    private JComboBox<String> guiScalingComboBox;
    private JLabel guiScalingLabel;
    private JSpinner guiScalingSpinner;
    private JComboBox<LanguageRecord> languageComboBox;
    private JLabel languageLabel;
    private JComboBox<String> macOsAppearanceComboBox;
    private JLabel macOsAppearanceLabel;
    private JPanel macOsOptionsPanel;
    private JPanel mainOptionsBasicPanel;
    private JPanel mainOptionsNotePanel;
    private JComboBox<String> renderingModeComboBox;
    private JLabel renderingModeLabel;
    private JLabel requireRestartLabel;
    private JCheckBox useScreenMenuBarCheckBox;
    private JComboBox<String> visualThemeComboBox;
    private JLabel visualThemeLabel;

    public MainOptionsPanel() {
        this.init();
    }

    private void init() {
        this.initComponents();
        if (DesktopUtils.detectBasicOs() == DesktopUtils.DesktopOs.MAC_OS) {
            this.mainOptionsBasicPanel.add((Component)this.macOsOptionsPanel, "South");
        }
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void loadFromOptions(FrameworkOptionsImpl options) {
        Locale languageLocale = options.getLanguageLocale();
        ComboBoxModel<LanguageRecord> languageComboBoxModel = this.languageComboBox.getModel();
        for (int i = 0; i < languageComboBoxModel.getSize(); ++i) {
            LanguageRecord languageRecord = (LanguageRecord)languageComboBoxModel.getElementAt(i);
            if (!languageLocale.equals(languageRecord.getLocale())) continue;
            this.languageComboBox.setSelectedIndex(i);
            break;
        }
        this.visualThemeComboBox.setSelectedIndex(MainOptionsPanel.findMatchingElement(this.visualThemeComboBox.getModel(), options.getLookAndFeel()));
        this.renderingModeComboBox.setSelectedIndex(MainOptionsPanel.findMatchingElement(this.renderingModeComboBox.getModel(), options.getRenderingMode()));
        this.fontAntialiasingComboBox.setSelectedIndex(MainOptionsPanel.findMatchingElement(this.fontAntialiasingComboBox.getModel(), options.getFontAntialiasing()));
        this.guiScalingComboBox.setSelectedIndex(MainOptionsPanel.findMatchingElement(this.guiScalingComboBox.getModel(), options.getGuiScaling()));
        this.guiScalingSpinner.setValue(Float.valueOf(options.getGuiScalingRate()));
        if (DesktopUtils.detectBasicOs() == DesktopUtils.DesktopOs.MAC_OS) {
            this.macOsAppearanceComboBox.setSelectedIndex(MainOptionsPanel.findMatchingElement(this.macOsAppearanceComboBox.getModel(), options.getMacOsAppearance()));
            this.useScreenMenuBarCheckBox.setSelected(options.isUseScreenMenuBar());
        }
    }

    private static int findMatchingElement(ComboBoxModel<String> model, String value) {
        for (int i = 0; i < model.getSize(); ++i) {
            if (!value.equals(model.getElementAt(i))) continue;
            return i;
        }
        return -1;
    }

    public void saveToOptions(FrameworkOptionsImpl options) {
        options.setLanguageLocale(((LanguageRecord)this.languageComboBox.getSelectedItem()).getLocale());
        options.setLookAndFeel((String)this.visualThemeComboBox.getSelectedItem());
        options.setRenderingMode((String)this.renderingModeComboBox.getSelectedItem());
        options.setFontAntialiasing((String)this.fontAntialiasingComboBox.getSelectedItem());
        options.setGuiScaling((String)this.guiScalingComboBox.getSelectedItem());
        options.setGuiScalingRate(((Float)this.guiScalingSpinner.getValue()).floatValue());
        if (DesktopUtils.detectBasicOs() == DesktopUtils.DesktopOs.MAC_OS) {
            options.setMacOsAppearance((String)this.macOsAppearanceComboBox.getSelectedItem());
            options.setUseScreenMenuBar(this.useScreenMenuBarCheckBox.isSelected());
        }
    }

    public void setLanguageLocales(List<LanguageRecord> languageLocales) {
        DefaultComboBoxModel languageComboBoxModel = new DefaultComboBoxModel();
        languageLocales.forEach(language -> languageComboBoxModel.addElement(language));
        this.languageComboBox.setModel(languageComboBoxModel);
        this.languageComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                DefaultListCellRenderer renderer = (DefaultListCellRenderer)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                LanguageRecord record = (LanguageRecord)value;
                String languageText = record.getText();
                if ("".equals(languageText)) {
                    languageText = MainOptionsPanel.this.defaultLocaleName;
                }
                renderer.setText(languageText);
                ImageIcon flag = record.getFlag();
                if (flag != null) {
                    renderer.setIcon(flag);
                }
                return renderer;
            }
        });
    }

    public void setDefaultLocaleName(String defaultLocaleName) {
        this.defaultLocaleName = defaultLocaleName;
    }

    public void setThemes(List<String> themeKeys, final List<String> themeNames) {
        DefaultComboBoxModel themeComboBoxModel = new DefaultComboBoxModel();
        themeKeys.forEach(themeKey -> themeComboBoxModel.addElement(themeKey));
        this.visualThemeComboBox.setModel(themeComboBoxModel);
        this.visualThemeComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            @Nonnull
            public Component getListCellRendererComponent(JList<?> list, @Nullable Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (index >= 0) {
                    return super.getListCellRendererComponent(list, themeNames.get(index), index, isSelected, cellHasFocus);
                }
                int selectedIndex = MainOptionsPanel.this.visualThemeComboBox.getSelectedIndex();
                return super.getListCellRendererComponent(list, selectedIndex >= 0 ? themeNames.get(selectedIndex) : value, index, isSelected, cellHasFocus);
            }
        });
    }

    public void setRenderingModes(List<String> renderingModeKeys, final List<String> renderingModeNames) {
        DefaultComboBoxModel renderingModeComboBoxModel = new DefaultComboBoxModel();
        renderingModeKeys.forEach(renderingModeKey -> renderingModeComboBoxModel.addElement(renderingModeKey));
        this.renderingModeComboBox.setModel(renderingModeComboBoxModel);
        this.renderingModeComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            @Nonnull
            public Component getListCellRendererComponent(JList<?> list, @Nullable Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (index >= 0) {
                    return super.getListCellRendererComponent(list, renderingModeNames.get(index), index, isSelected, cellHasFocus);
                }
                int selectedIndex = MainOptionsPanel.this.renderingModeComboBox.getSelectedIndex();
                return super.getListCellRendererComponent(list, selectedIndex >= 0 ? renderingModeNames.get(selectedIndex) : value, index, isSelected, cellHasFocus);
            }
        });
    }

    public void setFontAntialiasings(List<String> fontAntialiasingKeys, final List<String> fontAntialiasingNames) {
        DefaultComboBoxModel fontAntialiasingComboBoxModel = new DefaultComboBoxModel();
        fontAntialiasingKeys.forEach(fontAntialiasingKey -> fontAntialiasingComboBoxModel.addElement(fontAntialiasingKey));
        this.fontAntialiasingComboBox.setModel(fontAntialiasingComboBoxModel);
        this.fontAntialiasingComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            @Nonnull
            public Component getListCellRendererComponent(JList<?> list, @Nullable Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (index >= 0) {
                    return super.getListCellRendererComponent(list, fontAntialiasingNames.get(index), index, isSelected, cellHasFocus);
                }
                int selectedIndex = MainOptionsPanel.this.fontAntialiasingComboBox.getSelectedIndex();
                return super.getListCellRendererComponent(list, selectedIndex >= 0 ? fontAntialiasingNames.get(selectedIndex) : value, index, isSelected, cellHasFocus);
            }
        });
    }

    public void setGuiScalings(List<String> guiScalingKeys, final List<String> guiScalingNames) {
        DefaultComboBoxModel guiScalingComboBoxModel = new DefaultComboBoxModel();
        guiScalingKeys.forEach(guiScalingKey -> guiScalingComboBoxModel.addElement(guiScalingKey));
        this.guiScalingComboBox.setModel(guiScalingComboBoxModel);
        this.guiScalingComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            @Nonnull
            public Component getListCellRendererComponent(JList<?> list, @Nullable Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (index >= 0) {
                    return super.getListCellRendererComponent(list, guiScalingNames.get(index), index, isSelected, cellHasFocus);
                }
                int selectedIndex = MainOptionsPanel.this.guiScalingComboBox.getSelectedIndex();
                return super.getListCellRendererComponent(list, selectedIndex >= 0 ? guiScalingNames.get(selectedIndex) : value, index, isSelected, cellHasFocus);
            }
        });
        this.guiScalingComboBox.addItemListener(e -> this.guiScalingSpinner.setEnabled(this.guiScalingComboBox.getSelectedIndex() == guiScalingKeys.size() - 1));
    }

    public void setMacOsAppearances(List<String> macOsAppearancesKeys, final List<String> macOsAppearanceNames) {
        DefaultComboBoxModel macOsAppearanceComboBoxModel = new DefaultComboBoxModel();
        macOsAppearancesKeys.forEach(macOsAppearanceKey -> macOsAppearanceComboBoxModel.addElement(macOsAppearanceKey));
        this.macOsAppearanceComboBox.setModel(macOsAppearanceComboBoxModel);
        this.macOsAppearanceComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            @Nonnull
            public Component getListCellRendererComponent(JList<?> list, @Nullable Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (index >= 0) {
                    return super.getListCellRendererComponent(list, macOsAppearanceNames.get(index), index, isSelected, cellHasFocus);
                }
                int selectedIndex = MainOptionsPanel.this.macOsAppearanceComboBox.getSelectedIndex();
                return super.getListCellRendererComponent(list, selectedIndex >= 0 ? macOsAppearanceNames.get(selectedIndex) : value, index, isSelected, cellHasFocus);
            }
        });
    }

    private void initComponents() {
        this.macOsOptionsPanel = new JPanel();
        this.macOsAppearanceLabel = new JLabel();
        this.macOsAppearanceComboBox = new JComboBox();
        this.useScreenMenuBarCheckBox = new JCheckBox();
        this.mainOptionsBasicPanel = new JPanel();
        this.generalPanel = new JPanel();
        this.languageLabel = new JLabel();
        this.languageComboBox = new JComboBox();
        this.visualThemeLabel = new JLabel();
        this.visualThemeComboBox = new JComboBox();
        this.renderingModeLabel = new JLabel();
        this.renderingModeComboBox = new JComboBox();
        this.fontAntialiasingLabel = new JLabel();
        this.fontAntialiasingComboBox = new JComboBox();
        this.guiScalingLabel = new JLabel();
        this.guiScalingComboBox = new JComboBox();
        this.guiScalingSpinner = new JSpinner();
        this.mainOptionsNotePanel = new JPanel();
        this.requireRestartLabel = new JLabel();
        this.macOsAppearanceLabel.setText(this.resourceBundle.getString("macOsAppearanceLabel.text") + " *");
        this.macOsAppearanceComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MainOptionsPanel.this.macOsAppearanceComboBoxjComboBoxItemStateChanged(evt);
            }
        });
        this.useScreenMenuBarCheckBox.setSelected(true);
        this.useScreenMenuBarCheckBox.setText(this.resourceBundle.getString("useScreenMenuBarCheckBox.text") + " *");
        GroupLayout macOsOptionsPanelLayout = new GroupLayout(this.macOsOptionsPanel);
        this.macOsOptionsPanel.setLayout(macOsOptionsPanelLayout);
        macOsOptionsPanelLayout.setHorizontalGroup(macOsOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(macOsOptionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(macOsOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.macOsAppearanceComboBox, GroupLayout.Alignment.TRAILING, 0, 645, Short.MAX_VALUE).addGroup(macOsOptionsPanelLayout.createSequentialGroup().addComponent(this.macOsAppearanceLabel).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.useScreenMenuBarCheckBox, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        macOsOptionsPanelLayout.setVerticalGroup(macOsOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(macOsOptionsPanelLayout.createSequentialGroup().addComponent(this.macOsAppearanceLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.macOsAppearanceComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.useScreenMenuBarCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
        this.setLayout(new BorderLayout());
        this.mainOptionsBasicPanel.setLayout(new BorderLayout());
        this.languageLabel.setText(this.resourceBundle.getString("languageLabel.text") + " *");
        this.languageComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MainOptionsPanel.this.languageComboBoxItemStateChanged(evt);
            }
        });
        this.visualThemeLabel.setText(this.resourceBundle.getString("visualThemeLabel.text"));
        this.visualThemeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MainOptionsPanel.this.visualThemeComboBoxjComboBoxItemStateChanged(evt);
            }
        });
        this.renderingModeLabel.setText(this.resourceBundle.getString("renderingModeLabel.text") + " *");
        this.renderingModeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MainOptionsPanel.this.renderingModeComboBoxjComboBoxItemStateChanged(evt);
            }
        });
        this.fontAntialiasingLabel.setText(this.resourceBundle.getString("fontAntialiasingLabel.text") + " *");
        this.fontAntialiasingComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MainOptionsPanel.this.fontAntialiasingComboBoxjComboBoxItemStateChanged(evt);
            }
        });
        this.guiScalingLabel.setText(this.resourceBundle.getString("guiScalingLabel.text") + " *");
        this.guiScalingComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MainOptionsPanel.this.guiScalingComboBoxjComboBoxItemStateChanged(evt);
            }
        });
        this.guiScalingComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainOptionsPanel.this.guiScalingComboBoxActionPerformed(evt);
            }
        });
        this.guiScalingSpinner.setModel(new SpinnerNumberModel(Float.valueOf(0.0f), null, null, Float.valueOf(1.0f)));
        this.guiScalingSpinner.setEnabled(false);
        GroupLayout generalPanelLayout = new GroupLayout(this.generalPanel);
        this.generalPanel.setLayout(generalPanelLayout);
        generalPanelLayout.setHorizontalGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE).addGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(generalPanelLayout.createSequentialGroup().addContainerGap().addGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.visualThemeComboBox, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.languageComboBox, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.renderingModeComboBox, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.fontAntialiasingComboBox, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addGroup(generalPanelLayout.createSequentialGroup().addGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.visualThemeLabel).addComponent(this.languageLabel).addComponent(this.renderingModeLabel).addComponent(this.fontAntialiasingLabel).addComponent(this.guiScalingLabel)).addGap(0, 0, Short.MAX_VALUE)).addGroup(generalPanelLayout.createSequentialGroup().addComponent(this.guiScalingComboBox, 0, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.guiScalingSpinner, -2, 90, -2))).addContainerGap())));
        generalPanelLayout.setVerticalGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 266, Short.MAX_VALUE).addGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(generalPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.languageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.languageComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.visualThemeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.visualThemeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.renderingModeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.renderingModeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fontAntialiasingLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fontAntialiasingComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.guiScalingLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.guiScalingComboBox, -2, -1, -2).addComponent(this.guiScalingSpinner, -2, 23, -2)).addContainerGap(-1, Short.MAX_VALUE))));
        this.mainOptionsBasicPanel.add((Component)this.generalPanel, "Center");
        this.add((Component)this.mainOptionsBasicPanel, "North");
        this.requireRestartLabel.setText(this.resourceBundle.getString("requireRestartLabel.text"));
        GroupLayout mainOptionsNotePanelLayout = new GroupLayout(this.mainOptionsNotePanel);
        this.mainOptionsNotePanel.setLayout(mainOptionsNotePanelLayout);
        mainOptionsNotePanelLayout.setHorizontalGroup(mainOptionsNotePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainOptionsNotePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.requireRestartLabel, -1, 376, Short.MAX_VALUE).addContainerGap()));
        mainOptionsNotePanelLayout.setVerticalGroup(mainOptionsNotePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainOptionsNotePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.requireRestartLabel).addContainerGap(-1, Short.MAX_VALUE)));
        this.add((Component)this.mainOptionsNotePanel, "South");
    }

    private void visualThemeComboBoxjComboBoxItemStateChanged(ItemEvent evt) {
        this.notifyModified();
    }

    private void renderingModeComboBoxjComboBoxItemStateChanged(ItemEvent evt) {
        this.notifyModified();
    }

    private void fontAntialiasingComboBoxjComboBoxItemStateChanged(ItemEvent evt) {
        this.notifyModified();
    }

    private void guiScalingComboBoxjComboBoxItemStateChanged(ItemEvent evt) {
        this.notifyModified();
    }

    private void guiScalingComboBoxActionPerformed(ActionEvent evt) {
        this.notifyModified();
    }

    private void languageComboBoxItemStateChanged(ItemEvent evt) {
        this.notifyModified();
    }

    private void macOsAppearanceComboBoxjComboBoxItemStateChanged(ItemEvent evt) {
        this.notifyModified();
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new MainOptionsPanel());
    }

    private void notifyModified() {
        if (this.optionsModifiedListener != null) {
            this.optionsModifiedListener.wasModified();
        }
    }

    public void setOptionsModifiedListener(OptionsModifiedListener listener) {
        this.optionsModifiedListener = listener;
    }

    public void addExtendedPanel(OptionsComponent<?> optionsPanel) {
        if (this.extendedOptionsPanel != null) {
            this.remove((Component)this.extendedOptionsPanel);
        }
        this.extendedOptionsPanel = optionsPanel;
        this.add((Component)this.extendedOptionsPanel, "Center");
        this.extendedOptionsPanel.setOptionsModifiedListener(this.optionsModifiedListener);
    }
}

