/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.options.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.exbin.framework.options.api.OptionsComponent;
import org.exbin.framework.options.api.OptionsModifiedListener;
import org.exbin.framework.options.options.impl.AppearanceOptionsImpl;
import org.exbin.framework.utils.ComponentResourceProvider;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class AppearanceOptionsPanel
extends JPanel
implements OptionsComponent<AppearanceOptionsImpl>,
ComponentResourceProvider {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(AppearanceOptionsPanel.class);
    private OptionsModifiedListener optionsModifiedListener;
    private OptionsComponent extendedPanel = null;
    private JCheckBox showCaptionsCheckBox;
    private JCheckBox showStatusbarCheckBox;
    private JCheckBox showToolbarCheckBox;
    private JPanel toolBarsOptionsPanel;

    public AppearanceOptionsPanel() {
        this.initComponents();
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void loadFromOptions(AppearanceOptionsImpl options) {
        this.showToolbarCheckBox.setSelected(options.isShowToolBar());
        this.showCaptionsCheckBox.setSelected(options.isShowToolBarCaptions());
        this.showStatusbarCheckBox.setSelected(options.isShowStatusBar());
    }

    public void saveToOptions(AppearanceOptionsImpl options) {
        options.setShowToolBar(this.showToolbarCheckBox.isSelected());
        options.setShowToolBarCaptions(this.showCaptionsCheckBox.isSelected());
        options.setShowStatusBar(this.showStatusbarCheckBox.isSelected());
    }

    private void initComponents() {
        this.toolBarsOptionsPanel = new JPanel();
        this.showToolbarCheckBox = new JCheckBox();
        this.showCaptionsCheckBox = new JCheckBox();
        this.showStatusbarCheckBox = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.showToolbarCheckBox.setSelected(true);
        this.showToolbarCheckBox.setText(this.resourceBundle.getString("showToolbarCheckBox.text"));
        this.showToolbarCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                AppearanceOptionsPanel.this.showToolbarCheckBoxjCheckBoxItemStateChanged(evt);
            }
        });
        this.showCaptionsCheckBox.setSelected(true);
        this.showCaptionsCheckBox.setText(this.resourceBundle.getString("showCaptionsCheckBox.text"));
        this.showCaptionsCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                AppearanceOptionsPanel.this.showCaptionsCheckBoxjCheckBoxItemStateChanged(evt);
            }
        });
        this.showStatusbarCheckBox.setSelected(true);
        this.showStatusbarCheckBox.setText(this.resourceBundle.getString("showStatusbarCheckBox.text"));
        this.showStatusbarCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                AppearanceOptionsPanel.this.showStatusbarCheckBoxjCheckBoxItemStateChanged(evt);
            }
        });
        GroupLayout toolBarsOptionsPanelLayout = new GroupLayout(this.toolBarsOptionsPanel);
        this.toolBarsOptionsPanel.setLayout(toolBarsOptionsPanelLayout);
        toolBarsOptionsPanelLayout.setHorizontalGroup(toolBarsOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, toolBarsOptionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(toolBarsOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.showCaptionsCheckBox, -1, 301, Short.MAX_VALUE).addComponent(this.showStatusbarCheckBox, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.showToolbarCheckBox, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        toolBarsOptionsPanelLayout.setVerticalGroup(toolBarsOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(toolBarsOptionsPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.showToolbarCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showCaptionsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showStatusbarCheckBox)));
        this.add((Component)this.toolBarsOptionsPanel, "North");
    }

    private void showToolbarCheckBoxjCheckBoxItemStateChanged(ItemEvent evt) {
        this.setModified(true);
    }

    private void showCaptionsCheckBoxjCheckBoxItemStateChanged(ItemEvent evt) {
        this.setModified(true);
    }

    private void showStatusbarCheckBoxjCheckBoxItemStateChanged(ItemEvent evt) {
        this.setModified(true);
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new AppearanceOptionsPanel());
    }

    private void setModified(boolean modified) {
        if (this.optionsModifiedListener != null) {
            this.optionsModifiedListener.wasModified();
        }
    }

    public void setOptionsModifiedListener(OptionsModifiedListener listener) {
        this.optionsModifiedListener = listener;
    }

    public void addExtendedPanel(OptionsComponent<?> optionsPanel) {
        if (this.extendedPanel != null) {
            this.remove((Component)this.extendedPanel);
        }
        this.extendedPanel = optionsPanel;
        this.add((Component)this.extendedPanel, "Center");
        this.extendedPanel.setOptionsModifiedListener(this.optionsModifiedListener);
    }
}

