/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.options;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.exbin.framework.api.LanguageProvider;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.options.GuiFontAntialiasing;
import org.exbin.framework.options.GuiMacOsAppearance;
import org.exbin.framework.options.GuiRenderingMethod;
import org.exbin.framework.options.GuiScaling;
import org.exbin.framework.options.api.DefaultOptionsPage;
import org.exbin.framework.options.api.OptionsComponent;
import org.exbin.framework.options.api.OptionsPage;
import org.exbin.framework.options.gui.MainOptionsPanel;
import org.exbin.framework.options.model.LanguageRecord;
import org.exbin.framework.options.options.impl.FrameworkOptionsImpl;
import org.exbin.framework.preferences.FrameworkPreferences;
import org.exbin.framework.utils.DesktopUtils;
import org.exbin.framework.utils.LanguageUtils;

@ParametersAreNonnullByDefault
public class MainOptionsManager {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(MainOptionsManager.class);
    private XBApplication application;
    private boolean valuesInitialized = false;
    private List<String> themes;
    private List<String> themeNames;
    private List<LanguageRecord> languageLocales = null;
    private List<String> renderingMethodKeys;
    private List<String> renderingMethodNames;
    private List<String> fontAntialiasingNames;
    private List<String> guiScalingKeys;
    private List<String> guiScalingNames;
    private List<String> guiMacOsAppearanceNames;
    private List<String> guiMacOsAppearancesKeys;
    private List<String> macOsAppearancesKeys;

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    public void initValues() {
        String propertyValue;
        boolean extraCrossPlatformLAF;
        this.themes = new ArrayList<String>();
        this.themes.add("");
        boolean bl = extraCrossPlatformLAF = !"javax.swing.plaf.metal.MetalLookAndFeel".equals(UIManager.getCrossPlatformLookAndFeelClassName());
        if (extraCrossPlatformLAF) {
            this.themes.add(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        this.themes.add("javax.swing.plaf.metal.MetalLookAndFeel");
        this.themes.add("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
        this.themeNames = new ArrayList<String>();
        this.themeNames.add(this.resourceBundle.getString("theme.defaultTheme"));
        if (extraCrossPlatformLAF) {
            this.themeNames.add(this.resourceBundle.getString("theme.crossPlatformTheme"));
        }
        this.themeNames.add("Metal");
        this.themeNames.add("Motif");
        UIManager.LookAndFeelInfo[] infos = UIManager.getInstalledLookAndFeels();
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : infos) {
            if (this.themes.contains(lookAndFeelInfo.getClassName())) continue;
            this.themes.add(lookAndFeelInfo.getClassName());
            this.themeNames.add(lookAndFeelInfo.getName());
        }
        this.languageLocales = new ArrayList<LanguageRecord>();
        this.languageLocales.add(new LanguageRecord(Locale.ROOT, null));
        this.languageLocales.add(new LanguageRecord(new Locale("en", "US"), new ImageIcon(this.getClass().getResource(this.resourceBundle.getString("locale.englishFlag")))));
        for (LanguageProvider languageProvider : this.application.getLanguagePlugins()) {
            ImageIcon flag = null;
            try {
                flag = languageProvider.getFlag().orElse(null);
            }
            catch (Throwable ex) {
                Logger.getLogger(MainOptionsManager.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.languageLocales.add(new LanguageRecord(languageProvider.getLocale(), flag, null));
        }
        this.renderingMethodKeys = new ArrayList<String>();
        this.renderingMethodNames = new ArrayList<String>();
        DesktopUtils.DesktopOs desktopOs = DesktopUtils.detectBasicOs();
        for (GuiRenderingMethod renderingMethod : GuiRenderingMethod.getAvailableMethods()) {
            this.renderingMethodKeys.add(renderingMethod.getPropertyValue());
            if (renderingMethod == GuiRenderingMethod.DEFAULT) {
                this.renderingMethodNames.add(this.resourceBundle.getString("renderingMethod.default"));
                continue;
            }
            if (renderingMethod == GuiRenderingMethod.SOFTWARE && desktopOs == DesktopUtils.DesktopOs.WINDOWS) {
                this.renderingMethodNames.add(this.resourceBundle.getString("renderingMethod.software.windows"));
                continue;
            }
            propertyValue = renderingMethod.getPropertyValue();
            this.renderingMethodNames.add(this.resourceBundle.getString("renderingMethod." + propertyValue));
        }
        this.macOsAppearancesKeys = new ArrayList<String>();
        this.fontAntialiasingNames = new ArrayList<String>();
        for (GuiFontAntialiasing fontAntialiasing : GuiFontAntialiasing.getAvailable()) {
            this.macOsAppearancesKeys.add(fontAntialiasing.getPropertyValue());
            if (fontAntialiasing == GuiFontAntialiasing.DEFAULT) {
                this.fontAntialiasingNames.add(this.resourceBundle.getString("fontAntialiasing.default"));
                continue;
            }
            propertyValue = fontAntialiasing.getPropertyValue();
            this.fontAntialiasingNames.add(this.resourceBundle.getString("fontAntialiasing." + propertyValue));
        }
        this.guiScalingKeys = new ArrayList<String>();
        this.guiScalingNames = new ArrayList<String>();
        for (GuiScaling guiScaling : GuiScaling.getAvailable()) {
            this.guiScalingKeys.add(guiScaling.getPropertyValue());
            if (guiScaling == GuiScaling.DEFAULT) {
                this.guiScalingNames.add(this.resourceBundle.getString("guiScaling.default"));
                continue;
            }
            propertyValue = guiScaling.getPropertyValue();
            this.guiScalingNames.add(this.resourceBundle.getString("guiScaling." + propertyValue));
        }
        if (DesktopUtils.detectBasicOs() == DesktopUtils.DesktopOs.MAC_OS) {
            List<GuiMacOsAppearance> guiMacOsAppearances = GuiMacOsAppearance.getAvailable();
            this.guiMacOsAppearancesKeys = new ArrayList<String>();
            this.guiMacOsAppearanceNames = new ArrayList<String>();
            for (GuiMacOsAppearance macOsAppearance : guiMacOsAppearances) {
                this.guiMacOsAppearancesKeys.add(macOsAppearance.getPropertyValue());
                this.macOsAppearancesKeys.add(macOsAppearance.getPropertyValue());
                if (macOsAppearance == GuiMacOsAppearance.DEFAULT) {
                    this.guiMacOsAppearanceNames.add(this.resourceBundle.getString("macOsAppearances.default"));
                    continue;
                }
                String propertyValue2 = macOsAppearance.getPropertyValue();
                this.guiMacOsAppearanceNames.add(this.resourceBundle.getString("macOsAppearances." + propertyValue2));
            }
        }
    }

    @Nonnull
    public OptionsPage<FrameworkOptionsImpl> getMainOptionsPage() {
        return new DefaultOptionsPage<FrameworkOptionsImpl>(){

            @Nonnull
            public OptionsComponent<FrameworkOptionsImpl> createPanel() {
                if (!MainOptionsManager.this.valuesInitialized) {
                    MainOptionsManager.this.valuesInitialized = true;
                    MainOptionsManager.this.initValues();
                }
                MainOptionsPanel mainOptionsPanel = new MainOptionsPanel();
                mainOptionsPanel.setThemes(MainOptionsManager.this.themes, MainOptionsManager.this.themeNames);
                mainOptionsPanel.setDefaultLocaleName("<" + MainOptionsManager.this.resourceBundle.getString("locale.defaultLanguage") + ">");
                mainOptionsPanel.setLanguageLocales(MainOptionsManager.this.languageLocales);
                mainOptionsPanel.setRenderingModes(MainOptionsManager.this.renderingMethodKeys, MainOptionsManager.this.renderingMethodNames);
                mainOptionsPanel.setFontAntialiasings(MainOptionsManager.this.macOsAppearancesKeys, MainOptionsManager.this.fontAntialiasingNames);
                mainOptionsPanel.setGuiScalings(MainOptionsManager.this.guiScalingKeys, MainOptionsManager.this.guiScalingNames);
                if (DesktopUtils.detectBasicOs() == DesktopUtils.DesktopOs.MAC_OS) {
                    mainOptionsPanel.setMacOsAppearances(MainOptionsManager.this.guiMacOsAppearancesKeys, MainOptionsManager.this.guiMacOsAppearanceNames);
                }
                return mainOptionsPanel;
            }

            @Nonnull
            public ResourceBundle getResourceBundle() {
                return LanguageUtils.getResourceBundleByClass(MainOptionsPanel.class);
            }

            @Nonnull
            public FrameworkOptionsImpl createOptions() {
                return new FrameworkOptionsImpl();
            }

            public void loadFromPreferences(Preferences preferences, FrameworkOptionsImpl options) {
                FrameworkPreferences prefs = new FrameworkPreferences(preferences);
                options.loadFromPreferences(prefs);
            }

            public void saveToPreferences(Preferences preferences, FrameworkOptionsImpl options) {
                FrameworkPreferences prefs = new FrameworkPreferences(preferences);
                options.saveToParameters(prefs);
            }

            public void applyPreferencesChanges(FrameworkOptionsImpl options) {
                String selectedTheme = options.getLookAndFeel();
                MainOptionsManager.this.application.applyLookAndFeel(selectedTheme);
            }
        };
    }
}

