unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, Menus, StdCtrls, Printers, XBDoc;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    SaveAs1: TMenuItem;
    Save1: TMenuItem;
    MenuOpen1: TMenuItem;
    MenuNew1: TMenuItem;
    Edit1: TMenuItem;
    BackgroundColor1: TMenuItem;
    Font1: TMenuItem;
    Wrap1: TMenuItem;
    Paste1: TMenuItem;
    Copy1: TMenuItem;
    Cut1: TMenuItem;
    Help1: TMenuItem;
    MenuAbout1: TMenuItem;
    StatusBar1: TStatusBar;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    FontDialog1: TFontDialog;
    ColorDialog1: TColorDialog;
    Line1: TMenuItem;
    XBDocument1: TXBDocument;
    Properties1: TMenuItem;
    Options: TMenuItem;
    SelectAll1: TMenuItem;
    MenuView1: TMenuItem;
    MenuStatusBar1: TMenuItem;
    Bookmarks1: TMenuItem;
    AddBookmark1: TMenuItem;
    Line3: TMenuItem;
    MenuBack1: TMenuItem;
    Odstranit1: TMenuItem;
    Line2: TMenuItem;
    PrintSetup1: TMenuItem;
    Print1: TMenuItem;
    PrintDialog1: TPrintDialog;
    PrinterSetupDialog1: TPrinterSetupDialog;
    procedure SaveAs1Click(Sender: TObject);
    procedure Font1Click(Sender: TObject);
    procedure BackgroundColor1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Wrap1Click(Sender: TObject);
    procedure MenuAbout1Click(Sender: TObject);
    procedure MenuOpen1Click(Sender: TObject);
    procedure MenuNew1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Cut1Click(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure Paste1Click(Sender: TObject);
    procedure Memo1Change(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SelectAll1Click(Sender: TObject);
    procedure Odstranit1Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure PrintSetup1Click(Sender: TObject);
    procedure MenuStatusBar1Click(Sender: TObject);
  private
    DirectSave: Boolean;
    Modified: Boolean;
    FormName: String;
    procedure ShowHint(Sender: TObject);
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.ShowHint(Sender: TObject);
begin
  StatusBar1.SimpleText:= Application.Hint;
end;

procedure TForm1.MenuNew1Click(Sender: TObject);
begin
  Memo1.Lines.Clear;
  DirectSave:= False;
  Modified:= False;
  Form1.Caption:= FormName;
end;

procedure TForm1.SaveAs1Click(Sender: TObject);
begin
  if (SaveDialog1.Execute) then begin
    DirectSave:= True;
    Save1Click(Sender);
  end;
end;

procedure TForm1.Save1Click(Sender: TObject);
begin
  if DirectSave then begin
    Memo1.Lines.SaveToFile(SaveDialog1.FileName);
    Form1.Caption:= SaveDialog1.Filename + ' - ' + FormName;
    Modified:= False;
  end else SaveAs1Click(Sender);
end;

procedure TForm1.Font1Click(Sender: TObject);
begin
  FontDialog1.Font:= Memo1.Font;
  if (FontDialog1.Execute) then begin
    Memo1.Font:= FontDialog1.Font;
  end;
end;

procedure TForm1.BackgroundColor1Click(Sender: TObject);
begin
  ColorDialog1.Color:= Memo1.Color;
  if (ColorDialog1.Execute) then begin
    Memo1.Color:= ColorDialog1.Color;
  end;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.Wrap1Click(Sender: TObject);
begin
  Wrap1.Checked:= not Wrap1.Checked;
  Memo1.WordWrap:= Wrap1.Checked;
  if (Wrap1.Checked) then begin
    Memo1.ScrollBars:= ssVertical;
  end else Memo1.ScrollBars:= ssBoth;
end;

procedure TForm1.MenuAbout1Click(Sender: TObject);
begin
  ShowMessage('(C) BOMI: Miroslav Hajda'+Chr(13)+'demonstrace formtu XBUF');
end;

procedure TForm1.MenuOpen1Click(Sender: TObject);
begin
  if OpenDialog1.Execute then begin
    Memo1.Lines.LoadFromFile(OpenDialog1.FileName);
    SaveDialog1.FileName:= OpenDialog1.FileName;
    DirectSave:= True;
    Modified:= False;
    Form1.Caption:= OpenDialog1.Filename + ' - ' + FormName;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  DirectSave:= False;
  Modified:= False;
  Application.OnHint:= ShowHint;
  FormName:= Caption;
end;

procedure TForm1.Print1Click(Sender: TObject);
begin
  if PrintDialog1.Execute then with Printer do begin
    Title:= Form1.Caption;
    try
      with Printer.Canvas do begin
        TextOut(0,0,Memo1.Lines.Text);
      end;
      Printer.EndDoc;
    except
      on Exception do begin
        Printer.Abort;
        Printer.EndDoc;
        raise;
      end;
    end;
  end;
end;

procedure TForm1.PrintSetup1Click(Sender: TObject);
begin
  PrinterSetupDialog1.Execute;
end;

procedure TForm1.Cut1Click(Sender: TObject);
begin
  Memo1.CutToClipboard;
end;

procedure TForm1.Copy1Click(Sender: TObject);
begin
  Memo1.CopyToClipboard;
end;

procedure TForm1.Paste1Click(Sender: TObject);
begin
  Memo1.PasteFromClipboard;
end;

procedure TForm1.Odstranit1Click(Sender: TObject);
begin
  Memo1.ClearSelection;
end;

procedure TForm1.SelectAll1Click(Sender: TObject);
begin
  Memo1.SelectAll;
end;

procedure TForm1.Memo1Change(Sender: TObject);
begin
  Modified:= True;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
var
  MDRes: Word;
begin
  while (Modified)and(not (Action=caNone)) do begin
    MDRes:= MessageDlg('Uloit zmny?', mtConfirmation, [mbYes, mbNo, mbCancel], 0);
    if (MDRes = mrCancel) then Action:=caNone
    else if (MDRes = mrNo) then Modified:=False
    else Save1Click(nil);
  end;
end;

procedure TForm1.MenuStatusBar1Click(Sender: TObject);
begin
  StatusBar1.Visible:= not StatusBar1.Visible;
  MenuStatusBar1.Checked:= StatusBar1.Visible;
end;

end.
