unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, XBDoc, ComCtrls, MPlayer, Buttons, ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    XBDocument1: TXBDocument;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    MenuNew1: TMenuItem;
    MenuOpen1: TMenuItem;
    Save1: TMenuItem;
    SaveAs1: TMenuItem;
    Properties1: TMenuItem;
    Line2: TMenuItem;
    Exit1: TMenuItem;
    Edit1: TMenuItem;
    MenuBack1: TMenuItem;
    Line3: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    Odstranit1: TMenuItem;
    SelectAll1: TMenuItem;
    MenuView1: TMenuItem;
    MenuStatusBar1: TMenuItem;
    Options1: TMenuItem;
    Help1: TMenuItem;
    MenuAbout1: TMenuItem;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    StatusBar1: TStatusBar;
    MediaPlayer1: TMediaPlayer;
    Panel1: TPanel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    ScrollBox1: TScrollBox;
    PaintBox1: TPaintBox;
    ViewMode1: TMenuItem;
    Shape1: TShape;
    Shape2: TShape;
    Label1: TLabel;
    Timer1: TTimer;
    procedure MenuStatusBar1Click(Sender: TObject);
    procedure MenuOpen1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Save1Click(Sender: TObject);
    procedure SaveAs1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure MediaPlayer1Notify(Sender: TObject);
    procedure PaintBox1Paint(Sender: TObject);
    procedure MenuAbout1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure PaintBox1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Shape1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Shape1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Shape1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Timer1Timer(Sender: TObject);
    procedure PaintBox1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure PaintBox1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    DirectSave: Boolean;
    VolumeChange: Boolean;
    Modified: Boolean;
    FormName: String;
    Selecting: Boolean;
    Sliding: Boolean;
    SelectFrom: Integer;
    SelectTo: Integer;
    procedure ShowHint(Sender: TObject);
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.ShowHint(Sender: TObject);
begin
  StatusBar1.SimpleText := Application.Hint;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  DirectSave := False;
  Modified := False;
  VolumeChange := False;
  Application.OnHint := ShowHint;
  FormName := Caption;
  SelectFrom := -1;
  SelectTo := -1;
  Selecting := False;
  Sliding := False;
end;

procedure TForm1.MenuStatusBar1Click(Sender: TObject);
begin
  StatusBar1.Visible:= not StatusBar1.Visible;
  if StatusBar1.Visible then StatusBar1.Top:= Panel1.Top + Panel1.Height;
  MenuStatusBar1.Checked:= StatusBar1.Visible;
end;

procedure TForm1.MenuOpen1Click(Sender: TObject);
begin
  if OpenDialog1.Execute then begin
    MediaPlayer1.FileName:= OpenDialog1.FileName;
    MediaPlayer1.Open;
    DirectSave:= True;
    Modified:= False;
    PaintBox1.Width:= MediaPlayer1.Length;
    ScrollBox1.Color:= clWhite; 
    PaintBox1.Repaint;
    Form1.Caption:= OpenDialog1.Filename + ' - ' + FormName;
  end;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
var
  MDRes: Word;
begin
  while (Modified)and(not (Action=caNone)) do begin
    MDRes:= MessageDlg('Uloit zmny?', mtConfirmation, [mbYes, mbNo, mbCancel], 0);
    if (MDRes = mrCancel) then Action:=caNone
    else if (MDRes = mrNo) then Modified:=False
    else Save1Click(nil);
  end;
end;

procedure TForm1.Save1Click(Sender: TObject);
begin
  if DirectSave then begin
//    Memo1.Lines.SaveToFile(SaveDialog1.FileName);
    Form1.Caption:= SaveDialog1.Filename + ' - ' + FormName;
    Modified:= False;
  end else SaveAs1Click(Sender);
end;

procedure TForm1.SaveAs1Click(Sender: TObject);
begin
  if (SaveDialog1.Execute) then begin
    DirectSave:= True;
    Save1Click(Sender);
  end;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
  MediaPlayer1.Play;
  PaintBox1.RePaint;
end;

procedure TForm1.MediaPlayer1Notify(Sender: TObject);
begin
  // Notify
end;

procedure TForm1.PaintBox1Paint(Sender: TObject);
var
  I: Integer;
  J: Integer;
begin
  // Paint me
  with PaintBox1.Canvas do begin
    Brush.Style:= bsClear;
    Pen.Color:= clWhite;
    Brush.Color:= clWhite;
    Rectangle(ScrollBox1.HorzScrollBar.Position,0,ScrollBox1.HorzScrollBar.Position+ScrollBox1.Width,PaintBox1.Height);
    if (SelectFrom >= 0) and (SelectTo >= 0) then begin
      Brush.Color := clBlue;
      Rectangle(SelectFrom,0,SelectTo,PaintBox1.Height);
    end;
    Pen.Color:= clGreen;
    J:= (ScrollBox1.HorzScrollBar.Position mod 400);
    MoveTo(ScrollBox1.HorzScrollBar.Position, J);
    for I:=0 to ScrollBox1.Width do begin
      J:= ((ScrollBox1.HorzScrollBar.Position+I) mod 400);
      if J<0 then J:=0 else if J>PaintBox1.Height then J:= PaintBox1.Height;
      LineTo(ScrollBox1.HorzScrollBar.Position+I,J);
    end;
    Pen.Color:= clBlack;
    Pen.Mode:= pmNot;
    Brush.Style:= bsSolid;
    Brush.Color:= clBlue;
    Rectangle(MediaPlayer1.Position-2,0,MediaPlayer1.Position+2,PaintBox1.Height);
    Pen.Mode:= pmCopy;
  end;
end;

procedure TForm1.MenuAbout1Click(Sender: TObject);
begin
  ShowMessage('(C) BOMI: Miroslav Hajda'+Chr(13)+'demonstrace formtu XBUF');
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
begin
  MediaPlayer1.Pause;
  if MediaPlayer1.Position<ScrollBox1.HorzScrollBar.Position then ScrollBox1.HorzScrollBar.Position:= MediaPlayer1.Position else
  if MediaPlayer1.Position>ScrollBox1.HorzScrollBar.Position+(ScrollBox1.Width div 2) then ScrollBox1.HorzScrollBar.Position:= MediaPlayer1.Position - (ScrollBox1.Width div 2);
  PaintBox1.RePaint;
end;

procedure TForm1.SpeedButton3Click(Sender: TObject);
begin
  MediaPlayer1.Stop;
  MediaPlayer1.Rewind;
  PaintBox1.RePaint;
end;

procedure TForm1.Shape1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if Button=mbLeft then begin
    Shape2.Width := X+1;
    VolumeChange := True;
  end;
end;

procedure TForm1.Shape1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if VolumeChange then if (X>=Shape1.Width) then Shape2.Width:= Shape1.Width else
   if X<0 then Shape2.Width:= 0 else Shape2.Width:= X+1;
end;

procedure TForm1.Shape1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if Button=mbLeft then VolumeChange:= False;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  if MediaPlayer1.Mode = mpPlaying then begin
    PaintBox1.Repaint;
    if MediaPlayer1.Position<ScrollBox1.HorzScrollBar.Position then ScrollBox1.HorzScrollBar.Position:= MediaPlayer1.Position else
    if MediaPlayer1.Position>ScrollBox1.HorzScrollBar.Position+(ScrollBox1.Width div 2) then ScrollBox1.HorzScrollBar.Position:= MediaPlayer1.Position - (ScrollBox1.Width div 2);
    Sliding := False;
  end;
end;

procedure TForm1.PaintBox1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  Playing: Boolean;
begin
  if Button=mbLeft then begin
    Playing:= MediaPlayer1.Mode = mpPlaying;
    MediaPlayer1.Position:= X;
    if Playing then MediaPlayer1.Play;
  end else if Button=mbRight then begin
    if ssShift in Shift then begin
      SelectTo := X;
    end else begin
      SelectFrom := X;
      SelectTo := X;
      Selecting := True;
    end;
  end;
  PaintBox1.RePaint;
end;

procedure TForm1.PaintBox1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if Selecting then begin
    SelectTo := X;
    PaintBox1.RePaint;
  end;
end;

procedure TForm1.PaintBox1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  Selecting := False;
end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
  Playing: Boolean;
  I: Integer;
begin
  if PaintBox1.Width>0 then begin
    Playing := MediaPlayer1.Mode = mpPlaying;
    if Key=vk_Right then begin
      if MediaPlayer1.Position<MediaPlayer1.Length then begin
        if MediaPlayer1.Position<MediaPlayer1.Length-100 then
         MediaPlayer1.Position := MediaPlayer1.Position + 100 else
        MediaPlayer1.Position := MediaPlayer1.Length;
      end;
    end else if Key=VK_Left then begin
      if MediaPlayer1.Position>0 then begin
        if MediaPlayer1.Position>100 then
         MediaPlayer1.Position := MediaPlayer1.Position - 100 else
        MediaPlayer1.Position := 0;
      end;
    end;
    if Playing then MediaPlayer1.Play;
    PaintBox1.Repaint;
    if MediaPlayer1.Position<ScrollBox1.HorzScrollBar.Position then ScrollBox1.HorzScrollBar.Position:= MediaPlayer1.Position else
    if Playing then begin
      if MediaPlayer1.Position>ScrollBox1.HorzScrollBar.Position+(ScrollBox1.Width div 2) then ScrollBox1.HorzScrollBar.Position:= MediaPlayer1.Position - (ScrollBox1.Width div 2);
    end else if MediaPlayer1.Position>ScrollBox1.HorzScrollBar.Position+ScrollBox1.Width-4 then ScrollBox1.HorzScrollBar.Position:= MediaPlayer1.Position - ScrollBox1.Width+4;
    if Playing then begin
      Sliding := True;
      while Sliding do Application.ProcessMessages;
    end;
  end;
end;

end.
